/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.formplugin.accountacceptance;

import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.tmc.fbp.common.enums.InnerAcctAcceptStatusEnum;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.ifm.formplugin.resource.IfmFormResourceEnum;

public class InnerAccountAcceptanceList
extends AbstractListPlugin {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"tblhandle"});
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        List commonFilterColumns = args.getCommonFilterColumns();
        for (FilterColumn filterColumn : commonFilterColumns) {
            CommonFilterColumn commonFilter = (CommonFilterColumn)filterColumn;
            String fieldName = commonFilter.getFieldName();
            if ("company.name".equals(fieldName) || "openorg.name".equals(fieldName) || "businesstype".equals(fieldName)) {
                commonFilter.setDefaultValue("");
                continue;
            }
            if (!"businessstatus".equals(fieldName)) continue;
            commonFilter.setDefaultValue(InnerAcctAcceptStatusEnum.WAIT.getValue());
        }
    }

    private void showBackReason() {
        FormShowParameter parameter = new FormShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setAppId("ifm");
        parameter.setFormId("ifm_payacceptance_back");
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "back_action"));
        this.getView().showForm(parameter);
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        OperationResult operationResult = afterDoOperationEventArgs.getOperationResult();
        if (operationResult == null || !operationResult.isSuccess()) {
            return;
        }
        switch (operateKey) {
            case "preback": {
                this.showBackReason();
                break;
            }
            case "presubmit": {
                this.getView().invokeOperation("submit");
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if (Objects.equals("back_action", actionId)) {
            HashMap returnData = (HashMap)closedCallBackEvent.getReturnData();
            if (returnData == null) {
                return;
            }
            BillList billList = (BillList)this.getControl("billlistap");
            ListSelectedRowCollection selectedRows = billList.getSelectedRows();
            DynamicObject[] dynamicObjects = new DynamicObject[selectedRows.size()];
            for (int i = 0; i < selectedRows.size(); ++i) {
                Long primaryKeyValue = (Long)selectedRows.get(i).getPrimaryKeyValue();
                DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)primaryKeyValue, (String)"ifm_accountacceptancebill");
                dynamicObject.set("businessstatus", (Object)InnerAcctAcceptStatusEnum.BACKED.getValue());
                dynamicObject.set("backreason", returnData.get("reason"));
                dynamicObjects[i] = dynamicObject;
            }
            OperateOption option = OperateOption.create();
            option.setVariableValue("strictvalidation", String.valueOf(true));
            TmcOperateServiceHelper.execOperate((String)"back", (String)"ifm_accountacceptancebill", (DynamicObject[])dynamicObjects, (OperateOption)option);
            billList.refreshData();
            this.getView().showSuccessNotification(IfmFormResourceEnum.InnerAccountAcceptanceList_0.loadKDString());
        }
    }
}

