/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.formplugin.bizdeal;

import java.util.Date;
import java.util.EventObject;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.formplugin.edit.AbstractTmcBillEdit;

public class BizDealRepayEdit
extends AbstractTmcBillEdit
implements HyperLinkClickListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid loans = (EntryGrid)this.getControl("loans");
        if (loans != null) {
            loans.addHyperClickListener((HyperLinkClickListener)this);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String fieldName = e.getProperty().getName();
        Object newValue = e.getChangeSet()[0].getNewValue();
        switch (fieldName) {
            case "bizdate": {
                DynamicObject billDyn = this.getModel().getDataEntity();
                Date bizDate = (Date)newValue;
                this.setSummary(billDyn, bizDate);
                break;
            }
        }
    }

    public void afterLoadData(EventObject e) {
        DynamicObject billDyn = this.getModel().getDataEntity();
        boolean isCallInt = billDyn.getBoolean("iscallint");
        this.setInterestEntryShowOrNot(isCallInt);
        Date bizdate = billDyn.getDate("bizdate");
        this.setSummary(billDyn, bizdate);
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        String fieldName = evt.getFieldName();
        if ("loan_loanbill".equals(fieldName)) {
            this.hyper2LoanBill(evt);
        }
    }

    private void hyper2LoanBill(HyperLinkClickEvent evt) {
        int rowIndex = evt.getRowIndex();
        if (rowIndex > -1) {
            DynamicObject entryRowEntity = this.getModel().getEntryRowEntity("loans", rowIndex);
            DynamicObject loanBill = entryRowEntity.getDynamicObject("loan_loanbill");
            if (EmptyUtil.isNoEmpty((DynamicObject)loanBill)) {
                BillShowParameter parameter = new BillShowParameter();
                parameter.setFormId("cfm_loanbill_b_l");
                parameter.setPkId((Object)loanBill.getLong("id"));
                parameter.setStatus(OperationStatus.VIEW);
                parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                this.getView().showForm((FormShowParameter)parameter);
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u6240\u67e5\u8be2\u7684\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u540e\u518d\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"BizDealRepayEdit_2", (String)"tmc-ifm-formplugin", (Object[])new Object[0]));
            }
        }
    }

    private void setInterestEntryShowOrNot(Boolean showFlag) {
        this.getView().setVisible(showFlag, new String[]{"fs_interestcal"});
    }

    private void setSummary(DynamicObject billDyn, Date bizDate) {
        if (bizDate == null) {
            return;
        }
        OrmLocaleValue localVal = (OrmLocaleValue)this.getModel().getValue("summary");
        if (EmptyUtil.isNoEmpty((Object)localVal) && EmptyUtil.isNoEmpty((String)localVal.getLocaleValue())) {
            return;
        }
        boolean isCallInt = billDyn.getBoolean("iscallint");
        String tmp = ResManager.loadKDString((String)"\u5408\u540c\u5355\u636e\u53f7%1$s %2$d\u5e74%3$d\u6708%4$d\u65e5\u8fd8\u6b3e%5$s%6$s%7$s", (String)"BizDealRepayEdit_0", (String)"tmc-ifm-formplugin", (Object[])new Object[0]);
        String summary = String.format(tmp, this.getModel().getValue("contractbillno"), DateUtils.getYear((Date)bizDate), DateUtils.getMonth((Date)bizDate), DateUtils.getDay((Date)bizDate), billDyn.getString("currency.name"), billDyn.getString("currency.sign"), String.valueOf(billDyn.getBigDecimal("repayamount").setScale(billDyn.getInt("currency.amtprecision"), 4)));
        if (isCallInt) {
            tmp = ResManager.loadKDString((String)"\u5408\u540c\u5355\u636e\u53f7%1$s %2$d\u5e74%3$d\u6708%4$d\u65e5\u8fd8\u6b3e%5$s%6$s%7$s\u4ed8\u606f%8$s%9$s%10$s", (String)"BizDealRepayEdit_1", (String)"tmc-ifm-formplugin", (Object[])new Object[0]);
            summary = String.format(tmp, this.getModel().getValue("contractbillno"), DateUtils.getYear((Date)bizDate), DateUtils.getMonth((Date)bizDate), DateUtils.getDay((Date)bizDate), billDyn.getString("currency.name"), billDyn.getString("currency.sign"), String.valueOf(billDyn.getBigDecimal("repayamount").setScale(billDyn.getInt("currency.amtprecision"), 4)), billDyn.getString("currency.name"), billDyn.getString("currency.sign"), String.valueOf(billDyn.getBigDecimal("actinterest").setScale(billDyn.getInt("currency.amtprecision"), 4)));
        }
        this.getModel().setValue("summary", (Object)summary);
    }
}

