/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.formplugin.common;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import kd.bos.form.IFormView;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.list.BillList;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbp.common.enums.CreditorTypeEnum;
import kd.tmc.fbp.common.helper.SettleCenterHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.formplugin.list.AbstractTmcListPlugin;
import kd.tmc.ifm.helper.TransDetailHelper;

public class BankCebterFilterList
extends AbstractTmcListPlugin {
    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        super.filterContainerBeforeF7Select(args);
        if (args.getFieldName().startsWith("settlecenter.")) {
            QFilter filter = new QFilter("id", "in", this.getAuthorizedBankCenterIds());
            args.getQfilters().add(filter);
        }
    }

    public void filterColumnSetFilter(SetFilterEvent args) {
        Set<Long> bankIds;
        super.filterColumnSetFilter(args);
        if (args.getFieldName().startsWith("settlecenter.") && EmptyUtil.isNoEmpty(bankIds = this.getAuthorizedBankCenterIds())) {
            QFilter filter = new QFilter("id", "in", this.getAuthorizedBankCenterIds());
            args.getQFilters().add(filter);
        }
    }

    public void setFilter(SetFilterEvent e) {
        QFilter filter = new QFilter("creditortype", "=", (Object)CreditorTypeEnum.SETTLECENTER.getValue());
        if (!"ifm_bizdealbill".equals(this.getDataEntityName())) {
            filter = filter.and(QFilter.isNotNull((String)"settlestatus"));
        }
        List filters = e.getQFilters();
        for (QFilter fi : filters) {
            if (!fi.getProperty().equals(this.getBankCenterField())) continue;
            return;
        }
        for (int index = filters.size() - 1; index >= 0; --index) {
            QFilter fi;
            fi = (QFilter)filters.get(index);
            if (!fi.getProperty().equals("lendernature")) continue;
            filters.remove(fi);
        }
        Set<Long> bankIds = this.getAuthorizedBankCenterIds();
        if (EmptyUtil.isNoEmpty(bankIds)) {
            filter = filter.and(new QFilter(this.getBankCenterField(), "in", bankIds));
            e.getQFilters().add(filter);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        if (args.getOperationResult() == null || !args.getOperationResult().isSuccess()) {
            return;
        }
        switch (args.getOperateKey()) {
            case "innerdetail": {
                BillList billList = (BillList)this.getControl("billlistap");
                String entityName = billList.getEntityType().getName();
                TransDetailHelper.showInnerDetails((IFormView)this.getView(), (String)entityName, (List)this.getSelectedIdList());
            }
        }
    }

    protected String getBankCenterField() {
        return "settlecenter.id";
    }

    private Set<Long> getAuthorizedBankCenterIds() {
        String appId = this.getView().getFormShowParameter().getAppId();
        if (EmptyUtil.isNoEmpty((String)appId)) {
            return SettleCenterHelper.hasPermissionSettleCenter((String)appId, (String)this.getDataEntityName(), (String)this.getPermissionItem());
        }
        return Collections.emptySet();
    }
}

