/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.formplugin.common;

import java.math.BigDecimal;
import java.util.EventObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.tmc.fbp.common.helper.SystemStatusCtrolHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.formplugin.edit.AbstractTmcBillEdit;
import kd.tmc.ifm.helper.TransBillHelper;

public abstract class ExchangeRateEdit
extends AbstractTmcBillEdit {
    private static final String[] RATE_PROP = new String[]{"basecurrency", "exratetable", "exrate", "localamt", "quotation"};

    public void afterCreateNewData(EventObject e) {
        this.setBaseCurrencyAndRateTable();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        Object scorg = this.getModel().getValue("scorg");
        if (EmptyUtil.isNoEmpty((Object)scorg)) {
            this.isBaseCurrencyRate(((DynamicObject)scorg).getLong("id"));
        } else {
            this.getView().setVisible(Boolean.valueOf(false), RATE_PROP);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propName;
        switch (propName = e.getProperty().getName()) {
            case "scorg": {
                this.setBaseCurrencyAndRateTable();
                break;
            }
            case "exratetable": 
            case "exrate": {
                this.setLocalAmt();
            }
        }
    }

    private void setBaseCurrencyAndRateTable() {
        DynamicObject scorg = (DynamicObject)this.getModel().getValue("scorg");
        if (scorg != null) {
            this.isBaseCurrencyRate(scorg.getLong("id"));
            DynamicObject systemStatusCtrol = SystemStatusCtrolHelper.getSystemStatusCtrol((long)scorg.getLong("id"));
            if (systemStatusCtrol != null) {
                DynamicObject currency = systemStatusCtrol.getDynamicObject("standardcurrency");
                DynamicObject exrateTable = systemStatusCtrol.getDynamicObject("exratetable");
                this.getModel().setValue("basecurrency", currency != null ? currency.getPkValue() : null);
                this.getModel().setValue("exratetable", exrateTable != null ? exrateTable.getPkValue() : null);
                if (EmptyUtil.isAnyoneEmpty((Object[])new Object[]{currency, exrateTable})) {
                    this.getModel().setValue("exrate", (Object)BigDecimal.ONE);
                }
            } else {
                this.removeRate();
            }
        } else {
            this.removeRate();
        }
    }

    protected void setLocalAmt() {
        BigDecimal exrate = (BigDecimal)this.getModel().getValue("exrate");
        if (EmptyUtil.isEmpty((BigDecimal)exrate)) {
            exrate = BigDecimal.ONE;
            this.getModel().setValue("exrate", (Object)exrate);
        }
        BigDecimal actPayamt = (BigDecimal)this.getModel().getValue(this.getBizAmount());
        String quotaTion = (String)this.getModel().getValue("quotation");
        DynamicObject baseCurrency = (DynamicObject)this.getModel().getValue("basecurrency");
        int round = baseCurrency != null ? baseCurrency.getInt("amtprecision") : 10;
        this.getModel().setValue("localamt", (Object)TransBillHelper.getLocalAmt((BigDecimal)actPayamt, (BigDecimal)exrate, (String)quotaTion, (int)round));
    }

    private void isBaseCurrencyRate(Long orgId) {
        boolean isBaseCurrencyRate = TransBillHelper.isBaseCurrencyRate((long)orgId);
        this.getView().setVisible(Boolean.valueOf(isBaseCurrencyRate), RATE_PROP);
        if (isBaseCurrencyRate) {
            TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (String[])RATE_PROP);
        }
    }

    private void removeRate() {
        this.getModel().setValue("basecurrency", null);
        this.getModel().setValue("exratetable", null);
        this.getModel().setValue("exrate", (Object)BigDecimal.ONE);
    }

    protected String getBizAmount() {
        return "actpayamt";
    }
}

