/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.formplugin.common;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.IFormView;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.list.BillList;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.helper.SettleCenterHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.formplugin.list.AbstractTmcListPlugin;
import kd.tmc.ifm.helper.IfmSettleCenterHelper;
import kd.tmc.ifm.helper.TransDetailHelper;
import kd.tmc.ifm.resource.IfmBizResource;

public class SettleCenterFilterList
extends AbstractTmcListPlugin {
    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        super.filterContainerBeforeF7Select(args);
        if (args.getFieldName().startsWith("settlecenter.")) {
            QFilter filter = new QFilter("id", "in", this.getAuthorizedBankCenterIds());
            args.getQfilters().add(filter);
        }
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        List commonFilterColumns = args.getCommonFilterColumns();
        String reportQueryParam = this.getView().getFormShowParameter().getCustomParams().getOrDefault("isquerydefault", "");
        for (FilterColumn filterColumn : commonFilterColumns) {
            long currentOrgId;
            DynamicObject settleCenter;
            CommonFilterColumn commonFilter = (CommonFilterColumn)filterColumn;
            String fieldName = commonFilter.getFieldName();
            if (!fieldName.startsWith("settlecenter.") || !EmptyUtil.isEmpty((Object)reportQueryParam) || null == (settleCenter = IfmSettleCenterHelper.getSettleFinByOrg((Long)(currentOrgId = RequestContext.get().getOrgId())))) continue;
            commonFilter.setDefaultValue(settleCenter.getString("id"));
        }
    }

    public void filterColumnSetFilter(SetFilterEvent args) {
        Set<Long> bankIds;
        super.filterColumnSetFilter(args);
        if (args.getFieldName().startsWith("settlecenter.") && EmptyUtil.isNoEmpty(bankIds = this.getAuthorizedBankCenterIds())) {
            QFilter filter = new QFilter("id", "in", this.getAuthorizedBankCenterIds());
            args.getQFilters().add(filter);
        }
    }

    private Set<Long> getAuthorizedBankCenterIds() {
        String appId = this.getView().getFormShowParameter().getAppId();
        if (EmptyUtil.isNoEmpty((String)appId)) {
            return SettleCenterHelper.hasPermissionSettleCenter((String)appId, (String)this.getDataEntityName(), (String)this.getPermissionItem());
        }
        return Collections.emptySet();
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        if (args.getOperationResult() == null || !args.getOperationResult().isSuccess()) {
            return;
        }
        switch (args.getOperateKey()) {
            case "innerdetail": {
                BillList billList = (BillList)this.getControl("billlistap");
                String entityName = billList.getEntityType().getName();
                List<Long> selectedIdList = this.getCurrentintbillIds(entityName);
                if ("ifm_intbill_batch_current".equals(entityName)) {
                    entityName = "ifm_currentintbill";
                } else if ("ifm_intbill_batch_loan".equals(entityName)) {
                    entityName = "ifm_interestbill";
                }
                TransDetailHelper.showInnerDetails((IFormView)this.getView(), (String)entityName, selectedIdList);
            }
        }
    }

    private List<Long> getCurrentintbillIds(String entityName) {
        List selectedIdList = this.getSelectedIdList();
        if (EmptyUtil.isEmpty((Collection)selectedIdList) || "ifm_currentintbill".equals(entityName)) {
            return selectedIdList;
        }
        DynamicObjectCollection currentBills = QueryServiceHelper.query((String)entityName, (String)"entry.intbillid", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)selectedIdList)});
        List<Long> intBillIds = currentBills.stream().filter(o -> EmptyUtil.isNoEmpty((Long)o.getLong("entry.intbillid"))).map(o -> o.getLong("entry.intbillid")).collect(Collectors.toList());
        if (EmptyUtil.isEmpty(intBillIds)) {
            this.getView().showTipNotification(IfmBizResource.getNoDetail());
        }
        return intBillIds;
    }
}

