/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.formplugin.common;

import java.util.EventObject;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.formplugin.edit.AbstractTmcBillEdit;
import kd.tmc.ifm.enums.AcctClassifyEnum;
import kd.tmc.ifm.enums.FeePayerEnum;

public class TransBillFeeEdit
extends AbstractTmcBillEdit
implements BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit settleType = (BasedataEdit)this.getView().getControl("feecurrency");
        settleType.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit feeBank = (BasedataEdit)this.getView().getControl("feeactbank");
        feeBank.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key;
        switch (key = e.getProperty().getName()) {
            case "iscrosspay": 
            case "agentpayeraccount": {
                this.isCrossPayProp();
                break;
            }
            case "singlestream": {
                this.setFeeBankAccountProp();
                this.singleStreamProp();
                break;
            }
            case "feeactbank": {
                this.setFeeBankAccountProp();
                break;
            }
            case "feepayer": {
                this.feePayerProp();
                break;
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        String key;
        switch (key = event.getProperty().getName()) {
            case "feecurrency": {
                this.feeCurrencyF7(event);
                break;
            }
            case "feeactbank": {
                this.feeActBankF7(event);
                break;
            }
        }
    }

    private void feeActBankF7(BeforeF7SelectEvent event) {
        ListShowParameter showPara = (ListShowParameter)event.getFormShowParameter();
        List qFilters = showPara.getListFilterParameter().getQFilters();
        DynamicObjectCollection load = QueryServiceHelper.query((String)"am_accountbank", (String)"id", (QFilter[])new QFilter[]{new QFilter("bank.bank_cate.number", "=", (Object)"BC-9999").or(new QFilter("acctclassify", "=", (Object)AcctClassifyEnum.INNER_ACCOUNT.getValue()))});
        List accoutIds = load.stream().map(d -> d.getLong("id")).collect(Collectors.toList());
        if (EmptyUtil.isNoEmpty(accoutIds)) {
            qFilters.add(new QFilter("id", "not in", accoutIds));
        }
    }

    private void feeCurrencyF7(BeforeF7SelectEvent event) {
        DynamicObject payBankAccount = (DynamicObject)this.getModel().getValue("feeactbank");
        if (EmptyUtil.isEmpty((DynamicObject)payBankAccount)) {
            return;
        }
        if (EmptyUtil.isEmpty((DynamicObject)(payBankAccount = TmcDataServiceHelper.loadSingleFromCache((Object)payBankAccount.getLong("id"), (String)"bd_accountbanks", (String)"currency")))) {
            return;
        }
        DynamicObjectCollection currencys = payBankAccount.getDynamicObjectCollection("currency");
        Set curIds = currencys.stream().map(o -> o.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toSet());
        if (EmptyUtil.isNoEmpty(curIds)) {
            ListShowParameter showPara = (ListShowParameter)event.getFormShowParameter();
            showPara.getListFilterParameter().getQFilters().add(new QFilter("id", "in", curIds));
        }
    }

    private void setFeeBankAccountProp() {
        DynamicObject payBankAccount = (DynamicObject)this.getModel().getValue("feeactbank");
        if (EmptyUtil.isEmpty((DynamicObject)payBankAccount)) {
            return;
        }
        this.setFeeCurrency(payBankAccount);
    }

    private void feePayerProp() {
        String feePayer = (String)this.getModel().getValue("feepayer");
        if (FeePayerEnum.isRec((String)feePayer) || EmptyUtil.isNoEmpty((Object)this.getModel().getValue("feeactbank"))) {
            return;
        }
        this.setFeeBankAccountCur();
    }

    private void singleStreamProp() {
        boolean isSingleStream = (Boolean)this.getModel().getValue("singlestream");
        if (isSingleStream) {
            return;
        }
        this.setFeeBankAccountCur();
    }

    private void isCrossPayProp() {
        boolean val = (Boolean)this.getModel().getValue("iscrosspay");
        if (!val) {
            return;
        }
        this.setFeeBankAccountCur();
    }

    private void setFeeBankAccountCur() {
        DynamicObject payBankAccount = (DynamicObject)this.getModel().getValue("agentpayeraccount");
        this.getModel().setValue("feeactbank", payBankAccount != null ? payBankAccount.getPkValue() : null);
        this.setFeeCurrency(payBankAccount);
    }

    private void setFeeCurrency(DynamicObject payBankAccount) {
        boolean singleAm = (Boolean)this.getModel().getValue("singlestream");
        this.getView().setEnable(Boolean.valueOf(singleAm), new String[]{"feecurrency"});
        if (!singleAm) {
            DynamicObject currency = (DynamicObject)this.getModel().getValue("currency");
            this.getModel().setValue("feecurrency", EmptyUtil.isNoEmpty((DynamicObject)currency) ? Long.valueOf(currency.getLong("id")) : null);
            return;
        }
        if (payBankAccount != null) {
            DynamicObject defaultcurrency = (payBankAccount = TmcDataServiceHelper.loadSingleFromCache((Object)payBankAccount.getLong("id"), (String)"bd_accountbanks", (String)"currency,defaultcurrency")) != null ? payBankAccount.getDynamicObject("defaultcurrency") : null;
            this.getModel().setValue("feecurrency", defaultcurrency != null ? defaultcurrency.getPkValue() : null);
            DynamicObjectCollection currencys = payBankAccount != null ? payBankAccount.getDynamicObjectCollection("currency") : null;
            this.getView().setEnable(Boolean.valueOf(currencys != null && currencys.size() > 1), new String[]{"feecurrency"});
        }
    }
}

