/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.formplugin.crosspay;

import com.kingdee.bos.ctrl.common.util.StringUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.formplugin.edit.AbstractTmcBillEdit;

public class CrossPayCommonEdit
extends AbstractTmcBillEdit
implements BeforeF7SelectListener {
    protected void initControlEvi() {
        super.initControlEvi();
        BasedataEdit crossTypeEdit = (BasedataEdit)this.getControl("crosstrantype");
        crossTypeEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.initFieldStyle(true);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propName;
        super.propertyChanged(e);
        switch (propName = e.getProperty().getName()) {
            case "payeebank": {
                this.handPayeeBankChange();
                break;
            }
            case "paybank": {
                this.handPayBankChange();
                break;
            }
            case "agentfinorg": {
                this.handAgentFinOrgChange();
                break;
            }
            case "iscrosspay": 
            case "agentpayeraccount": {
                this.defaultCrossType();
                break;
            }
            case "crosstrantype": {
                this.initFieldStyle(false);
                break;
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String propName = evt.getProperty().getName();
        if ("crosstrantype".equals(propName)) {
            this.handCrossTranTypeFilter(evt);
        }
    }

    private void handPayeeBankChange() {
        if (this.isDeduction()) {
            this.defaultRecInfo(false);
        }
        this.dealCrossPay();
    }

    private void handPayBankChange() {
        if (this.isDeduction()) {
            this.dealCrossPay();
            this.defaultCrossType();
        }
    }

    private void handAgentFinOrgChange() {
        this.dealCrossPay();
        this.defaultCrossType();
    }

    private void initFieldStyle(boolean isBindData) {
        this.defaultRecInfo(isBindData);
        IDataModel model = this.getModel();
        DynamicObject crossTranType = (DynamicObject)model.getValue("crosstrantype");
        if (null == crossTranType) {
            return;
        }
        crossTranType = TmcDataServiceHelper.loadSingle((Object)crossTranType.getPkValue(), (String)"bei_crosstrantype");
        Map<String, String> fieldsMap = this.getFieldsMap();
        DynamicObjectCollection entries = crossTranType.getDynamicObjectCollection("entry");
        for (DynamicObject entry : entries) {
            String fieldKey = entry.getString("fieldkey");
            String string = fieldKey = "transtype".equals(fieldKey) ? "transtypes" : fieldKey;
            if (!fieldsMap.containsKey(fieldKey)) continue;
            this.setCrossFieldDefValue(isBindData, fieldKey, entry);
        }
    }

    private void setCrossFieldDefValue(boolean isBindData, String fieldName, DynamicObject entry) {
        boolean isVisible = entry.getBoolean("issee");
        this.getView().setVisible(Boolean.valueOf(isVisible), new String[]{fieldName});
        if (!isVisible) {
            return;
        }
        Control fieldControl = this.getControl(fieldName);
        String defaultValue = entry.getString("defaultvalue");
        if (fieldControl instanceof ComboEdit) {
            ComboEdit fieldCombox = (ComboEdit)fieldControl;
            String limitValue = entry.getString("comboxvalue");
            String virtValue = null;
            if (entry.getBoolean("islimitvalue")) {
                virtValue = entry.getString("virtualvalue");
            }
            List<ComboItem> conmboxItems = this.buildCombox(limitValue, virtValue);
            ComboProp property = (ComboProp)this.getModel().getDataEntityType().getProperties().get((Object)fieldName);
            if (property != null && EmptyUtil.isEmpty((Collection)property.getComboItems())) {
                fieldCombox.setComboItems(conmboxItems);
            } else {
                List comBoxItems = conmboxItems.stream().map(o -> o.getValue()).collect(Collectors.toList());
                TmcViewInputHelper.resetComboItems(comBoxItems, (String)fieldName, (IFormView)this.getView());
            }
        } else if (fieldControl instanceof BasedataEdit) {
            defaultValue = entry.getString("defaultvalueid");
        }
        if (!isBindData && EmptyUtil.isNoEmpty((Object)defaultValue)) {
            this.getModel().setValue(fieldName, (Object)defaultValue);
        }
    }

    private List<ComboItem> buildCombox(String limitValue, String virtValue) {
        ArrayList<String> valueStr = new ArrayList<String>();
        String[] limitValues = limitValue.split(",");
        if (!StringUtil.isEmptyString((String)virtValue)) {
            String[] virtValues = virtValue.split(",");
            block0: for (String kv : virtValues) {
                for (String ltKv : limitValues) {
                    if (!ltKv.startsWith((String)kv + ":")) continue;
                    valueStr.add(ltKv);
                    continue block0;
                }
            }
        } else {
            valueStr.addAll(Arrays.asList(limitValues));
        }
        ArrayList<ComboItem> comboxItems = new ArrayList<ComboItem>(valueStr.size());
        for (String value : valueStr) {
            String[] keyValues = value.split(":");
            if (keyValues.length < 2) continue;
            ComboItem item = new ComboItem(new LocaleString(keyValues[1]), keyValues[0]);
            comboxItems.add(item);
        }
        return comboxItems;
    }

    private void handCrossTranTypeFilter(BeforeF7SelectEvent evt) {
        DynamicObject agentBank = this.getAgentBank();
        if (null == agentBank) {
            String errorMsg = this.isDeduction() ? ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4ed8\u6b3e\u94f6\u884c\u3002", (String)"CrossPayCommonEdit_1", (String)"tmc-ifm-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5f00\u6237\u884c\u3002", (String)"CrossPayCommonEdit_2", (String)"tmc-ifm-formplugin", (Object[])new Object[0]);
            this.getView().showErrorNotification(errorMsg);
            evt.setCancel(true);
        }
        ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
        showParameter.getListFilterParameter().getQFilters().add(this.getBankCateFilter());
    }

    private QFilter getBankCateFilter() {
        DynamicObject bankCate;
        DynamicObject agentBank = this.getAgentBank();
        DynamicObject dynamicObject = bankCate = null == agentBank ? null : agentBank.getDynamicObject("bank_cate");
        if (null != bankCate) {
            return new QFilter("bankcate", "=", bankCate.getPkValue());
        }
        return new QFilter("bankcate", "=", (Object)0);
    }

    private void dealCrossPay() {
        DynamicObject payeeBank = (DynamicObject)this.getModel().getValue("payeebank");
        DynamicObject agentBank = this.getAgentBank();
        DynamicObject payeeBankCountry = this.getCountry(payeeBank);
        DynamicObject agentBankCountry = this.getCountry(agentBank);
        boolean isCrossPay = !this.isChina(payeeBankCountry) || !this.isChina(agentBankCountry);
        this.getView().setEnable(Boolean.valueOf(!isCrossPay), new String[]{"iscrosspay"});
        this.setValue("iscrosspay", isCrossPay);
    }

    private void defaultRecInfo(boolean isBindData) {
        if (isBindData) {
            return;
        }
        DynamicObject payeeBank = (DynamicObject)this.getModel().getValue("payeebank");
        if (null != payeeBank) {
            payeeBank = TmcDataServiceHelper.loadSingleFromCache((Object)payeeBank.getPkValue(), (String)"bd_bebank");
            this.setValue("reccountry", payeeBank.getDynamicObject("country").getPkValue());
            DynamicObject province = payeeBank.getDynamicObject("province");
            DynamicObject city = payeeBank.getDynamicObject("city");
            if (null != province) {
                this.setValue("recprovince", province.getString("name"));
            } else if (null != city) {
                this.setValue("recprovince", city.getString("name"));
            }
            if (null != city) {
                this.setValue("reccity", city.getString("name"));
            }
        }
    }

    private void defaultCrossType() {
        boolean isCrossPay = (Boolean)this.getModel().getValue("iscrosspay");
        if (isCrossPay) {
            if (this.isNeedUpdate()) {
                QFilter filter = this.getBankCateFilter();
                DynamicObjectCollection crossTranTypes = QueryServiceHelper.query((String)"bei_crosstrantype", (String)"id,isdefault", (QFilter[])new QFilter[]{filter});
                DynamicObject defaultCrossType = this.getDefaultCrossType((DynamicObject[])crossTranTypes.toArray((Object[])new DynamicObject[0]));
                if (null != defaultCrossType) {
                    this.setValue("crosstrantype", defaultCrossType.getLong("id"));
                } else {
                    this.setValue("crosstrantype", null);
                }
            }
        } else {
            this.setValue("crosstrantype", null);
        }
    }

    private void setValue(String key, Object value) {
        if (value instanceof DynamicObject) {
            DynamicObject dy = (DynamicObject)value;
            this.getModel().setValue(key, dy.getPkValue());
        } else {
            this.getModel().setValue(key, value);
        }
    }

    private boolean isDeduction() {
        return this.getView().getEntityId().equals("ifm_deduction");
    }

    private boolean isChina(DynamicObject country) {
        return null == country || "001".equals(country.getString("number")) || "China".equals(country.getString("name")) || ResManager.loadKDString((String)"\u4e2d\u56fd", (String)"CrossPayCommonEdit_0", (String)"tmc-ifm-formplugin", (Object[])new Object[0]).equals(country.getString("name"));
    }

    private DynamicObject getCountry(DynamicObject bank) {
        if (null == bank) {
            return null;
        }
        bank = TmcDataServiceHelper.loadSingleFromCache((Object)bank.getPkValue(), (DynamicObjectType)bank.getDynamicObjectType());
        return bank.getDynamicObject("country");
    }

    private DynamicObject getAgentBank() {
        DynamicObject agentBank = !this.isDeduction() ? (DynamicObject)this.getModel().getValue("agentfinorg") : (DynamicObject)this.getModel().getValue("paybank");
        if (null != agentBank) {
            agentBank = TmcDataServiceHelper.loadSingleFromCache((Object)agentBank.getPkValue(), (String)"bd_finorginfo");
        }
        return agentBank;
    }

    private Map<String, String> getFieldsMap() {
        HashMap<String, String> fieldMap = new HashMap<String, String>(16);
        MainEntityType entity = EntityMetadataCache.getDataEntityType((String)this.getView().getEntityId());
        DataEntityPropertyCollection properties = entity.getProperties();
        for (IDataEntityProperty property : properties) {
            if (property instanceof EntryProp) {
                EntryProp p = (EntryProp)property;
                DataEntityPropertyCollection entryProps = p.getDynamicCollectionItemPropertyType().getProperties();
                entryProps.forEach(prop -> fieldMap.put(prop.getName(), "entry"));
                continue;
            }
            fieldMap.put(property.getName(), "head");
        }
        return fieldMap;
    }

    private DynamicObject getDefaultCrossType(DynamicObject[] crossTranTypes) {
        if (crossTranTypes == null || crossTranTypes.length == 0) {
            return null;
        }
        DynamicObject defaultObj = crossTranTypes[0];
        for (DynamicObject crossTranType : crossTranTypes) {
            if (!crossTranType.getBoolean("isdefault")) continue;
            return crossTranType;
        }
        return defaultObj;
    }

    private boolean isNeedUpdate() {
        DynamicObject agentBank = this.getAgentBank();
        if (null == agentBank) {
            return true;
        }
        DynamicObject bankCate = agentBank.getDynamicObject("bank_cate");
        if (null == bankCate) {
            return true;
        }
        DynamicObject crossTranType = (DynamicObject)this.getModel().getValue("crosstrantype");
        if (null == crossTranType) {
            return true;
        }
        return crossTranType.getDynamicObject("bankcate").getLong("id") != bankCate.getLong("id");
    }
}

