/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.formplugin.dailysettle;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Control;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbp.common.enums.TmcAppEnum;
import kd.tmc.fbp.common.enums.UseStatusEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.ifm.helper.IfmSettleCenterHelper;

public class DailySettleEdit
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnok"});
        BasedataEdit basedataEdit = (BasedataEdit)this.getControl("settlecenter");
        basedataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        Long orgId = RequestContext.get().getOrgId();
        QFilter[] qFilters = new QFilter[]{new QFilter("scorg.id", "=", (Object)orgId), new QFilter("usestatus", "=", (Object)UseStatusEnum.STARTED.getValue())};
        Object[] list = TmcDataServiceHelper.load((String)"ifm_settcentersetting", (String)"settlecenter", (QFilter[])qFilters);
        if (EmptyUtil.isNoEmpty((Object[])list)) {
            DynamicObject dynamicObject = list[0].getDynamicObject("settlecenter");
            this.getModel().setValue("settlecenter", (Object)dynamicObject);
            this.initFormData();
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key;
        super.propertyChanged(e);
        switch (key = e.getProperty().getName()) {
            case "settlecenter": {
                this.initFormData();
                break;
            }
            case "operatetype": 
            case "bizdate": 
            case "days": {
                this.updateAcceptDate();
                break;
            }
            case "acceptdate": {
                this.updateDays();
            }
        }
    }

    private void initFormData() {
        DynamicObject selectItem = (DynamicObject)this.getModel().getValue("settlecenter");
        this.getModel().setValue("days", (Object)1);
        this.getModel().setValue("operatetype", (Object)"A");
        if (EmptyUtil.isNoEmpty((DynamicObject)selectItem)) {
            Long finOrgId = selectItem.getLong("id");
            Date acceptDate = IfmSettleCenterHelper.getAcceptDate((Long)finOrgId);
            this.getModel().setValue("bizdate", (Object)acceptDate);
            this.getModel().setValue("acceptdate", (Object)DateUtils.getNextDay((Date)acceptDate, (int)1));
        } else {
            this.getModel().setValue("bizdate", null);
            this.getModel().setValue("acceptdate", null);
        }
    }

    private void updateAcceptDate() {
        Date bizdate = (Date)this.getModel().getValue("bizdate");
        Date accetpdate = null;
        if (EmptyUtil.isNoEmpty((Object)bizdate)) {
            String operateType = (String)this.getModel().getValue("operatetype");
            int days = ((BigDecimal)this.getModel().getValue("days")).intValue();
            if (StringUtils.equals((CharSequence)operateType, (CharSequence)"B")) {
                days = -days;
            }
            accetpdate = DateUtils.getNextDay((Date)bizdate, (int)days);
        }
        this.getModel().setValue("acceptdate", accetpdate);
    }

    private void updateDays() {
        int days = 1;
        Date bizdate = (Date)this.getModel().getValue("bizdate");
        Date acceptdate = (Date)this.getModel().getValue("acceptdate");
        String operateType = "A";
        if (EmptyUtil.isNoEmpty((Object)bizdate) && EmptyUtil.isNoEmpty((Object)acceptdate)) {
            int diffDays = DateUtils.getDiffDays((Date)bizdate, (Date)acceptdate) - 1;
            operateType = diffDays < 0 ? "B" : "A";
            int absDays = Math.abs(diffDays);
            days = absDays == 0 ? 1 : Math.min(1000, absDays);
        }
        this.getModel().setValue("days", (Object)days);
        this.getModel().setValue("operatetype", (Object)operateType);
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        String fieldKey = event.getProperty().getName();
        if (StringUtils.equals((CharSequence)"settlecenter", (CharSequence)fieldKey)) {
            List scIds = IfmSettleCenterHelper.getAuthorizedRegisteredSettleCenterIds((Long)RequestContext.get().getCurrUserId(), (String)TmcAppEnum.IFM.getValue(), (String)"ifm_settcentersetting", (String)"47150e89000000ac");
            ListShowParameter showParameter = (ListShowParameter)event.getFormShowParameter();
            QFilter filter = new QFilter("id", "in", (Object)scIds);
            showParameter.getListFilterParameter().getQFilters().add(filter);
        }
    }

    public void click(EventObject evt) {
        if (evt.getSource() instanceof Control && StringUtils.equals((CharSequence)"btnok", (CharSequence)((Control)evt.getSource()).getKey())) {
            DynamicObject settleCenter = (DynamicObject)this.getModel().getValue("settlecenter");
            if (EmptyUtil.isEmpty((DynamicObject)settleCenter)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u4e2a\u8981\u64cd\u4f5c\u7684\u7ed3\u7b97\u4e2d\u5fc3", (String)"DailySettleEdit_7", (String)"tmc-ifm-formplugin", (Object[])new Object[0]));
                return;
            }
            Long scId = (Long)settleCenter.getPkValue();
            Date bizdate = (Date)this.getModel().getValue("bizdate");
            Date acceptdate = (Date)this.getModel().getValue("acceptdate");
            String operateType = (String)this.getModel().getValue("operatetype");
            String desc = "A".equals(operateType) ? this.checkForDailySettle(scId, bizdate) : this.checkForUnDailySettle(scId, bizdate, acceptdate);
            if (EmptyUtil.isNoEmpty((String)desc)) {
                this.getView().showConfirm(desc, MessageBoxOptions.YesNo, ConfirmTypes.Default, new ConfirmCallBackListener("DAILY_SETTLE_CALLBACK", (IFormPlugin)this));
            } else {
                this.execDailySettle();
            }
        }
    }

    private String checkForDailySettle(Long pkId, Date bizdate) {
        Date queryDate = DateUtils.truncateDate((Date)DateUtils.getNextDay((Date)bizdate, (int)1));
        Object[] accountbills = TmcDataServiceHelper.load((String)"ifm_accountacceptancebill", (String)"id,billno,company", (QFilter[])new QFilter[]{new QFilter("bank.id", "=", (Object)pkId), new QFilter("businessstatus", "=", (Object)"A")});
        Object[] paybills = TmcDataServiceHelper.load((String)"ifm_payacceptancebill", (String)"id,billno,org", (QFilter[])new QFilter[]{new QFilter("payeracctbank.bank.id", "=", (Object)pkId), new QFilter("bizstatus", "=", (Object)"A"), new QFilter("bizdate", "<", (Object)queryDate)});
        Object[] loanbills = TmcDataServiceHelper.load((String)"ifm_bizdealbill", (String)"id,billno,org", (QFilter[])new QFilter[]{new QFilter("settlecenter.id", "=", (Object)pkId), new QFilter("businessstatus", "=", (Object)"A"), new QFilter("applidate", "<", (Object)queryDate)});
        if (EmptyUtil.isEmpty((Object[])accountbills) && EmptyUtil.isEmpty((Object[])paybills) && EmptyUtil.isEmpty((Object[])loanbills)) {
            return null;
        }
        String accTip = "";
        String payTip = "";
        String loanTip = "";
        if (EmptyUtil.isNoEmpty((Object[])accountbills)) {
            String accInfoList = Arrays.stream(accountbills).map(d -> d.getDynamicObject("company").getString("name") + ":" + d.getString("billno")).collect(Collectors.joining(";"));
            accTip = String.format(ResManager.loadKDString((String)"\u5b58\u5728\u672a\u53d7\u7406\u7684\u5185\u90e8\u8d26\u6237\u8d26\u6237%1$s\u4e2a\u3010%2$s\u3011\uff1b", (String)"DailySettleEdit_0", (String)"tmc-ifm-formplugin", (Object[])new Object[0]), accountbills.length, accInfoList);
        }
        if (EmptyUtil.isNoEmpty((Object[])paybills)) {
            String payInfoList = Arrays.stream(paybills).map(d -> d.getDynamicObject("org").getString("name") + ":" + d.getString("billno")).collect(Collectors.joining(";"));
            payTip = String.format(ResManager.loadKDString((String)"\u4e1a\u52a1\u65e5\u671f\u5c0f\u4e8e\u7b49\u4e8e\u5f53\u524d\u53d7\u7406\u65e5\u671f\u7684\u672a\u53d7\u7406\u7ed3\u7b97\u5355\u636e%1$s\u6761\u3010%2$s\u3011\uff1b", (String)"DailySettleEdit_4", (String)"tmc-ifm-formplugin", (Object[])new Object[0]), paybills.length, payInfoList);
        }
        if (EmptyUtil.isNoEmpty((Object[])loanbills)) {
            String loanInfoList = Arrays.stream(loanbills).map(d -> d.getDynamicObject("org").getString("name") + ":" + d.getString("billno")).collect(Collectors.joining(";"));
            loanTip = String.format(ResManager.loadKDString((String)"\u7533\u8bf7\u65e5\u671f\u5c0f\u4e8e\u7b49\u4e8e\u5f53\u524d\u53d7\u7406\u65e5\u671f\u7684\u672a\u53d7\u7406\u8d37\u6b3e\u5355\u636e%1$s\u6761\u3010%2$s\u3011\uff1b", (String)"DailySettleEdit_5", (String)"tmc-ifm-formplugin", (Object[])new Object[0]), loanbills.length, loanInfoList);
        }
        return String.format(ResManager.loadKDString((String)"%1$s%2$s%3$s\u8bf7\u95ee\u662f\u5426\u7ee7\u7eed\uff1f", (String)"DailySettleEdit_6", (String)"tmc-ifm-formplugin", (Object[])new Object[0]), accTip, payTip, loanTip);
    }

    public String checkForUnDailySettle(Long scId, Date bizdate, Date acceptdate) {
        QFilter[] qFilters = new QFilter[]{new QFilter("settlecenter.id", "=", (Object)scId), new QFilter("begindate", ">=", (Object)acceptdate), new QFilter("interestday", "<", (Object)bizdate)};
        boolean exists = TmcDataServiceHelper.exists((String)"ifm_currentintbill", (QFilter[])qFilters);
        String str = null;
        if (exists) {
            str = String.format(ResManager.loadKDString((String)"\u3010%1$s~%2$s\u3011\u65f6\u95f4\u8303\u56f4\u5185\u5b58\u5728\u5b58\u6b3e\u7ed3\u606f\u7684\u4e1a\u52a1\uff0c\u8bf7\u95ee\u662f\u5426\u7ee7\u7eed\uff1f\u6ce8\uff1a\u5982\u82e5\u53d1\u751f\u5386\u53f2\u4e1a\u52a1\u8865\u5f55\uff0c\u8bf7\u68c0\u67e5\u5b58\u6b3e\u7ed3\u606f\u662f\u5426\u9700\u8981\u91cd\u65b0\u8ba1\u7b97\u3002", (String)"DailySettleEdit_1", (String)"tmc-ifm-formplugin", (Object[])new Object[0]), DateUtils.formatString((Date)acceptdate, (String)"yyyy-MM-dd"), DateUtils.formatString((Date)bizdate, (String)"yyyy-MM-dd"));
        }
        return str;
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if (StringUtils.equals((CharSequence)callBackId, (CharSequence)"DAILY_SETTLE_CALLBACK") && MessageBoxResult.Yes == messageBoxClosedEvent.getResult()) {
            this.execDailySettle();
        }
    }

    private void execDailySettle() {
        DynamicObject settlecenter = (DynamicObject)this.getModel().getValue("settlecenter");
        String operateType = (String)this.getModel().getValue("operatetype");
        Date acceptdate = (Date)this.getModel().getValue("acceptdate");
        DynamicObject[] settings = TmcDataServiceHelper.load((String)"ifm_settcentersetting", (String)"id,settlecenter,acceptdate,usestatus", (QFilter[])new QFilter[]{new QFilter("settlecenter", "=", (Object)settlecenter.getLong("id"))});
        OperateOption operateOption = OperateOption.create();
        operateOption.setVariableValue("acceptdate", DateUtils.formatString((Date)acceptdate, (String)"yyyy-MM-dd"));
        OperationResult operationResult = TmcOperateServiceHelper.execOperate((String)"dailysettle", (String)"ifm_settcentersetting", (DynamicObject[])settings, (OperateOption)operateOption);
        if (operationResult.isSuccess()) {
            if (StringUtils.equals((CharSequence)"A", (CharSequence)operateType)) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u65e5\u7ed3\u64cd\u4f5c\u6210\u529f\u3002", (String)"DailySettleEdit_2", (String)"tmc-ifm-formplugin", (Object[])new Object[0]));
            } else {
                this.getView().showMessage(ResManager.loadKDString((String)"\u53cd\u65e5\u7ed3\u64cd\u4f5c\u6210\u529f\u3002", (String)"DailySettleEdit_3", (String)"tmc-ifm-formplugin", (Object[])new Object[0]));
            }
            this.getView().close();
        }
    }
}

