/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.formplugin.deduction;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleDynamicObjectCollection;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.IFormView;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.tmc.fbp.common.bean.BizBalanceModelBean;
import kd.tmc.fbp.common.enums.AcctClassifyEnum;
import kd.tmc.fbp.common.enums.AcctTypeEnum;
import kd.tmc.fbp.common.enums.BalanceTypeEnum;
import kd.tmc.fbp.common.enums.BankAcctStatusEnum;
import kd.tmc.fbp.common.enums.FinOrgTypeEnum;
import kd.tmc.fbp.common.helper.BizBalanceModelHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.ifm.enums.DeductionTypeEnum;
import kd.tmc.ifm.helper.IfmSettleCenterHelper;
import kd.tmc.ifm.helper.TransBillHelper;
import kd.tmc.ifm.helper.TransDetailHelper;

public class DeductionEdit
extends AbstractFormPlugin {
    private static final String FBASEDATAID = "fbasedataid";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.setCenter();
        this.setReceiveAccount();
        this.receiveCurrencyF7();
        this.setPayAccount();
    }

    public void afterCreateNewData(EventObject e) {
        DynamicObject paymentIde;
        String deductionType = (String)this.getModel().getValue("deductiontype");
        if (DeductionTypeEnum.AGENT_DEDUCTION.getValue().equals(deductionType)) {
            FieldEdit receiveCompanyEdit = (FieldEdit)this.getControl("receivecompany");
            receiveCompanyEdit.setMustInput(true);
            FieldEdit receiveAccountEdit = (FieldEdit)this.getControl("receiveaccount");
            receiveAccountEdit.setMustInput(true);
        }
        if ((paymentIde = (DynamicObject)this.getModel().getValue("paymentidentify")) != null && TransBillHelper.isPassivePay((DynamicObject)paymentIde, (String)deductionType)) {
            FieldEdit payeeType = (FieldEdit)this.getControl("payeetype");
            payeeType.setMustInput(true);
        }
        long orgId = RequestContext.get().getOrgId();
        DynamicObject curUseSettleCenter = IfmSettleCenterHelper.getCurUseSettleCenter((String)this.getView().getFormShowParameter().getAppId(), (String)"ifm_deduction", (Long)orgId, (String)"47156aff000000ac");
        if (EmptyUtil.isNoEmpty((DynamicObject)curUseSettleCenter)) {
            this.getModel().setValue("center", (Object)curUseSettleCenter);
            this.getModel().setValue("scorg", (Object)orgId);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        OperationResult operationResult = args.getOperationResult();
        if (operationResult == null || !operationResult.isSuccess()) {
            return;
        }
        List<Long> billIds = Collections.singletonList((Long)this.getModel().getDataEntity().getPkValue());
        switch (args.getOperateKey()) {
            case "innerdetail": {
                TransDetailHelper.showInnerDetails((IFormView)this.getView(), (String)this.getModel().getDataEntityType().getName(), billIds);
                break;
            }
            case "audit": {
                this.setInnerAccountBalance();
            }
        }
    }

    private void setPayAccount() {
        BasedataEdit payAccount = (BasedataEdit)this.getControl("payaccount");
        payAccount.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            StringBuilder sb = new StringBuilder();
            IDataModel model = this.getModel();
            if (EmptyUtil.isEmpty((Object)model.getValue("center"))) {
                sb.append(this.getFirstSelectCenterTips());
            }
            String deductionType = (String)this.getModel().getValue("deductiontype");
            if (DeductionTypeEnum.AGENT_DEDUCTION.getValue().equals(deductionType) && EmptyUtil.isEmpty((Object)model.getValue("receiveaccount"))) {
                sb.append(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u6536\u6b3e\u8d26\u53f7\u201c\u3002", (String)"DeductionEdit_1", (String)"tmc-ifm-formplugin", (Object[])new Object[0]));
            }
            if (DeductionTypeEnum.CENTER_AGENT.getValue().equals(model.getValue("deductiontype")) && EmptyUtil.isEmpty((Object)this.getModel().getValue("paybankaccount"))) {
                sb.append(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u4ed8\u6b3e\u8d26\u53f7\u201c\u3002", (String)"DeductionEdit_5", (String)"tmc-ifm-formplugin", (Object[])new Object[0]));
            }
            if (sb.length() > 0) {
                this.getView().showTipNotification(sb.toString());
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            QFilter qFilterChina = this.getFilterChina();
            this.appendCurrencyFilter(qFilterChina);
            QFilter acctTypeFilter = new QFilter("accttype", "!=", (Object)AcctTypeEnum.IN.getValue());
            QFilter bankAccountFilter = new QFilter("id", "not in", this.getAllBankAccountIds());
            showParameter.setCustomParam("isclearcorefilter", (Object)true);
            showParameter.getListFilterParameter().setFilter(qFilterChina.and(acctTypeFilter).and(bankAccountFilter));
        });
    }

    private void appendCurrencyFilter(QFilter qFilterChina) {
        DynamicObject receiveCurrency = (DynamicObject)this.getModel().getValue("receivecurrency");
        if (EmptyUtil.isNoEmpty((DynamicObject)receiveCurrency)) {
            qFilterChina.and(new QFilter("currency.fbasedataid.id", "=", receiveCurrency.getPkValue()));
        }
    }

    private QFilter getFilterChina() {
        QFilter acctStatusFilter = new QFilter("acctstatus", "=", (Object)BankAcctStatusEnum.NORMAL.getValue());
        QFilter acctClassifyFilter = new QFilter("acctclassify", "=", (Object)AcctClassifyEnum.INNER_ACCOUNT.getValue());
        QFilter openBankFilter = new QFilter("bank", "=", ((DynamicObject)this.getModel().getValue("center")).getPkValue());
        return acctStatusFilter.and(acctClassifyFilter).and(openBankFilter);
    }

    private void receiveCurrencyF7() {
        BasedataEdit receiveCurrency = (BasedataEdit)this.getControl("receivecurrency");
        receiveCurrency.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            DynamicObjectCollection currencyColls;
            DynamicObject bankAccount;
            DynamicObject receiveAccount = (DynamicObject)this.getModel().getValue("receiveaccount");
            if (receiveAccount != null && EmptyUtil.isNoEmpty((DynamicObject)(bankAccount = TmcDataServiceHelper.loadSingleFromCache((String)"bd_accountbanks", (String)"currency", (QFilter[])new QFilter[]{new QFilter("id", "=", receiveAccount.getPkValue())}))) && EmptyUtil.isNoEmpty((DynamicObjectCollection)(currencyColls = bankAccount.getDynamicObjectCollection("currency")))) {
                Set currencyIds = currencyColls.stream().map(o -> o.getDynamicObject(FBASEDATAID).getPkValue()).collect(Collectors.toSet());
                ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                showParameter.getListFilterParameter().getQFilters().add(new QFilter("id", "in", currencyIds));
            }
        });
    }

    private void setReceiveAccount() {
        BasedataEdit receiveAccount = (BasedataEdit)this.getControl("receiveaccount");
        receiveAccount.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            StringBuilder sb = new StringBuilder();
            if (Objects.isNull(this.getModel().getValue("center"))) {
                sb.append(this.getFirstSelectCenterTips());
            }
            if (sb.length() > 0) {
                this.getView().showTipNotification(sb.toString());
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            QFilter acctTypeFilter = new QFilter("accttype", "!=", (Object)AcctTypeEnum.OUT.getValue());
            DynamicObject company = (DynamicObject)this.getModel().getValue("receivecompany");
            if (EmptyUtil.isNoEmpty((DynamicObject)company)) {
                acctTypeFilter.and(new QFilter("company", "=", company.getPkValue()));
            }
            QFilter bankAccountFilter = new QFilter("id", "not in", this.getAllBankAccountIds());
            showParameter.getListFilterParameter().setFilter(this.getFilterChina().and(acctTypeFilter).and(bankAccountFilter));
        });
    }

    private String getFirstSelectCenterTips() {
        return ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u7ed3\u7b97\u4e2d\u5fc3\u201c\u3002", (String)"DeductionEdit_0", (String)"tmc-ifm-formplugin", (Object[])new Object[0]);
    }

    private void setCenter() {
        BasedataEdit center = (BasedataEdit)this.getControl("center");
        center.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            QFilter finOrgTypeFilter = new QFilter("finorgtype.type", "=", (Object)FinOrgTypeEnum.CLEARINGHOUSE.getValue());
            List orgIdList = TmcOrgDataHelper.getAuthorizedBankOrgId((Long)RequestContext.get().getCurrUserId(), (String)this.getView().getFormShowParameter().getAppId(), (String)"ifm_deduction", (String)"47150e89000000ac");
            QFilter orgIdFilter = new QFilter("org", "in", (Object)orgIdList);
            showParameter.getListFilterParameter().setFilter(finOrgTypeFilter.and(orgIdFilter));
        });
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name;
        switch (name = e.getProperty().getName()) {
            case "receiveaccount": {
                this.clearFields(e);
                this.setReceiveCurrency(e);
                break;
            }
            case "payaccount": {
                this.setPayCurrency(e);
                this.setAccountBalance(e);
                break;
            }
            case "payamount": {
                this.reCalculation();
                break;
            }
            case "comment": {
                this.fillTransferComment(e);
                break;
            }
            case "isbackfill": {
                DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
                if (CollectionUtils.isEmpty((Collection)entryEntity) || !this.getModel().getDataEntity().getBoolean("isbackfill")) break;
                OrmLocaleValue ormLocaleValue = (OrmLocaleValue)this.getModel().getValue("comment");
                this.fillEntryEntity(ormLocaleValue, entryEntity);
                break;
            }
            case "receivecompany": {
                this.getModel().setValue("receiveaccount", null);
                DynamicObject recCompany = (DynamicObject)this.getModel().getValue("receivecompany");
                this.getModel().setValue("payee", recCompany != null ? recCompany.getPkValue() : Long.valueOf(0L));
                this.getModel().setValue("payeename", (Object)(recCompany != null ? recCompany.getString("name") : ""));
                break;
            }
            case "deductiontype": {
                FieldEdit receiveCompanyEdit = (FieldEdit)this.getControl("receivecompany");
                receiveCompanyEdit.setMustInput(Objects.equals(e.getChangeSet()[0].getNewValue(), DeductionTypeEnum.AGENT_DEDUCTION.getValue()));
                FieldEdit receiveAccountEdit = (FieldEdit)this.getControl("receiveaccount");
                receiveAccountEdit.setMustInput(Objects.equals(e.getChangeSet()[0].getNewValue(), DeductionTypeEnum.AGENT_DEDUCTION.getValue()));
                this.fillReceiveCurrency(e);
                break;
            }
            case "center": {
                this.fillAndClear(e);
                break;
            }
            case "receivecurrency": {
                DynamicObject currency = (DynamicObject)e.getChangeSet()[0].getNewValue();
                this.clearAccountByCurrency(currency);
            }
        }
    }

    private void fillAndClear(PropertyChangedArgs e) {
        DynamicObject center = (DynamicObject)e.getChangeSet()[0].getNewValue();
        if (center != null) {
            DynamicObject bank;
            DynamicObject receiveAccount;
            DynamicObject org = center.getDynamicObject("org");
            this.getModel().setValue("scorg", org.getPkValue());
            Map companyByOrg = OrgUnitServiceHelper.getCompanyByOrg((Long)((Long)org.getPkValue()));
            if (null != companyByOrg && companyByOrg.size() > 0) {
                this.getModel().setValue("openorg", companyByOrg.get("id"));
            }
            if ((receiveAccount = (DynamicObject)this.getModel().getValue("receiveaccount")) != null && (bank = receiveAccount.getDynamicObject("bank")) != null && !Objects.equals(bank.getPkValue(), center.getPkValue())) {
                this.getModel().setValue("receiveaccount", null);
            }
        } else {
            this.getModel().setValue("scorg", null);
            this.getModel().setValue("openorg", null);
        }
    }

    private Set<Object> getAllBankAccountIds() {
        HashSet<Object> bankAccountIds = new HashSet<Object>();
        DynamicObject receiveAccount = (DynamicObject)this.getModel().getValue("receiveaccount");
        if (Objects.nonNull(receiveAccount)) {
            bankAccountIds.add(receiveAccount.getPkValue());
        }
        int entryRowCount = this.getModel().getEntryRowCount("entryentity");
        int rowIdx = this.getModel().getEntryCurrentRowIndex("entryentity");
        for (int i = 0; i < entryRowCount; ++i) {
            DynamicObject payAccount;
            if (i == rowIdx || !EmptyUtil.isNoEmpty((DynamicObject)(payAccount = (DynamicObject)this.getModel().getValue("payaccount", i)))) continue;
            bankAccountIds.add(payAccount.getPkValue());
        }
        return bankAccountIds;
    }

    private void fillReceiveCurrency(PropertyChangedArgs e) {
        this.getView().setEnable(Boolean.valueOf(true), new String[]{"receivecurrency"});
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        if (Objects.equals(e.getChangeSet()[0].getNewValue(), DeductionTypeEnum.DEDUCTION.getValue()) && !CollectionUtils.isEmpty((Collection)entryEntity)) {
            for (DynamicObject row : entryEntity) {
                DynamicObject payCurrency = row.getDynamicObject("paycurrency");
                if (!Objects.nonNull(payCurrency)) continue;
                this.getModel().setValue("receivecurrency", (Object)payCurrency);
                break;
            }
        }
    }

    private void clearFields(PropertyChangedArgs e) {
        DynamicObject receiveAccount = (DynamicObject)e.getChangeSet()[0].getNewValue();
        if (receiveAccount == null) {
            this.getModel().setValue("receivecurrency", null);
        } else {
            DynamicObjectCollection currencyCollection = receiveAccount.getDynamicObjectCollection("currency");
            DynamicObject currency = CollectionUtils.isEmpty((Collection)currencyCollection) ? null : (DynamicObject)((DynamicObject)currencyCollection.get(0)).get(FBASEDATAID);
            this.getModel().setValue("receivecurrency", (Object)currency);
            this.clearAccountByCurrency(currency);
            this.clearAccountByBank(e);
        }
    }

    private void clearAccountByBank(PropertyChangedArgs e) {
        DynamicObject oldReceiveAccount = (DynamicObject)e.getChangeSet()[0].getOldValue();
        DynamicObject newReceiveAccount = (DynamicObject)e.getChangeSet()[0].getNewValue();
        if (oldReceiveAccount != null && newReceiveAccount != null) {
            DynamicObject oldBank = oldReceiveAccount.getDynamicObject("bank");
            DynamicObject newBank = newReceiveAccount.getDynamicObject("bank");
            if (oldBank == null && newBank != null || oldBank != null && newBank == null || oldBank != null && !Objects.equals(oldBank.getPkValue(), newBank.getPkValue())) {
                this.clearPayAccount();
            }
        }
    }

    private void clearPayAccount() {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        for (int i = 0; i < entryEntity.size(); ++i) {
            this.getModel().setValue("payaccount", null, i);
        }
    }

    private void clearAccountByCurrency(DynamicObject currency) {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        if (!CollectionUtils.isEmpty((Collection)entryEntity) && currency != null) {
            for (int i = 0; i < entryEntity.size(); ++i) {
                DynamicObject row = (DynamicObject)entryEntity.get(i);
                DynamicObject payCurrency = row.getDynamicObject("paycurrency");
                if (payCurrency == null || Objects.equals(payCurrency.getPkValue(), currency.getPkValue())) continue;
                this.getModel().setValue("payaccount", null, i);
            }
        }
    }

    private void fillTransferComment(PropertyChangedArgs e) {
        DynamicObjectCollection entryEntity;
        if (this.getModel().getDataEntity().getBoolean("isbackfill") && !CollectionUtils.isEmpty((Collection)(entryEntity = this.getModel().getEntryEntity("entryentity")))) {
            LocaleDynamicObjectCollection newValues = (LocaleDynamicObjectCollection)e.getChangeSet()[0].getNewValue();
            OrmLocaleValue ormLocaleValue = null;
            for (DynamicObject newValue : newValues) {
                String localeString = (String)newValue.get("comment");
                DynamicObject orCreateItemByLocaleId = newValues.getOrCreateItemByLocaleId((String)newValue.get(newValues.getLocaleIdProperty()));
                String localId = (String)orCreateItemByLocaleId.getDataStorage().getLocalValue(newValues.getLocaleIdProperty());
                ormLocaleValue = (OrmLocaleValue)((DynamicObject)entryEntity.get(0)).get("transfercomment");
                ormLocaleValue.put(localId, localeString);
            }
            this.fillEntryEntity(ormLocaleValue, entryEntity);
        }
    }

    private void fillEntryEntity(OrmLocaleValue ormLocaleValue, DynamicObjectCollection entryEntity) {
        for (int i = 0; i < entryEntity.size(); ++i) {
            this.getModel().setValue("transfercomment", (Object)ormLocaleValue, i);
        }
    }

    private void reCalculation() {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        BigDecimal totalPayAmount = entryEntity.stream().map(d -> d.getBigDecimal("payamount")).reduce(BigDecimal.ZERO, BigDecimal::add);
        this.getModel().setValue("receiveamount", (Object)totalPayAmount);
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        if (this.getModel().getDataEntity().getBoolean("isbackfill")) {
            int rowIndex = this.getModel().getEntryRowCount("entryentity") - 1;
            this.getModel().setValue("transfercomment", this.getModel().getValue("comment"), rowIndex);
        }
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        this.reCalculation();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setInnerAccountBalance();
    }

    private void setPayCurrency(PropertyChangedArgs e) {
        DynamicObject payAccount = (DynamicObject)e.getChangeSet()[0].getNewValue();
        int rowIndex = e.getChangeSet()[0].getRowIndex();
        if (payAccount != null) {
            DynamicObject recCurrency = (DynamicObject)this.getModel().getValue("receivecurrency");
            DynamicObject bankAccount = BusinessDataServiceHelper.loadSingleFromCache((Object)payAccount.getPkValue(), (String)"bd_accountbanks", (String)"currency, bank,company");
            if (EmptyUtil.isNoEmpty((DynamicObject)bankAccount)) {
                if (EmptyUtil.isEmpty((DynamicObject)recCurrency)) {
                    DynamicObjectCollection currencyCollection = bankAccount.getDynamicObjectCollection("currency");
                    if (!EmptyUtil.isEmpty((DynamicObjectCollection)currencyCollection)) {
                        this.getModel().setValue("paycurrency", ((DynamicObject)currencyCollection.get(0)).get(FBASEDATAID), rowIndex);
                        this.getModel().setValue("receivecurrency", ((DynamicObject)currencyCollection.get(0)).get(FBASEDATAID));
                    }
                } else {
                    this.getModel().setValue("paycurrency", recCurrency.getPkValue(), rowIndex);
                }
                this.getModel().setValue("paycompany", bankAccount.getDynamicObject("company").getPkValue(), rowIndex);
            }
        } else {
            this.getModel().setValue("paycurrency", null, rowIndex);
            this.getModel().setValue("paycompany", null, rowIndex);
        }
    }

    private void setReceiveCurrency(PropertyChangedArgs e) {
        DynamicObject bankAccount;
        DynamicObject receiveAccount = (DynamicObject)e.getChangeSet()[0].getNewValue();
        this.getModel().setValue("payeeaccountbank", receiveAccount != null ? receiveAccount.getPkValue() : Long.valueOf(0L));
        this.getModel().setValue("payeebanknum", (Object)(receiveAccount != null ? receiveAccount.getString("bankaccountnumber") : ""));
        if (receiveAccount != null && EmptyUtil.isNoEmpty((DynamicObject)(bankAccount = BusinessDataServiceHelper.loadSingle((Object)receiveAccount.getPkValue(), (String)"bd_accountbanks", (String)"currency,company,bank")))) {
            DynamicObjectCollection currencyCollection;
            if (EmptyUtil.isEmpty((Object)this.getModel().getValue("receivecompany"))) {
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"receivecompany", (Object)bankAccount.getDynamicObject("company").getPkValue());
            }
            if (!CollectionUtils.isEmpty((Collection)(currencyCollection = bankAccount.getDynamicObjectCollection("currency")))) {
                this.getModel().setValue("receivecurrency", ((DynamicObject)currencyCollection.get(0)).get(FBASEDATAID));
                this.getView().setEnable(Boolean.valueOf(false), new String[]{"receivecurrency"});
            }
        }
    }

    private void setAccountBalance(PropertyChangedArgs e) {
        DynamicObject payAccount = (DynamicObject)e.getChangeSet()[0].getNewValue();
        if (EmptyUtil.isNoEmpty((DynamicObject)payAccount)) {
            int rowIndex = e.getChangeSet()[0].getRowIndex();
            DynamicObject payCurrency = (DynamicObject)this.getModel().getValue("paycurrency", rowIndex);
            BizBalanceModelBean balance = BizBalanceModelHelper.getRunningBalance((String)BalanceTypeEnum.BALANCE.getValue(), (long)payAccount.getLong("id"), (long)payCurrency.getLong("id"));
            if (balance != null && balance.getAmount() != null) {
                TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"curbalance", (Object)balance.getAmount(), (int)rowIndex);
            } else {
                TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"curbalance", null, (int)rowIndex);
            }
        }
    }

    private void setInnerAccountBalance() {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        if (!CollectionUtils.isEmpty((Collection)entryEntity)) {
            for (int i = 0; i < entryEntity.size(); ++i) {
                DynamicObject row = (DynamicObject)entryEntity.get(i);
                DynamicObject payAccount = row.getDynamicObject("payaccount");
                DynamicObject payCurrency = row.getDynamicObject("paycurrency");
                if (EmptyUtil.isNoEmpty((DynamicObject)payCurrency) && EmptyUtil.isNoEmpty((DynamicObject)payAccount)) {
                    BizBalanceModelBean balance = BizBalanceModelHelper.getRunningBalance((String)BalanceTypeEnum.BALANCE.getValue(), (long)payAccount.getLong("id"), (long)payCurrency.getLong("id"));
                    if (balance == null || balance.getAmount() == null) continue;
                    TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"curbalance", (Object)balance.getAmount(), (int)i);
                    continue;
                }
                TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"curbalance", null, (int)i);
            }
        }
    }
}

