/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.formplugin.deduction;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.ifm.enums.DeductionTypeEnum;
import kd.tmc.ifm.helper.TransDetailHelper;

public class DeductionList
extends AbstractListPlugin {
    public void filterColumnSetFilter(SetFilterEvent args) {
        super.filterColumnSetFilter(args);
        CommonFilterColumn filterCol = (CommonFilterColumn)args.getSource();
        if (StringUtils.startsWith((CharSequence)filterCol.getFieldName(), (CharSequence)"center.")) {
            args.getQFilters().addAll(this.getFilter("center", "center.id"));
            List orgIdList = TmcOrgDataHelper.getAuthorizedBankOrgId((Long)Long.valueOf(RequestContext.get().getUserId()), (String)"ifm", (String)"ifm_deduction", (String)"47150e89000000ac");
            args.getQFilters().add(new QFilter("org", "in", (Object)orgIdList));
        }
        if (StringUtils.startsWith((CharSequence)filterCol.getFieldName(), (CharSequence)"receivecompany.")) {
            args.getQFilters().addAll(this.getFilter("receivecompany", "receivecompany.id"));
        }
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        super.beforeCreateListDataProvider(args);
        args.setListDataProvider((IListDataProvider)new ListDataProvider(){

            public DynamicObjectCollection getData(int arg0, int arg1) {
                boolean isScorg;
                DynamicObjectCollection dataList = super.getData(arg0, arg1);
                if (dataList.isEmpty()) {
                    return dataList;
                }
                DataEntityPropertyCollection properties = ((DynamicObject)dataList.get(0)).getDataEntityType().getProperties();
                boolean bl = isScorg = properties.containsKey((Object)"deductiontype") && properties.containsKey((Object)"scorg");
                if (isScorg) {
                    dataList.forEach(d -> {
                        String deductionType = d.getString("deductiontype");
                        if (DeductionTypeEnum.AGENT_DEDUCTION.getValue().equals(deductionType) || DeductionTypeEnum.DEDUCTION.getValue().equals(deductionType)) {
                            d.set("scorg", null);
                        }
                    });
                }
                return dataList;
            }
        });
    }

    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        super.afterDoOperation(evt);
        if (evt.getOperationResult() != null && evt.getOperationResult().isSuccess()) {
            switch (evt.getOperateKey()) {
                case "preback": {
                    this.showBackReason("ifm_payacceptance_back");
                    break;
                }
                case "recevicebei": {
                    this.showBackReason("ifm_deduction_down");
                    break;
                }
                case "innerdetail": {
                    BillList billList = (BillList)this.getControl("billlistap");
                    ListSelectedRowCollection selectedRows = billList.getSelectedRows();
                    TransDetailHelper.showInnerDetails((IFormView)this.getView(), (String)"ifm_deduction", selectedRows.stream().map(o -> (Long)o.getPrimaryKeyValue()).collect(Collectors.toList()));
                }
            }
        }
    }

    private List<QFilter> getFilter(String selectProperty, String filterProperty) {
        DynamicObjectCollection load = QueryServiceHelper.query((String)"ifm_deduction", (String)selectProperty, (QFilter[])new QFilter(filterProperty, "!=", (Object)0).toArray());
        Set baseDataIds = load.stream().map(d -> d.getLong(selectProperty)).collect(Collectors.toSet());
        return Collections.singletonList(new QFilter("id", "in", baseDataIds));
    }

    private void showBackReason(String formId) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setAppId("ifm");
        parameter.setFormId(formId);
        parameter.setStatus(OperationStatus.ADDNEW);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, formId));
        if ("ifm_deduction_down".equals(formId)) {
            parameter.setCaption(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7b5b\u9009\u6761\u4ef6", (String)"DeductionList_1", (String)"tmc-ifm-formplugin", (Object[])new Object[0]));
        }
        this.getView().showForm(parameter);
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        String actionId;
        super.closedCallBack(evt);
        switch (actionId = evt.getActionId()) {
            case "ifm_payacceptance_back": {
                HashMap returnData = (HashMap)evt.getReturnData();
                if (returnData == null) {
                    return;
                }
                BillList billList = (BillList)this.getControl("billlistap");
                ListSelectedRowCollection selectedRows = billList.getSelectedRows();
                DynamicObject[] dynamicObjects = new DynamicObject[selectedRows.size()];
                for (int i = 0; i < selectedRows.size(); ++i) {
                    Long primaryKeyValue = (Long)selectedRows.get(i).getPrimaryKeyValue();
                    DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)primaryKeyValue, (String)"ifm_deduction");
                    dynamicObject.set("reason", returnData.get("reason"));
                    dynamicObjects[i] = dynamicObject;
                }
                OperationResult result = TmcOperateServiceHelper.execOperate((String)"back", (String)"ifm_deduction", (DynamicObject[])dynamicObjects, (OperateOption)OperateOption.create());
                if (!result.isSuccess()) break;
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u9000\u5355\u6210\u529f\u3002", (String)"DeductionList_0", (String)"tmc-ifm-formplugin", (Object[])new Object[0]));
                break;
            }
            case "ifm_deduction_down": {
                Object downSize = evt.getReturnData();
                if (!EmptyUtil.isNoEmpty((Object)downSize)) break;
                this.getView().invokeOperation("refresh");
                this.getView().showSuccessNotification(String.format(ResManager.loadKDString((String)"\u6210\u529f\u63a5\u6536\u4ea4\u6613\u660e\u7ec6%s\u6761", (String)"DeductionAcceptBeiEdit_0", (String)"tmc-ifm-formplugin", (Object[])new Object[0]), downSize), Integer.valueOf(3000));
            }
        }
    }
}

