/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.formplugin.deduction;

import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class DeductionPayerEdit
extends AbstractFormPlugin {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnok"});
        this.payerAcctBankF7();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        this.getModel().setValue("payerorg", customParams.get("scorg"));
        this.getModel().setValue("openorg", customParams.get("openorg"));
        this.getModel().setValue("payerbankaccount", customParams.get("paybankaccount"));
        if (EmptyUtil.isEmpty(customParams.get("openorg"))) {
            this.setOpenOrg((DynamicObject)this.getModel().getValue("payerorg"), (DynamicObject)this.getModel().getValue("payerbankaccount"));
        }
        this.getModel().setValue("paybank", customParams.get("paybank"));
        this.getView().updateView("contentpanel");
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control con = (Control)evt.getSource();
        String key = con.getKey();
        if ("btnok".equals(key)) {
            HashMap<String, Object> payMap = new HashMap<String, Object>(4);
            payMap.put("openorg", this.getObjId("openorg"));
            payMap.put("paybankaccount", this.getObjId("payerbankaccount"));
            payMap.put("paybank", this.getObjId("paybank"));
            this.getView().returnDataToParent(payMap);
            this.getView().close();
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        ChangeData[] changeData = e.getChangeSet();
        Object newValue = changeData[0].getNewValue();
        switch (key) {
            case "payerbankaccount": {
                this.payerBankAccountChange((DynamicObject)newValue);
            }
        }
    }

    private void payerAcctBankF7() {
        BasedataEdit payerAcctBankF7 = (BasedataEdit)this.getControl("payerbankaccount");
        payerAcctBankF7.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            DynamicObject payerOrg = (DynamicObject)this.getModel().getValue("payerorg");
            if (EmptyUtil.isEmpty((DynamicObject)payerOrg)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4ed8\u6b3e\u4eba\u3002", (String)"DeductionPayerEdit_0", (String)"tmc-ifm-formplugin", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            QFilter filter = BaseDataServiceHelper.getBaseDataFilter((String)"bd_accountbanks", (Long)payerOrg.getLong("id")).and(new QFilter("acctstatus", "=", (Object)"normal"));
            showParameter.getListFilterParameter().getQFilters().add(filter);
        });
    }

    private void payerBankAccountChange(DynamicObject bankAccount) {
        if (EmptyUtil.isNoEmpty((DynamicObject)bankAccount)) {
            DynamicObject bank = bankAccount.getDynamicObject("bank");
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"paybank", (Object)(bank != null ? bank.getPkValue() : null));
        } else {
            this.getModel().setValue("paybank", null);
        }
        DynamicObject payerOrg = (DynamicObject)this.getModel().getValue("payerorg");
        this.setOpenOrg(payerOrg, bankAccount);
    }

    private void setOpenOrg(DynamicObject org, DynamicObject bankAccount) {
        DynamicObject openOrg;
        Map companyByOrg;
        if (EmptyUtil.isNoEmpty((DynamicObject)org) && null != (companyByOrg = OrgUnitServiceHelper.getCompanyByOrg((Long)((Long)org.getPkValue()))) && companyByOrg.size() > 0) {
            this.getModel().setValue("openorg", companyByOrg.get("id"));
            return;
        }
        DynamicObject dynamicObject = openOrg = bankAccount != null ? bankAccount.getDynamicObject("openorg") : null;
        if (openOrg != null && OrgUnitServiceHelper.checkOrgFunction((Long)openOrg.getLong("id"), (String)"10")) {
            this.getModel().setValue("openorg", openOrg.get("id"));
            return;
        }
        this.getModel().setValue("openorg", null);
    }

    private Object getObjId(String prop) {
        DynamicObject val = (DynamicObject)this.getModel().getValue(prop);
        return EmptyUtil.isNoEmpty((DynamicObject)val) ? val.getPkValue() : null;
    }
}

