/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.formplugin.elecreceipt;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.IFormView;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.list.BillList;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.enums.AcctClassifyEnum;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.formplugin.list.AbstractTmcBillBaseList;
import kd.tmc.ifm.helper.ElecReceiptViewHelper;

public class ElecReceiptList
extends AbstractTmcBillBaseList {
    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        String key = op.getOperateKey();
        BillList billList = (BillList)this.getControl("billlistap");
        switch (key) {
            case "receiptinner": {
                ListSelectedRow currRow = billList.getCurrentSelectedRowInfo();
                List<String> receiptNos = this.getReceiptNos(Collections.singletonList(currRow.getPrimaryKeyValue()));
                ElecReceiptViewHelper.openElecView(receiptNos, (IFormView)this.getView());
                break;
            }
            case "elecprintpreview": {
                ListSelectedRowCollection selectedRows = billList.getSelectedRows();
                List<String> receiptNos = this.getReceiptNos(selectedRows.stream().map(o -> o.getPrimaryKeyValue()).collect(Collectors.toList()));
                ElecReceiptViewHelper.openElecView(receiptNos, (IFormView)this.getView());
            }
        }
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        super.filterContainerBeforeF7Select(args);
        String fieldName = args.getFieldName();
        if (fieldName.startsWith("accountbank")) {
            args.getQfilters().add(this.getAccountBankFilter());
        }
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        DynamicObjectCollection accountBanks = QueryServiceHelper.query((String)"bd_accountbanks", (String)"id,bankaccountnumber", (QFilter[])new QFilter[]{this.getAccountBankFilter()});
        ArrayList<ComboItem> acctItems = new ArrayList<ComboItem>(accountBanks.size());
        for (DynamicObject accountBank : accountBanks) {
            ComboItem item = new ComboItem();
            item.setCaption(new LocaleString(accountBank.getString("bankaccountnumber")));
            item.setValue(accountBank.getString("id"));
            acctItems.add(item);
        }
        for (FilterColumn filterColumn : args.getFilterContainerInitEvent().getCommonFilterColumns()) {
            CommonFilterColumn commonFilterColumn = (CommonFilterColumn)filterColumn;
            String fieldName = commonFilterColumn.getFieldName();
            if (!fieldName.startsWith("accountbank.bankaccountnumber")) continue;
            List listcomitem = commonFilterColumn.getComboItems();
            listcomitem.clear();
            commonFilterColumn.setComboItems(acctItems);
        }
    }

    private QFilter getAccountBankFilter() {
        String appId = this.getView().getFormShowParameter().getAppId();
        List orgIds = TmcOrgDataHelper.getAuthorizedBankOrgId((Long)RequestContext.get().getCurrUserId(), (String)appId, (String)this.getDataEntityName(), (String)"47150e89000000ac");
        if (EmptyUtil.isEmpty((Collection)orgIds)) {
            return QFilter.of((String)"1!=1", (Object[])new Object[0]);
        }
        return new QFilter("acctclassify", "=", (Object)AcctClassifyEnum.INNER_ACCOUNT.getValue()).and(new QFilter("company", "in", (Object)orgIds));
    }

    private List<String> getReceiptNos(List<Object> ids) {
        DynamicObjectCollection receipts = QueryServiceHelper.query((String)"ifm_elecreceipt", (String)"receiptno", (QFilter[])new QFilter[]{new QFilter("id", "in", ids)});
        return receipts.parallelStream().map(o -> o.getString("receiptno")).collect(Collectors.toList());
    }
}

