/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.formplugin.home;

import java.util.Date;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.form.control.Control;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.ifm.enums.AcctClassifyEnum;
import kd.tmc.ifm.helper.IfmSettleCenterHelper;
import kd.tmc.ifm.model.LargeFundMonitorProp;

public class LargeFundMonitorPlugin
extends AbstractFormPlugin {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btn_refresh"});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.refreshData();
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        if ("btn_refresh".equals(key)) {
            this.refreshData();
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5237\u65b0\u6210\u529f", (String)"LargeFundMonitorPlugin_0", (String)"tmc-ifm-formplugin", (Object[])new Object[0]));
        }
    }

    private void refreshData() {
        String appId = this.getView().getFormShowParameter().getAppId();
        List ids = IfmSettleCenterHelper.getAuthorizedRegisteredSettleCenterIds((Long)RequestContext.get().getCurrUserId(), (String)appId, (String)"ifm_transdetail", (String)"47150e89000000ac");
        Date lastMonth = DateUtils.getDataFormat((Date)DateUtils.getLastMonth((Date)DateUtils.getCurrentDate(), (int)1), (boolean)true);
        Date currentDate = DateUtils.getDataFormat((Date)DateUtils.getCurrentDate(), (boolean)false);
        QFilter qFilter = new QFilter("accountbank.acctclassify", "=", (Object)AcctClassifyEnum.INNER_ACCOUNT.getValue()).and("bank.id", "in", (Object)ids).and("bizdate", ">=", (Object)lastMonth).and("bizdate", "<=", (Object)currentDate).and("debitamount", ">", (Object)LargeFundMonitorProp.MILLION).and("sourcebilltype", "=", (Object)"ifm_transhandlebill");
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)"largfundmonitor", (String)"ifm_transdetail", (String)"bizdate,currency,debitamount,oppunit,oppbank,description", (QFilter[])qFilter.toArray(), (String)"bizdate desc");
        this.getModel().deleteEntryData("entryentity");
        TableValueSetter vs = new TableValueSetter(new String[0]);
        vs.addField("bizdate", new Object[0]);
        vs.addField("currency", new Object[0]);
        vs.addField("debitamount", new Object[0]);
        vs.addField("oppunit", new Object[0]);
        vs.addField("oppbank", new Object[0]);
        vs.addField("description", new Object[0]);
        Iterator iterator = dataSet.iterator();
        int rowCount = 0;
        while (iterator.hasNext()) {
            Row row = (Row)iterator.next();
            vs.addRow(new Object[]{row.getDate("bizdate"), row.get("currency"), row.getBigDecimal("debitamount"), row.getString("oppunit"), row.getString("oppbank"), row.get("description")});
            ++rowCount;
        }
        if (rowCount > 0) {
            AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
            model.beginInit();
            model.batchCreateNewEntryRow("entryentity", vs);
            model.endInit();
            this.getView().updateView("entryentity");
        }
    }
}

