/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.formplugin.inneracct;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.tmc.fbp.common.enums.BankAcctStatusEnum;
import kd.tmc.fbp.common.enums.FinOrgTypeEnum;
import kd.tmc.fbp.common.util.EmptyUtil;

public class FilterBankAccountsUtil {
    private FilterBankAccountsUtil() {
    }

    public static QFilter getBankAccountsFilter(DynamicObject innerAccount, List<Long> currRelBankAccounts) {
        QFilter matherAccFilter = new QFilter("company", "=", innerAccount.getDynamicObject("org").getPkValue());
        DynamicObject[] matherBill = BusinessDataServiceHelper.load((String)"fca_acctgroup", (String)"id, entrys.bankacct", (QFilter[])matherAccFilter.toArray());
        List<Long> accountIds = FilterBankAccountsUtil.filterAccountIds(innerAccount, matherBill);
        if (!accountIds.isEmpty()) {
            FilterBankAccountsUtil.filterAccounts(accountIds, currRelBankAccounts, innerAccount);
        }
        return new QFilter("id", "in", accountIds);
    }

    private static void filterAccounts(List<Long> accountIds, List<Long> relationBankAccounts, DynamicObject innerAccount) {
        QFilter orgFilter = new QFilter("org", "=", ((DynamicObject)innerAccount.get("org")).getPkValue());
        DynamicObject[] innerAccountsByOrg = BusinessDataServiceHelper.load((String)"ifm_inneracct", (String)"id, relationacc", (QFilter[])orgFilter.toArray());
        Set relationAccountIds = Arrays.stream(innerAccountsByOrg).map(a -> a.getDynamicObjectCollection("relationacc")).flatMap(Collection::stream).map(d -> d.getDynamicObject("fbasedataid")).map(am -> (Long)am.getPkValue()).filter(fam -> !relationBankAccounts.contains(fam)).collect(Collectors.toSet());
        accountIds.removeIf(relationAccountIds::contains);
    }

    private static List<Long> filterAccountIds(DynamicObject innerAccount, DynamicObject[] matherBill) {
        ArrayList<Long> accountIds = new ArrayList<Long>();
        for (DynamicObject bill : matherBill) {
            DynamicObjectCollection dynamicObjectCollection = bill.getDynamicObjectCollection("entrys");
            for (DynamicObject account : dynamicObjectCollection) {
                DynamicObject bankAcct = account.getDynamicObject("bankacct");
                if (null == bankAcct || !Objects.equals(bankAcct.getDynamicObject("company").getPkValue(), innerAccount.getDynamicObject("company") == null ? "" : innerAccount.getDynamicObject("company").getPkValue()) || Objects.equals(bankAcct.getString("finorgtype"), FinOrgTypeEnum.CLEARINGHOUSE.getValue()) || !FilterBankAccountsUtil.containsCurrency(bankAcct, innerAccount.getDynamicObject("currency_dflt")) || Objects.equals(bankAcct.getString("acctstatus"), BankAcctStatusEnum.CLOSED.getValue())) continue;
                accountIds.add((Long)bankAcct.getPkValue());
            }
        }
        return accountIds;
    }

    private static boolean containsCurrency(DynamicObject bankacct, DynamicObject currency) {
        if (currency == null || EmptyUtil.isEmpty((DynamicObjectCollection)bankacct.getDynamicObjectCollection("currency"))) {
            return false;
        }
        List collect = bankacct.getDynamicObjectCollection("currency").stream().filter(o -> EmptyUtil.isNoEmpty((DynamicObject)o.getDynamicObject("fbasedataid"))).map(c -> c.getDynamicObject("fbasedataid").getPkValue()).collect(Collectors.toList());
        return collect.contains(currency.getPkValue());
    }
}

