/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.formplugin.interest;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbp.common.helper.TermHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.model.interest.IntBillDetailInfo;
import kd.tmc.fbp.common.model.interest.IntBillInfo;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.ifm.enums.IntObjectTypeEnum;
import kd.tmc.ifm.enums.IntSourceEnum;
import kd.tmc.ifm.enums.SettleTypeEnum;
import kd.tmc.ifm.formplugin.interest.AbstractIntBillBatchEdit;
import kd.tmc.ifm.helper.BatchIntHelper;

public class CurrentIntBillBatchEdit
extends AbstractIntBillBatchEdit
implements RowClickEventListener {
    private static final String CLOSE_BAKE_KEY_FILTER = "CLOSE_BAKE_KEY_FILTER";

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid entryGrid = (EntryGrid)this.getControl("entry");
        entryGrid.addRowClickListener((RowClickEventListener)this);
    }

    public void entryRowClick(RowClickEvent evt) {
        super.entryRowClick(evt);
        EntryGrid entryGrid = (EntryGrid)evt.getSource();
        if (StringUtils.equals((CharSequence)"entry", (CharSequence)entryGrid.getKey())) {
            int index = evt.getRow();
            if (index < 0) {
                return;
            }
            this.loanIntEntry(index);
        }
    }

    private void loanIntEntry(int index) {
        DynamicObject entry = this.getModel().getEntryRowEntity("entry", index);
        this.getModel().setValue("intnum", (Object)entry.getString("intdetailnum"));
        DynamicObject intObj = entry.getDynamicObject("intobject");
        if (EmptyUtil.isNoEmpty((DynamicObject)intObj)) {
            this.getModel().setValue("preloannum", intObj.get("name"));
        }
        BatchIntHelper.loanIntDetailInfo((DynamicObject)entry, (AbstractFormPlugin)this, (IDataModel)this.getModel());
    }

    public void afterBindData(EventObject e) {
        this.loanIntEntry(0);
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        String intSource = (String)this.getModel().getValue("intsource");
        String description = StringUtils.equals((CharSequence)IntSourceEnum.INNERACCT.getValue(), (CharSequence)intSource) ? ResManager.loadKDString((String)"\u5185\u90e8\u8d26\u53f7+\u3010\u8d26\u53f7\u3011+\u3010\u7ed3\u606f\u65e5\u671f\u3011+\u6536\u606f+\u3010\u5e01\u79cd\u3011+\u3010\u5229\u606f\u91d1\u989d\u3011", (String)"CurrentIntBillBatchEdit_0", (String)"tmc-ifm-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u79d1\u76ee+\u3010\u8ba1\u606f\u5bf9\u8c61\u540d\u79f0\u3011+\u3010\u7ed3\u606f\u65e5\u671f\u3011+\u6536\u606f+\u3010\u5e01\u79cd\u3011+\u3010\u5229\u606f\u91d1\u989d\u3011", (String)"CurrentIntBillBatchEdit_1", (String)"tmc-ifm-formplugin", (Object[])new Object[0]);
        this.getModel().setValue("description", (Object)description);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        if ("deleteentryloans".equals(operateKey)) {
            String errMsg = this.checkLoansEntry();
            if (EmptyUtil.isNoEmpty((String)errMsg)) {
                args.setCancel(true);
                this.getView().showTipNotification(errMsg);
                return;
            }
            this.dealInterest();
        } else if ("addentryloans".equals(operateKey)) {
            args.setCancel(true);
            this.openAddNewNavigateForm(this.initParams());
        }
    }

    private void openAddNewNavigateForm(FormShowParameter showParameter) {
        showParameter.setFormId("ifm_navigate_addnew");
        showParameter.getCustomParams().put("entity", this.getEntityName());
        showParameter.getCustomParams().put("formid", this.getEntityName());
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, CLOSE_BAKE_KEY_FILTER));
        this.getView().showForm(showParameter);
    }

    private FormShowParameter initParams() {
        HashMap<String, Object> initParams = new HashMap<String, Object>();
        FormShowParameter showParameter = new FormShowParameter();
        DynamicObjectCollection entrys = this.getModel().getEntryEntity("entry");
        List loanIds = entrys.stream().map(dny -> dny.getDynamicObject("intobject").getPkValue()).collect(Collectors.toList());
        showParameter.getCustomParams().put("loanIds", loanIds);
        if (EmptyUtil.isNoEmpty((Object)this.getModel().getValue("settlecenter"))) {
            initParams.put("settlecenter", ((DynamicObject)this.getModel().getValue("settlecenter")).getPkValue());
        }
        initParams.put("bizdate", this.getModel().getValue("bizdate"));
        if (IntObjectTypeEnum.INTERNAL.getValue().equals(((DynamicObject)entrys.get(0)).getDynamicObject("intobject").get("biztype"))) {
            initParams.put("intsource", IntSourceEnum.INNERACCT.getValue());
        } else {
            initParams.put("intsource", IntSourceEnum.ACCOUNTVIEW.getValue());
            initParams.put("currentInt", "true");
        }
        HashSet<String> orgIds = new HashSet<String>(entrys.size());
        HashSet<String> currenyIds = new HashSet<String>(entrys.size());
        for (DynamicObject dyn : entrys) {
            orgIds.add(dyn.getDynamicObject("company").getPkValue().toString());
            currenyIds.add(dyn.getDynamicObject("currency").getPkValue().toString());
        }
        initParams.put("orgs", orgIds);
        initParams.put("currencys", currenyIds);
        showParameter.getCustomParams().put("initParams", initParams);
        return showParameter;
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        if (StringUtils.equals((CharSequence)CLOSE_BAKE_KEY_FILTER, (CharSequence)evt.getActionId()) && null != evt.getReturnData()) {
            Map navParam = (Map)evt.getReturnData();
            List ids = (List)SerializationUtils.fromJsonString((String)navParam.get("intObjects").toString(), List.class);
            String entityName = navParam.get("objecttype").toString();
            DynamicObject[] intObjects = TmcDataServiceHelper.load((String)entityName, (String)"biztype,intobject,org,currency,name,id", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)ids)});
            Map calcIntResult = (Map)JSON.parseObject((String)navParam.get("calcIntResult").toString(), (TypeReference)new TypeReference<Map<Object, IntBillInfo>>(){}, (Feature[])new Feature[0]);
            Date endIntDate = DateUtils.stringToDate((String)navParam.get("endintdate").toString(), (String)"yyyyMMdd");
            ArrayList<Map<String, Object>> dataMap = new ArrayList<Map<String, Object>>(intObjects.length);
            for (DynamicObject intObject : intObjects) {
                IntBillInfo intBill = (IntBillInfo)calcIntResult.get(intObject.getPkValue());
                if (EmptyUtil.isEmpty((Object)intBill)) continue;
                this.fillIntDetail(dataMap, intBill, intObject, endIntDate);
            }
            TmcViewInputHelper.batchFillEntity((String)"entry", (AbstractFormDataModel)((AbstractFormDataModel)this.getModel()), dataMap, (boolean)false);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        if ("submit".equals(operateKey)) {
            this.getView().updateView();
        } else if ("deleteentryloans".equals(operateKey)) {
            this.getView().invokeOperation("save");
        }
        this.loanIntEntry(0);
    }

    private void dealInterest() {
        DynamicObjectCollection cl = this.getModel().getEntryEntity("entry");
        int[] indexs = ((EntryGrid)this.getControl("entry")).getSelectRows();
        OperateOption operateOption = OperateOption.create();
        operateOption.setVariableValue("WF", "TRUE");
        for (int i = 0; i < indexs.length; ++i) {
            Long id = ((DynamicObject)cl.get(indexs[i])).getLong("intbillid");
            if (!EmptyUtil.isNoEmpty((Long)id) || !TmcDataServiceHelper.exists((Object)id, (String)"ifm_currentintbill")) continue;
            TmcOperateServiceHelper.execOperate((String)"unsubmit", (String)"ifm_currentintbill", (Object[])new Object[]{id}, (OperateOption)operateOption, (boolean)true);
            TmcOperateServiceHelper.execOperate((String)"delete", (String)"ifm_currentintbill", (Object[])new Object[]{id}, (OperateOption)operateOption, (boolean)true);
        }
    }

    private String checkLoansEntry() {
        DynamicObjectCollection cl = this.getModel().getEntryEntity("entry");
        int[] indexs = ((EntryGrid)this.getControl("entry")).getSelectRows();
        if (cl.size() == indexs.length) {
            return ResManager.loadKDString((String)"\u81f3\u5c11\u6709\u4e00\u6761\u5206\u5f55", (String)"CurrentPreIntBillBatchEdit_0", (String)"tmc-ifm-formplugin", (Object[])new Object[0]);
        }
        return "";
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        if (StringUtils.equals((CharSequence)"actualinstamt", (CharSequence)e.getProperty().getName())) {
            String intObjectName;
            DynamicObject intObject;
            int entryCurrentRowIndex = this.getModel().getEntryCurrentRowIndex("entry");
            DynamicObject currentEntry = this.getModel().getEntryRowEntity("entry", entryCurrentRowIndex);
            String intSource = (String)this.getModel().getValue("intsource");
            String bizType = StringUtils.equals((CharSequence)IntSourceEnum.INNERACCT.getValue(), (CharSequence)intSource) ? IntObjectTypeEnum.INTERNAL.getValue() : IntObjectTypeEnum.EXTERNAL.getValue();
            QFilter filter = new QFilter("id", "=", currentEntry.getDynamicObject("intobject").getPkValue());
            if (StringUtils.equals((CharSequence)IntSourceEnum.INNERACCT.getValue(), (CharSequence)intSource)) {
                intObject = TmcDataServiceHelper.loadSingle((String)"ifm_intobject", (String)"intobject", (QFilter[])filter.toArray());
                intObjectName = intObject.getDynamicObject("intobject").getString("bankaccountnumber");
            } else {
                intObject = TmcDataServiceHelper.loadSingle((String)"ifm_extintobject", (String)"intobject,name", (QFilter[])filter.toArray());
                intObjectName = intObject.getString("name");
            }
            DynamicObject currency = currentEntry.getDynamicObject("currency");
            Date bizDate = (Date)this.getModel().getValue("bizDate");
            BigDecimal intAmt = currentEntry.getBigDecimal("actualinstamt");
            this.getModel().setValue("intcomment", (Object)this.genIntComment(bizType, intObjectName, bizDate, currency, intAmt), entryCurrentRowIndex);
        }
    }

    @Override
    public void loadIntDetail() {
        Map param = this.getView().getFormShowParameter().getCustomParams();
        JSONObject navParam = (JSONObject)param.get("navparam");
        if (navParam == null) {
            return;
        }
        String entityName = navParam.getString("objecttype");
        List ids = (List)SerializationUtils.fromJsonString((String)navParam.get((Object)"intObjects").toString(), List.class);
        DynamicObject[] intObjects = TmcDataServiceHelper.load((String)entityName, (String)"biztype,intobject,org,currency,name,id", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)ids)});
        Map calcIntResult = (Map)JSON.parseObject((String)navParam.getString("calcIntResult"), (TypeReference)new TypeReference<Map<Object, IntBillInfo>>(){}, (Feature[])new Feature[0]);
        Date endIntDate = navParam.getDate("endintdate");
        ArrayList<Map<String, Object>> dataMap = new ArrayList<Map<String, Object>>(intObjects.length);
        for (DynamicObject intObject : intObjects) {
            IntBillInfo intBill = (IntBillInfo)calcIntResult.get(intObject.getPkValue());
            if (!EmptyUtil.isNoEmpty((Object)intBill)) continue;
            this.fillIntDetail(dataMap, intBill, intObject, endIntDate);
        }
        TmcViewInputHelper.batchFillEntity((String)"entry", (AbstractFormDataModel)((AbstractFormDataModel)this.getModel()), dataMap);
    }

    private void fillIntDetail(List<Map<String, Object>> dataMap, IntBillInfo intBill, DynamicObject intObject, Date endIntDate) {
        String intObjectName;
        DynamicObject currency;
        HashMap<String, Object> detailMap = new HashMap<String, Object>(16);
        String bizType = intObject.getString("biztype");
        if (StringUtils.equals((CharSequence)bizType, (CharSequence)IntObjectTypeEnum.INTERNAL.getValue())) {
            DynamicObject bankAcct = TmcDataServiceHelper.loadSingle((Object)intObject.getDynamicObject("intobject").getPkValue(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bd_accountbanks"));
            currency = ((DynamicObject)bankAcct.getDynamicObjectCollection("currency").get(0)).getDynamicObject("fbasedataid");
            detailMap.put("inneracct", bankAcct);
            detailMap.put("company", bankAcct.getDynamicObject("company"));
            intObjectName = bankAcct.getString("bankaccountnumber");
        } else {
            detailMap.put("company", intObject.getDynamicObject("org"));
            currency = intObject.getDynamicObject("currency");
            detailMap.put("currency", currency);
            intObjectName = intObject.getString("name");
        }
        detailMap.put("currency", currency);
        detailMap.put("intcomment", this.genIntComment(bizType, intObjectName, intBill.getBizDate(), currency, intBill.getAmount()));
        Date beginDate = intBill.getBeginDate();
        Date endDate = intBill.getEndDate();
        if (beginDate != null && endDate != null) {
            detailMap.put("intdays", TermHelper.getDiffDays((Date)beginDate, (Date)endDate) + 1);
        }
        detailMap.put("inttype", SettleTypeEnum.JX.getValue());
        detailMap.put("startdate", beginDate);
        detailMap.put("enddate", endDate);
        detailMap.put("intobject", intObject.getPkValue());
        BigDecimal princple = intBill.getDetails().stream().map(IntBillDetailInfo::getPrinciple).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
        detailMap.put("principle", princple);
        List details = intBill.getDetails();
        details.sort((arg0, arg1) -> arg1.getEndDate().compareTo(arg0.getEndDate()));
        detailMap.put("rate", ((IntBillDetailInfo)details.get(0)).getRate());
        detailMap.put("interestamt", intBill.getAmount());
        detailMap.put("actualinstamt", intBill.getAmount());
        detailMap.put("intdetail_tag", SerializationUtils.toJsonString((Object)intBill));
        dataMap.add(detailMap);
    }

    @Override
    public String getEntityName() {
        return "ifm_intbill_batch_current";
    }

    private String genIntComment(String bizType, String intObjectName, Date bizDate, DynamicObject currency, BigDecimal intAmt) {
        if (StringUtils.equals((CharSequence)bizType, (CharSequence)IntObjectTypeEnum.INTERNAL.getValue())) {
            return String.format(ResManager.loadKDString((String)"\u5185\u90e8\u8d26\u53f7%1$s\uff0c%2$s\u6536\u606f%3$s%4$s", (String)"CurrentIntBillBatchEdit_2", (String)"tmc-ifm-formplugin", (Object[])new Object[0]), intObjectName, DateUtils.formatString((Date)bizDate, (String)"yyyy-MM-dd"), currency.getString("name"), intAmt);
        }
        return String.format(ResManager.loadKDString((String)"\u79d1\u76ee%1$s\uff0c%2$s\u6536\u606f%3$s%4$s", (String)"CurrentIntBillBatchEdit_3", (String)"tmc-ifm-formplugin", (Object[])new Object[0]), intObjectName, DateUtils.formatString((Date)bizDate, (String)"yyyy-MM-dd"), currency.getString("name"), intAmt);
    }
}

