/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.formplugin.intobject;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.enums.UseStatusEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.ifm.enums.IntObjectTypeEnum;
import kd.tmc.ifm.formplugin.intobject.IntObjectBaseEdit;

public class BankIntObjectBatchEdit
extends IntObjectBaseEdit
implements BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addBeforeF7("intobject", "referrate", "intinneracct", "currency");
    }

    private void addBeforeF7(String ... key) {
        for (String fKey : key) {
            BasedataEdit basedataEdit = (BasedataEdit)this.getControl(fKey);
            basedataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String key;
        switch (key = evt.getProperty().getName()) {
            case "intobject": {
                this.innerAcctFilter(evt);
                break;
            }
            case "referrate": {
                this.referrateFilter(evt);
                break;
            }
            case "intinneracct": {
                this.intinnerAcctFilter(evt);
                break;
            }
            case "currency": {
                this.currencyFilter(evt);
                break;
            }
        }
    }

    private void currencyFilter(BeforeF7SelectEvent evt) {
        ListShowParameter sp = (ListShowParameter)evt.getFormShowParameter();
        DynamicObject bankAcct = (DynamicObject)this.getModel().getValue("intobject");
        if (bankAcct != null) {
            List<Object> availableCurrency = this.getAvailableCurrency(bankAcct);
            QFilter filter = EmptyUtil.isNoEmpty(availableCurrency) ? new QFilter("id", "in", availableCurrency) : new QFilter("id", "=", (Object)0);
            sp.getListFilterParameter().getQFilters().add(filter);
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propName = e.getProperty().getName();
        ChangeData changeData = e.getChangeSet()[0];
        switch (propName) {
            case "intobject": {
                this.setOtherValueByBdAccount(changeData);
                break;
            }
            case "currency": {
                this.currencyChgEvt(changeData.getRowIndex());
                break;
            }
        }
    }

    @Override
    public void afterAddRow(AfterAddRowEventArgs e) {
        String entryKey = e.getEntryProp().getName();
        int currRow = e.getRowDataEntities()[0].getRowIndex();
        switch (entryKey) {
            case "entryentity": {
                this.setInitAccumByDate(currRow);
                break;
            }
        }
    }

    private QFilter getFilterByFInOrg() {
        List finOrgIdList = QueryServiceHelper.query((String)"bd_finorginfo", (String)"id", (QFilter[])this.getFinOrgFilter()).stream().map(d -> d.getLong("id")).collect(Collectors.toList());
        QFilter qFilter = new QFilter("finorg", "in", finOrgIdList);
        DynamicObjectCollection inneAccts = QueryServiceHelper.query((String)"ifm_inneracct", (String)"id", (QFilter[])new QFilter[]{qFilter});
        qFilter = EmptyUtil.isNoEmpty((DynamicObjectCollection)inneAccts) ? new QFilter("inneracct", "in", inneAccts.stream().map(d -> d.getLong("id")).collect(Collectors.toSet())) : new QFilter("id", "=", (Object)0);
        return qFilter;
    }

    private void intinnerAcctFilter(BeforeF7SelectEvent evt) {
        int entryCurrentRowIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
        DynamicObject bankAcct = (DynamicObject)this.getModel().getValue("intobject", entryCurrentRowIndex);
        if (bankAcct == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5185\u90e8\u94f6\u884c\u8d26\u6237\u3002", (String)"IntObjectEdit_0", (String)"tmc-ifm-formplugin", (Object[])new Object[0]));
            evt.setCancel(true);
            return;
        }
        DynamicObjectCollection currs = bankAcct.getDynamicObjectCollection("currency");
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)currs)) {
            long currId = ((DynamicObject)currs.get(0)).getDynamicObject("fbasedataid").getLong("id");
            QFilter filter = new QFilter("currency.fbasedataid", "=", (Object)currId).and(this.getFilterByFInOrg()).and(new QFilter("company", "=", bankAcct.getDynamicObject("company").getPkValue())).and(new QFilter("bank", "=", bankAcct.getDynamicObject("bank").getPkValue()));
            ListShowParameter sp = (ListShowParameter)evt.getFormShowParameter();
            sp.setCaption(ResManager.loadKDString((String)"\u94f6\u884c\u8d26\u6237", (String)"BankIntObjectBatchEdit_0", (String)"tmc-ifm-formplugin", (Object[])new Object[0]));
            sp.getListFilterParameter().getQFilters().add(filter);
        }
    }

    private void referrateFilter(BeforeF7SelectEvent evt) {
        ListShowParameter sp = (ListShowParameter)evt.getFormShowParameter();
        DynamicObjectCollection entry = this.getModel().getEntryEntity("entryentity");
        if (EmptyUtil.isEmpty((DynamicObjectCollection)entry)) {
            evt.setCancel(true);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u4e3b\u4f53\u4fe1\u606f", (String)"BankIntObjectBatchEdit_3", (String)"tmc-ifm-formplugin", (Object[])new Object[0]));
            return;
        }
        String emptySeq = entry.stream().filter(v -> EmptyUtil.isEmpty((DynamicObject)v.getDynamicObject("currency"))).map(v -> String.valueOf(v.getInt("seq"))).collect(Collectors.joining(","));
        if (EmptyUtil.isNoEmpty((String)emptySeq)) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e3b\u4f53\u4fe1\u606f\u7b2c%s\u884c\u5e01\u79cd", (String)"BankIntObjectBatchEdit_1", (String)"tmc-ifm-formplugin", (Object[])new Object[0]), emptySeq));
            evt.setCancel(true);
            return;
        }
        Set currencyIds = entry.stream().map(v -> v.getDynamicObject("currency")).map(DataEntityBase::getPkValue).collect(Collectors.toSet());
        if (currencyIds.size() > 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e3b\u4f53\u4fe1\u606f\u4e2d\u7684\u94f6\u884c\u8d26\u6237\u5e01\u79cd\u4e0d\u4e00\u81f4\uff0c\u8bf7\u8c03\u6574", (String)"BankIntObjectBatchEdit_2", (String)"tmc-ifm-formplugin", (Object[])new Object[0]));
            evt.setCancel(true);
        }
        sp.getListFilterParameter().getQFilters().add(new QFilter("currency", "in", currencyIds));
    }

    private void innerAcctFilter(BeforeF7SelectEvent evt) {
        ListShowParameter sp = (ListShowParameter)evt.getFormShowParameter();
        Long userId = RequestContext.get().getCurrUserId();
        String appId = this.getView().getFormShowParameter().getAppId();
        List authorizedBankOrgIds = TmcOrgDataHelper.getAuthorizedBankOrgId((Long)userId, (String)appId, (String)"ifm_bankacctintobject", (String)"47156aff000000ac");
        List qFilters = sp.getListFilterParameter().getQFilters();
        qFilters.add(new QFilter("org", "in", (Object)authorizedBankOrgIds));
        qFilters.add(new QFilter("acctclassify", "=", (Object)"B"));
        Object[] bankIntObjects = TmcDataServiceHelper.load((String)"ifm_bankacctintobject", (String)"intobject,currency", (QFilter[])new QFilter("biztype", "=", (Object)IntObjectTypeEnum.BANKACCT.getValue()).toArray());
        Map dataMap = Arrays.stream(bankIntObjects).filter(v -> EmptyUtil.isNoEmpty((Object)v.get("intobject"))).filter(v -> EmptyUtil.isNoEmpty((Object)v.get("currency"))).collect(Collectors.groupingBy(v -> v.getDynamicObject("intobject").getPkValue(), Collectors.mapping(r -> r.getDynamicObject("currency").getPkValue(), Collectors.toList())));
        if (EmptyUtil.isNoEmpty((Object[])bankIntObjects)) {
            Object[] ids = Arrays.stream(bankIntObjects).map(v -> v.getDynamicObject("intobject")).filter(EmptyUtil::isNoEmpty).map(DataEntityBase::getPkValue).toArray();
            DynamicObject[] bankAccts = TmcDataServiceHelper.load((String)"bd_accountbanks", (String)"currency", (QFilter[])new QFilter("id", "in", (Object)ids).toArray());
            ArrayList<Object> excludeIds = new ArrayList<Object>(bankAccts.length);
            for (DynamicObject bankAcct : bankAccts) {
                List exCurrencyIds = dataMap.get(bankAcct.getPkValue());
                DynamicObjectCollection currencys = bankAcct.getDynamicObjectCollection("currency");
                if (!EmptyUtil.isNoEmpty(exCurrencyIds) || !EmptyUtil.isNoEmpty((DynamicObjectCollection)currencys) || exCurrencyIds.size() != currencys.size()) continue;
                excludeIds.add(bankAcct.getPkValue());
            }
            if (EmptyUtil.isNoEmpty(excludeIds)) {
                qFilters.add(new QFilter("id", "not in", excludeIds));
            }
        }
        sp.setCaption(ResManager.loadKDString((String)"\u94f6\u884c\u8d26\u6237", (String)"BankIntObjectBatchEdit_0", (String)"tmc-ifm-formplugin", (Object[])new Object[0]));
    }

    private QFilter[] getFinOrgFilter() {
        QFilter finOrgTypeFilter = new QFilter("finorgtype.type", "=", (Object)"1");
        Long userId = RequestContext.get().getCurrUserId();
        String appId = this.getView().getFormShowParameter().getAppId();
        List authIdList = TmcOrgDataHelper.getAuthorizedBankOrgId((Long)userId, (String)appId, (String)"ifm_inneracct", (String)"47150e89000000ac");
        QFilter finOrgFilter = new QFilter("org", "in", (Object)authIdList);
        return new QFilter[]{finOrgTypeFilter, finOrgFilter, this.getSettleCenterids()};
    }

    private QFilter getSettleCenterids() {
        QFilter[] filters = new QFilter[]{new QFilter("usestatus", "=", (Object)UseStatusEnum.STARTED.getValue())};
        DynamicObjectCollection settleSettings = QueryServiceHelper.query((String)"ifm_settcentersetting", (String)"id,settlecenter", (QFilter[])filters);
        HashSet<Long> settleCenterids = new HashSet<Long>(settleSettings.size());
        for (DynamicObject settleSetting : settleSettings) {
            settleCenterids.add(settleSetting.getLong("settlecenter"));
        }
        return new QFilter("id", "in", settleCenterids);
    }

    private void setOtherValueByBdAccount(ChangeData changeData) {
        DynamicObject bankAcct = (DynamicObject)changeData.getNewValue();
        if (bankAcct == null) {
            return;
        }
        int rowIndex = changeData.getRowIndex();
        List<Object> availableCurrency = this.getAvailableCurrency(bankAcct);
        if (EmptyUtil.isNoEmpty(availableCurrency)) {
            Object defCurrency = bankAcct.getDynamicObject("defaultcurrency").getPkValue();
            if (!availableCurrency.contains(defCurrency)) {
                defCurrency = availableCurrency.get(0);
            }
            this.getModel().setValue("currency", defCurrency, rowIndex);
        }
    }

    private void setInitAccumByDate(int rowIndex) {
        Object startIntDate = this.getModel().getValue("startintdate");
        Object lastIntDate = this.getModel().getValue("lastintdate");
        this.setInitAccum(startIntDate, lastIntDate, rowIndex);
    }

    private List<Object> getAvailableCurrency(DynamicObject bankAcct) {
        List excludeCurrency;
        Object[] existIntObjects = TmcDataServiceHelper.load((String)"ifm_intobject", (String)"currency", (QFilter[])new QFilter("intobject", "=", bankAcct.getPkValue()).toArray());
        List<Object> currency = bankAcct.getDynamicObjectCollection("currency").stream().map(v -> v.getDynamicObject("fbasedataid").getPkValue()).collect(Collectors.toList());
        if (EmptyUtil.isNoEmpty((Object[])existIntObjects) && EmptyUtil.isNoEmpty(excludeCurrency = Arrays.stream(existIntObjects).map(v -> v.getDynamicObject("currency")).filter(EmptyUtil::isNoEmpty).map(DataEntityBase::getPkValue).collect(Collectors.toList()))) {
            currency.removeAll(excludeCurrency);
        }
        return currency;
    }

    private void currencyChgEvt(int rowIndex) {
        DynamicObject entryRowEntity = this.getModel().getEntryRowEntity("entryentity", rowIndex);
        DynamicObject currency = entryRowEntity.getDynamicObject("currency");
        DynamicObject bankAcct = entryRowEntity.getDynamicObject("intobject");
        if (EmptyUtil.isNoEmpty((DynamicObject)currency) && EmptyUtil.isNoEmpty((DynamicObject)bankAcct)) {
            String defName = bankAcct.getString("number") + currency.getString("number");
            this.getModel().setValue("name", (Object)defName, rowIndex);
        }
    }
}

