/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.formplugin.intobject;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.BeforeDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.BeforeFieldPostBackEvent;
import kd.bos.form.field.DateEdit;
import kd.bos.form.operate.AbstractOperate;
import kd.tmc.fbp.common.constant.Constants;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.formplugin.edit.AbstractTmcBillEdit;
import kd.tmc.ifm.enums.IntEntryTypeEnum;
import kd.tmc.ifm.enums.InterestWayEnum;
import kd.tmc.ifm.formplugin.resource.IfmFormResource;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class IntObjectBaseEdit
extends AbstractTmcBillEdit {
    private static final int INT_ENTRY_MIN_ROW = 2;
    private static final int INT_ENTRY_MAX_ROW = 10;
    protected static final String[] ENABLE_KEYS = new String[]{"fs_baseinfo", "fieldsetpanelap2", "depositintconfigap", "overintconfigap", "flexpanelap1"};
    protected static final String[] VISIBLE_KEYS = new String[]{"bar_save", "advcontoolbarap1", "advcontoolbarap"};

    public void afterCreateNewData(EventObject e) {
        DateEdit lastDateEdit = (DateEdit)this.getControl("lastintdate");
        lastDateEdit.setMaxDate(DateUtils.getCurrentDate());
        this.callOverIntChgEvt();
        this.disableInitAccum(new int[0]);
    }

    public void beforeFieldPostBack(BeforeFieldPostBackEvent e) {
        String key;
        Control source = (Control)e.getSource();
        switch (key = source.getKey()) {
            case "depositamtend": {
                this.depositEndBeforeChgEvt(e, "depositint_entry", "depositamtbegin", key);
                break;
            }
            case "depositend": {
                this.depositEndBeforeChgEvt(e, "overint_entry", "depositbegin", key);
                break;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propName = e.getProperty().getName();
        Object newValue = e.getChangeSet()[0].getNewValue();
        switch (propName) {
            case "iscaloverint": {
                this.callOverIntChgEvt();
                this.initOverIntEntry();
                break;
            }
            case "startintdate": {
                this.startIntDateChgEvt(newValue);
                break;
            }
            case "lastintdate": {
                this.lastIntDateChgEvt(newValue);
                break;
            }
            case "interestway": {
                this.initDepositIntEntry();
                this.initOverIntEntry();
                break;
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        AbstractOperate op = (AbstractOperate)args.getSource();
        switch (operateKey = op.getOperateKey()) {
            case "insertdepintentry": {
                this.beforeDoAddIntEntryRow(args, "depositint_entry", "depositamtend");
                break;
            }
            case "insertoverintentry": {
                this.beforeDoAddIntEntryRow(args, "overint_entry", "depositend");
                break;
            }
        }
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        String entryKey = e.getEntryProp().getName();
        int currRow = e.getRowDataEntities()[0].getRowIndex();
        switch (entryKey) {
            case "depositint_entry": {
                this.afterAddIntEntryRow(currRow, "depositamtbegin", "depositamtend", entryKey);
                break;
            }
            case "overint_entry": {
                this.afterAddIntEntryRow(currRow, "depositbegin", "depositend", entryKey);
                break;
            }
        }
    }

    public void beforeDeleteRow(BeforeDeleteRowEventArgs e) {
        String entryKey;
        switch (entryKey = e.getEntryProp().getName()) {
            case "depositint_entry": {
                this.beforeDeleteIntEntryRow(e, entryKey, "depositamtbegin", "depositamtend");
                break;
            }
            case "overint_entry": {
                this.beforeDeleteIntEntryRow(e, entryKey, "depositbegin", "depositend");
                break;
            }
        }
    }

    protected void callOverIntChgEvt() {
        boolean isCallOverInt = (Boolean)this.getModel().getValue("iscaloverint");
        if (!isCallOverInt) {
            TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)false, (String[])new String[]{"oversign", "overpoints"});
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"oversign", (Object)"");
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"overpoints", (Object)0);
        } else {
            TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)true, (String[])new String[]{"oversign", "overpoints"});
        }
    }

    private void startIntDateChgEvt(Object newValue) {
        if (Objects.isNull(newValue)) {
            this.disableInitAccum(new int[0]);
            return;
        }
        IDataModel model = this.getModel();
        Date startIntDate = (Date)newValue;
        Object lastIntDate = model.getValue("lastintdate");
        if (Objects.isNull(lastIntDate) || startIntDate.before((Date)lastIntDate)) {
            model.setValue("lastintdate", (Object)startIntDate);
        }
        this.setInitAccum(newValue, lastIntDate, new int[0]);
        DateEdit lastDateEdit = (DateEdit)this.getControl("lastintdate");
        lastDateEdit.setMaxDate(startIntDate);
    }

    private void lastIntDateChgEvt(Object newValue) {
        String entityName = this.getModel().getDataEntityType().getName();
        if (StringUtils.equalsAny((CharSequence)entityName, (CharSequence[])new CharSequence[]{"ifm_intobjectbatch", "ifm_intobject"})) {
            Date lastIntDate = (Date)this.getModel().getValue("lastintdate");
            this.getModel().setValue("lastpreintdate", (Object)lastIntDate);
        }
        if (Objects.isNull(newValue)) {
            this.disableInitAccum(new int[0]);
            return;
        }
        this.setInitAccum(this.getModel().getValue("startintdate"), newValue, new int[0]);
    }

    protected void setInitAccum(Object startIntDate, Object lastIntDate, int ... rowIdxs) {
        if (Objects.nonNull(lastIntDate) && Objects.nonNull(startIntDate) && ((Date)lastIntDate).before((Date)startIntDate)) {
            this.enableInitAccum(rowIdxs);
        } else {
            this.disableInitAccum(rowIdxs);
        }
    }

    private void disableInitAccum(int ... rowIdxs) {
        EntryGrid entryEntity = (EntryGrid)this.getView().getControl("entryentity");
        if (entryEntity != null) {
            if (ArrayUtils.isNotEmpty((int[])rowIdxs)) {
                Arrays.stream(rowIdxs).forEach(idx -> this.disableInitAccumForRow(idx));
            } else {
                int rowCount = this.getModel().getEntryRowCount("entryentity");
                for (int i = 0; i < rowCount; ++i) {
                    this.disableInitAccumForRow(i);
                }
            }
        } else {
            this.getModel().setValue("initaccum", (Object)Constants.ZERO);
            this.getView().setEnable(Boolean.FALSE, new String[]{"initaccum"});
        }
    }

    private void disableInitAccumForRow(int rowIdx) {
        this.getModel().setValue("initaccum", (Object)Constants.ZERO, rowIdx);
        this.getView().setEnable(Boolean.FALSE, rowIdx, new String[]{"initaccum"});
    }

    private void enableInitAccum(int ... rowIdxs) {
        IFormView view = this.getView();
        EntryGrid entryEntity = (EntryGrid)view.getControl("entryentity");
        if (entryEntity != null) {
            if (ArrayUtils.isNotEmpty((int[])rowIdxs)) {
                Arrays.stream(rowIdxs).forEach(idx -> view.setEnable(Boolean.TRUE, idx, new String[]{"initaccum"}));
            } else {
                int rowCount = this.getModel().getEntryRowCount("entryentity");
                for (int i = 0; i < rowCount; ++i) {
                    view.setEnable(Boolean.TRUE, i, new String[]{"initaccum"});
                }
            }
        } else {
            view.setEnable(Boolean.TRUE, new String[]{"initaccum"});
        }
    }

    private void initDepositIntEntry() {
        IDataModel model = this.getModel();
        Object interestway = model.getValue("interestway");
        int rowCount = model.getEntryRowCount("depositint_entry");
        if (!InterestWayEnum.isProgression((Object)interestway) || rowCount > 0) {
            return;
        }
        model.beginInit();
        model.batchCreateNewEntryRow("depositint_entry", 2);
        model.setValue("depositamtbegin", (Object)Constants.ZERO, 0);
        model.setValue("depositamtend", (Object)Constants.ONE_HUNDRED_THOUSAND, 0);
        model.setValue("depositamtbegin", (Object)Constants.ONE_HUNDRED_THOUSAND, 1);
        model.endInit();
        this.getView().updateView("depositint_entry");
    }

    private void initOverIntEntry() {
        boolean isOverIntEntry;
        IDataModel model = this.getModel();
        Object interestway = model.getValue("interestway");
        Boolean iscaloverint = (Boolean)model.getValue("iscaloverint");
        int rowCount = model.getEntryRowCount("overint_entry");
        boolean bl = isOverIntEntry = InterestWayEnum.isProgression((Object)interestway) && iscaloverint != false;
        if (!isOverIntEntry || rowCount > 0) {
            return;
        }
        model.beginInit();
        model.batchCreateNewEntryRow("overint_entry", 2);
        model.setValue("depositbegin", (Object)Constants.ZERO, 0);
        model.setValue("depositend", (Object)Constants.ONE_HUNDRED_THOUSAND, 0);
        model.setValue("depositbegin", (Object)Constants.ONE_HUNDRED_THOUSAND, 1);
        model.endInit();
        this.getView().updateView("overint_entry");
    }

    private void depositEndBeforeChgEvt(BeforeFieldPostBackEvent e, String entryKey, String depBeginKey, String depEndKey) {
        BigDecimal nextDepBeginVal;
        BigDecimal oldVal;
        boolean isLastRow;
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        int currRow = e.getRowIndex();
        Object newValue = e.getValue();
        int rowCount = model.getEntryRowCount(entryKey);
        int lastRow = rowCount - 1;
        boolean bl = isLastRow = currRow == lastRow;
        if (this.isPositiveInfinity(newValue)) {
            if (!isLastRow) {
                view.showTipNotification(IfmFormResource.getDepEndIsNUllTip(IntEntryTypeEnum.getNameByKey((String)entryKey), currRow));
            }
            return;
        }
        if (isLastRow && rowCount == 10) {
            view.showTipNotification(IfmFormResource.getLastRowDepEndMustNullTip());
            e.setCancel(true);
            view.updateView(depEndKey, currRow);
            return;
        }
        BigDecimal newVal = new BigDecimal(newValue.toString());
        if (newVal.compareTo(oldVal = new BigDecimal(model.getValue(depEndKey, currRow).toString())) == 0) {
            return;
        }
        BigDecimal amtBegin = new BigDecimal(model.getValue(depBeginKey, currRow).toString());
        if (!this.isPositiveInfinity(newVal) && amtBegin.compareTo(newVal) >= 0) {
            view.showTipNotification(IfmFormResource.getLessThanDepBeginTip());
            e.setCancel(true);
            view.updateView(depEndKey, currRow);
            return;
        }
        int nextRow = currRow + 1;
        Object nextDepBegin = model.getValue(depEndKey, nextRow);
        if (Objects.nonNull(nextDepBegin) && !this.isPositiveInfinity(nextDepBeginVal = new BigDecimal(nextDepBegin.toString())) && newVal.compareTo(nextDepBeginVal) >= 0) {
            view.showTipNotification(IfmFormResource.getGreatThanNextDepEndTip());
            e.setCancel(true);
            view.updateView(depEndKey, currRow);
            return;
        }
        if (rowCount < 10 && currRow == lastRow && this.isPositiveInfinity(oldVal)) {
            model.beginInit();
            model.appendEntryRow(entryKey, currRow, 1);
            model.endInit();
            view.updateView(entryKey);
            ++lastRow;
        }
        if (nextRow <= lastRow) {
            model.setValue(depBeginKey, newValue, nextRow);
        }
    }

    private boolean isPositiveInfinity(Object val) {
        return EmptyUtil.isEmpty((Object)val);
    }

    private void beforeDoAddIntEntryRow(BeforeDoOperationEventArgs args, String entryKey, String depEndKey) {
        IDataModel model = this.getModel();
        DynamicObjectCollection entrys = model.getEntryEntity(entryKey);
        int rowCount = entrys.size();
        if (rowCount >= 10) {
            this.getView().showTipNotification(IfmFormResource.getIntAtMost10RowTip());
            args.setCancel(true);
            return;
        }
        int lastRow = rowCount - 1;
        String entryTypeName = IntEntryTypeEnum.getNameByKey((String)entryKey);
        for (int i = 0; i < lastRow; ++i) {
            Object depEnd = ((DynamicObject)entrys.get(i)).get(depEndKey);
            if (!EmptyUtil.isEmpty((Object)depEnd)) continue;
            this.getView().showTipNotification(IfmFormResource.getDepEndIsNUllTip(entryTypeName, i));
            args.setCancel(true);
            return;
        }
    }

    private void afterAddIntEntryRow(int currRow, String depBeginKey, String depEndKey, String entry) {
        IDataModel model = this.getModel();
        if (currRow == 0) {
            model.setValue(depBeginKey, (Object)Constants.ZERO, currRow);
        }
        Object prevDepEnd = model.getValue(depEndKey, currRow - 1);
        model.setValue(depBeginKey, prevDepEnd, currRow);
        if (model.getEntryRowCount(entry) - 1 > currRow) {
            model.setValue(depBeginKey, null, currRow + 1);
        }
    }

    private void beforeDeleteIntEntryRow(BeforeDeleteRowEventArgs e, String entryKey, String depBeginKey, String depEndKey) {
        int delStartIdx;
        boolean isOverIntEtyLess2;
        int[] delRows;
        int delCount;
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        Object value = model.getValue("interestway");
        if (!InterestWayEnum.isProgression((Object)value)) {
            return;
        }
        int rowCount = model.getEntryRowCount(entryKey);
        boolean less2Row = rowCount - (delCount = (delRows = e.getRowIndexs()).length) < 2;
        boolean isDepIntEtyLess2 = "depositint_entry".equals(entryKey) && less2Row;
        boolean bl = isOverIntEtyLess2 = "overint_entry".equals(entryKey) && (Boolean)model.getValue("iscaloverint") != false && less2Row;
        if (isDepIntEtyLess2 || isOverIntEtyLess2) {
            view.showTipNotification(IfmFormResource.getIntAtLeast2RowTip());
            e.setCancel(true);
            return;
        }
        int lastRow = rowCount - 1;
        int delEndIdx = delStartIdx = 0;
        while (delEndIdx < delCount) {
            int delStartRow;
            int delEndRow = delStartRow = delRows[delStartIdx];
            while (delEndIdx + 1 < delCount && delRows[delEndIdx + 1] == delStartRow + 1) {
                delEndRow = delRows[++delEndIdx];
            }
            if (delStartRow == 0) {
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)view, (IDataModel)model, (String)depBeginKey, (Object)Constants.ZERO, (int)(delEndRow + 1));
            } else if (delEndRow == lastRow) {
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)view, (IDataModel)model, (String)depEndKey, null, (int)(delStartRow - 1));
            } else {
                Object nextDepBegin = model.getValue(depBeginKey, delEndRow + 1);
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)view, (IDataModel)model, (String)depEndKey, (Object)nextDepBegin, (int)(delStartRow - 1));
            }
            delStartIdx = ++delEndIdx;
        }
    }
}

