/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.formplugin.loanbill;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.util.DynamicObjectSerializeUtil;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.enums.TmcAppEnum;
import kd.tmc.fbp.common.errorcode.TmcErrorCode;
import kd.tmc.fbp.common.exception.TmcBizException;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.formplugin.list.AbstractTmcListPlugin;
import kd.tmc.ifm.enums.DrawTypeEnum;
import kd.tmc.ifm.helper.IfmSysParamHelper;
import kd.tmc.ifm.resource.IfmBizResource;

public class IfmLoanBillList
extends AbstractTmcListPlugin {
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        if ("push2bankinstbill".equals(operate.getOperateKey())) {
            args.setCancel(true);
            this.openIntBatchEdit();
        } else if ("push2repaybill".equals(operate.getOperateKey())) {
            IListView listview = (IListView)this.getView();
            ListSelectedRowCollection selectedRows = listview.getSelectedRows();
            DynamicObject loanBillDO = TmcDataServiceHelper.loadSingle((Object)selectedRows.get(0).getPrimaryKeyValue(), (String)"cfm_loanbill", (String)"loancontractbill");
            DynamicObject loancontractbill = loanBillDO.getDynamicObject("loancontractbill");
            IfmBizResource ifmBizResource = new IfmBizResource();
            DynamicObject contractBill = TmcDataServiceHelper.loadSingle((String)"cfm_loancontractbill", (String)"notrepayamount", (QFilter[])new QFilter[]{new QFilter("id", "=", loancontractbill.getPkValue())});
            BigDecimal notRepayAmount = contractBill.getBigDecimal("notrepayamount");
            if (EmptyUtil.isEmpty((BigDecimal)notRepayAmount)) {
                this.getView().showTipNotification(ifmBizResource.getUnRepayAmtIsNotNull());
                args.setCancel(true);
                return;
            }
        }
    }

    protected void openIntBatchEdit() {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setStatus(OperationStatus.ADDNEW);
        parameter.setFormId("cfm_navigate_addnew");
        Object[] loanBills = this.getLoanBills();
        String dJson = DynamicObjectSerializeUtil.serialize((Object[])loanBills, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"ifm_loanbill"));
        boolean isPayIntByPlan = this.isPayIntByPlan((DynamicObject[])loanBills);
        parameter.setCustomParam("loanbill", (Object)dJson);
        parameter.setCustomParam("settlecenter", (Object)this.getSettleCenter((DynamicObject[])loanBills).getLong("id"));
        parameter.setCustomParam("loanInt", (Object)true);
        parameter.setCustomParam("fromLoanBill", (Object)true);
        parameter.setCustomParam("isPayIntByPlan", (Object)isPayIntByPlan);
        parameter.setCustomParam("formid", (Object)"ifm_intbill_batch_loan");
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "CLOSE_BAKE_KEY_FILTER"));
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        StyleCss sc = new StyleCss();
        sc.setHeight("340px");
        parameter.getOpenStyle().setInlineStyleCss(sc);
        this.getView().showForm(parameter);
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        if (StringUtils.equals((CharSequence)"CLOSE_BAKE_KEY_FILTER", (CharSequence)evt.getActionId()) && null != evt.getReturnData()) {
            BillShowParameter parameter = new BillShowParameter();
            parameter.setStatus(OperationStatus.ADDNEW);
            parameter.setFormId("ifm_intbill_batch_loan");
            parameter.setCustomParam("navparam", evt.getReturnData());
            parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "CLOSE_BAKE_KEY_EXIST"));
            this.getView().showForm((FormShowParameter)parameter);
        } else if (StringUtils.equals((CharSequence)"CLOSE_BAKE_KEY_EXIST", (CharSequence)evt.getActionId())) {
            BillList billList = (BillList)this.getControl("billlistap");
            billList.refresh();
        }
    }

    protected DynamicObject[] getLoanBills() {
        QFilter filter = new QFilter("id", "in", (Object)this.getSelectedIdList().toArray());
        filter = filter.and(new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()));
        String selects = "id, currency, org, loancontractbill, contractno, billno, name, settlecenter, creditorg";
        DynamicObject[] loanBills = TmcDataServiceHelper.load((String)"ifm_loanbill", (String)selects, (QFilter[])(filter = filter.and(new QFilter("drawtype", "in", Arrays.asList(DrawTypeEnum.DRAWED.getValue(), DrawTypeEnum.PARTPAYMENT.getValue(), DrawTypeEnum.ALLPAYMENT.getValue())))).toArray());
        if (loanBills.length <= 0) {
            String message = ResManager.loadKDString((String)"\u5df2\u653e\u6b3e\u6216\u5df2\u90e8\u5206\u6536\u56de\u6216\u5df2\u8fd8\u6e05\u7684\u653e\u6b3e\u5355\u53ef\u4ee5\u64cd\u4f5c\u7ed3\u606f", (String)"IfmLoanBillEdit_0", (String)"tmc-ifm-formplugin", (Object[])new Object[0]);
            throw new TmcBizException(TmcErrorCode.COMMON, new Object[]{message});
        }
        return loanBills;
    }

    protected DynamicObject getSettleCenter(DynamicObject[] loanBills) {
        Set settleCenter = Arrays.stream(loanBills).map(v -> v.getDynamicObject("settlecenter")).collect(Collectors.toSet());
        if (settleCenter.size() > 1) {
            String message = ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u4e2a\u7ed3\u7b97\u4e2d\u5fc3\u6570\u636e\u8fdb\u884c\u7ed3\u606f\u5904\u7406", (String)"IfmLoanBillList_0", (String)"tmc-ifm-formplugin", (Object[])new Object[0]);
            throw new TmcBizException(TmcErrorCode.COMMON, new Object[]{message});
        }
        return (DynamicObject)settleCenter.iterator().next();
    }

    private boolean isPayIntByPlan(DynamicObject[] loanBills) {
        ArrayList<Long> ids = new ArrayList<Long>(loanBills.length);
        for (DynamicObject loanBill : loanBills) {
            boolean isPayIntByPlan = this.isPayIntByPlan(loanBill);
            if (!isPayIntByPlan) continue;
            ids.add(loanBill.getLong("id"));
        }
        if (ids.size() > 0 && ids.size() < loanBills.length) {
            String message = String.format(ResManager.loadKDString((String)"\u6240\u9009\u5355\u636e\u503a\u6743\u4eba\u7ec4\u7ec7\u7684\u6309\u4ed8\u606f\u8ba1\u5212\u4ed8\u606f\u7684\u53c2\u6570\u4e0d\u4e00\u81f4\uff0c\u4e0d\u80fd\u6279\u91cf\u7ed3\u606f\u3002", (String)"IfmLoanBillList_2", (String)"tmc-ifm-formplugin", (Object[])new Object[0]), new Object[0]);
            throw new TmcBizException(TmcErrorCode.COMMON, new Object[]{message});
        }
        return ids.size() == loanBills.length;
    }

    private boolean isPayIntByPlan(DynamicObject loanBill) {
        DynamicObject org = loanBill.getDynamicObject("creditorg");
        if (EmptyUtil.isEmpty((DynamicObject)org)) {
            return false;
        }
        return IfmSysParamHelper.getAppBoolParameter((String)TmcAppEnum.CFM.getId(), (long)org.getLong("id"), (String)"cfm012");
    }
}

