/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.formplugin.loancontract;

import java.math.BigDecimal;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ImportDataEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.tmc.fbp.common.enums.FinOrgTypeEnum;
import kd.tmc.fbp.common.enums.InterestTypeEnum;
import kd.tmc.fbp.common.enums.TmcAppEnum;
import kd.tmc.fbp.common.helper.BillChangeHistoryHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.ifm.helper.IfmSettleCenterHelper;
import kd.tmc.ifm.helper.LoanBillHelper;

public class IfmLoanContractBillEdit
extends AbstractBasePlugIn
implements BeforeF7SelectListener {
    public static final String FINORGTYPE_TYPE = "finorgtype.type";
    public static final Long INNER_LOAN_FIN_PRODUCT_ID = 1312902938536014848L;
    private static String[] BASE_PROPS = new String[]{"accountbank", "settlecenter", "finproduct", "e_drawacctbank"};

    public void registerListener(EventObject e) {
        for (String prop : BASE_PROPS) {
            BasedataEdit control = (BasedataEdit)this.getControl(prop);
            if (control == null) continue;
            control.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String key;
        switch (key = evt.getProperty().getName()) {
            case "accountbank": 
            case "e_drawacctbank": {
                this.initLoanerAcctBankFilter(evt);
                break;
            }
            case "settlecenter": {
                this.settleCenterF7Evt(evt);
                break;
            }
            case "finproduct": {
                this.financingTypeF7Evt(evt);
                break;
            }
        }
    }

    public void afterCopyData(EventObject e) {
        super.afterCopyData(e);
        IDataModel model = (IDataModel)e.getSource();
        DynamicObject finproduct = (DynamicObject)model.getValue("finproduct");
        this.setDefaultValue(finproduct, true);
        this.getModel().setValue("bizdealno", null);
    }

    private void financingTypeF7Evt(BeforeF7SelectEvent evt) {
        DynamicObject center = (DynamicObject)this.getModel().getValue("settlecenter");
        if (center == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u503a\u6743\u4eba\u3002", (String)"IfmLoanContractBillEdit_0", (String)"tmc-ifm-formplugin", (Object[])new Object[0]));
            evt.setCancel(true);
            return;
        }
        ListShowParameter sp = (ListShowParameter)evt.getFormShowParameter();
        Object pkValue = center.getPkValue();
        QFilter filter = new QFilter("enable", "=", (Object)"1").and(new QFilter("currency", ">", (Object)0).and(new QFilter("center.id", "=", pkValue)));
        sp.getCustomParams().put("containDefault", "true");
        sp.getListFilterParameter().getQFilters().add(filter);
    }

    private void settleCenterF7Evt(BeforeF7SelectEvent evt) {
        ListShowParameter sp = (ListShowParameter)evt.getFormShowParameter();
        List settleCenterIds = IfmSettleCenterHelper.getAuthorizedRegisteredSettleCenterIds((Long)RequestContext.get().getCurrUserId(), (String)TmcAppEnum.IFM.getValue(), (String)"ifm_loancontractbill", (String)"47150e89000000ac");
        QFilter filter = new QFilter("id", "in", (Object)settleCenterIds);
        sp.getListFilterParameter().getQFilters().add(filter);
    }

    private void initLoanerAcctBankFilter(BeforeF7SelectEvent evt) {
        if (!TmcViewInputHelper.checkMustInput((IFormView)this.getView(), (IDataModel)this.getModel(), (boolean)false, (String[])new String[]{"settlecenter", "currency"})) {
            evt.setCancel(true);
            return;
        }
        ListShowParameter sp = (ListShowParameter)evt.getFormShowParameter();
        DynamicObject settleCenter = (DynamicObject)this.getModel().getValue("settlecenter");
        QFilter filter = new QFilter("bank.id", "=", settleCenter.getPkValue());
        DynamicObject currency = (DynamicObject)this.getModel().getValue("currency");
        filter.and("currency.fbasedataid", "=", currency.getPkValue());
        sp.getListFilterParameter().getQFilters().add(filter);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String property;
        boolean loadEntry = BillChangeHistoryHelper.loadEntrysInfo((IFormView)this.getView());
        if (loadEntry) {
            return;
        }
        switch (property = e.getProperty().getName()) {
            case "finproduct": {
                this.finProductChgEvt(e);
                break;
            }
            case "startdate": {
                this.setRateAdjustdate();
                break;
            }
            case "islimitclause": {
                Boolean isLimitClause = (Boolean)this.getModel().getValue("islimitclause");
                if (!isLimitClause.booleanValue()) break;
                TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)true, (String[])new String[]{"limitclauseexplain"});
                break;
            }
            case "settlecenter": {
                this.getModel().setValue("finproduct", null);
                break;
            }
            case "currency": {
                this.getModel().setValue("accountbank", null);
                break;
            }
        }
    }

    public void afterCreateNewData(EventObject e) {
        this.setRateAdjustdate();
        this.setDefaultCenter();
    }

    public void afterBindData(EventObject e) {
        this.setDefaultFinProduct();
    }

    private void setDefaultFinProduct() {
        String formId = this.getView().getFormShowParameter().getFormId();
        DynamicObject finproduct = (DynamicObject)this.getModel().getValue("finproduct");
        if ("ifm_loancontractbill".equals(formId) && EmptyUtil.isEmpty((DynamicObject)finproduct)) {
            this.getModel().setValue("finproduct", (Object)INNER_LOAN_FIN_PRODUCT_ID);
        }
    }

    private void setDefaultCenter() {
        long orgId = RequestContext.get().getOrgId();
        QFilter clearinghouseFilter = new QFilter(FINORGTYPE_TYPE, "=", (Object)FinOrgTypeEnum.CLEARINGHOUSE.getValue());
        QFilter orgFilter = new QFilter("org", "=", (Object)orgId);
        QFilter[] qFilters = new QFilter[]{clearinghouseFilter, orgFilter};
        DynamicObject clearinghouse = BusinessDataServiceHelper.loadSingle((String)"bd_finorginfo", (String)"id,number,name,org", (QFilter[])qFilters);
        if (clearinghouse != null) {
            this.getModel().setValue("settlecenter", (Object)clearinghouse);
            this.getModel().setValue("textcreditor", (Object)clearinghouse.getString("name"));
            this.getModel().setValue("creditorg", (Object)clearinghouse.getDynamicObject("org").getLong("id"));
            this.getModel().setValue("creditor", (Object)clearinghouse.getLong("id"));
        }
    }

    private void setRateAdjustdate() {
        Date startDate = this.getModel().getDataEntity().getDate("startdate");
        this.getModel().setValue("rateadjustdate", (Object)startDate);
    }

    private void finProductChgEvt(PropertyChangedArgs e) {
        DynamicObject finproduct = (DynamicObject)e.getChangeSet()[0].getNewValue();
        this.setDefaultValue(finproduct, false);
    }

    private void setDefaultValue(DynamicObject finproduct, boolean copy) {
        if (EmptyUtil.isNoEmpty((DynamicObject)finproduct)) {
            this.getModel().setValue("basis", (Object)finproduct.getString("basis"));
            this.getModel().setValue("currency", (Object)finproduct.getDynamicObject("currency"));
            String ratetype = finproduct.getString("ratetype");
            boolean isFloatRate = InterestTypeEnum.FLOAT.getValue().equals(ratetype);
            if (EmptyUtil.isEmpty((String)ratetype)) {
                this.getView().setEnable(Boolean.TRUE, new String[]{"basis", "currency", "interesttype", "referencerate", "startinterestrate"});
            } else {
                this.getModel().setValue("interesttype", (Object)ratetype);
                this.getView().setEnable(Boolean.FALSE, new String[]{"basis", "currency", "interesttype", "referencerate", "startinterestrate"});
            }
            if (isFloatRate) {
                this.getModel().setValue("referencerate", (Object)finproduct.getDynamicObject("referrate"));
                this.getModel().setValue("ratesign", (Object)finproduct.getString("ratesignbp"));
                this.getModel().setValue("ratefloatpoint", (Object)finproduct.getBigDecimal("ratefloatpoints"));
                this.getView().setEnable(Boolean.TRUE, new String[]{"ratesign", "ratefloatpoint"});
            } else {
                if (!copy) {
                    BigDecimal price = finproduct.getBigDecimal("productprice");
                    this.getModel().setValue("startinterestrate", (Object)price);
                }
                this.getModel().setValue("referencerate", null);
                this.getModel().setValue("ratesign", null);
                this.getModel().setValue("ratefloatpoint", null);
                this.getView().setEnable(Boolean.TRUE, new String[]{"startinterestrate"});
            }
        } else {
            this.getView().setEnable(Boolean.TRUE, new String[]{"currency", "interesttype", "referencerate", "ratesign", "ratefloatpoint", "startinterestrate"});
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        Long contractId;
        String validateResult;
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String opKey = operate.getOperateKey();
        if ("pushbankloan".equals(opKey) && EmptyUtil.isNoEmpty((String)(validateResult = LoanBillHelper.validateIfAllowPushLoanBill((Long)(contractId = (Long)this.getModel().getValue("id")))))) {
            args.setCancel(true);
            this.getView().showErrorNotification(validateResult);
        }
    }

    public void afterImportData(ImportDataEventArgs e) {
        super.afterImportData(e);
        DynamicObject sc = (DynamicObject)this.getModel().getValue("settlecenter");
        if (sc != null) {
            this.getModel().setValue("textcreditor", (Object)sc.getString("name"));
            this.getModel().setValue("creditor", (Object)sc.getLong("id"));
        } else {
            this.getModel().setValue("textcreditor", null);
            this.getModel().setValue("creditor", null);
        }
    }
}

