/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.formplugin.payacceptancebill;

import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbp.common.enums.BankAcctStatusEnum;
import kd.tmc.fbp.common.enums.BaseEnableEnum;
import kd.tmc.fbp.common.helper.TmcAccountHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.formplugin.edit.AbstractTmcBillEdit;
import kd.tmc.ifm.enums.FeePayerEnum;
import kd.tmc.ifm.enums.PaymentChanEnum;
import kd.tmc.ifm.enums.SettleMentTypeEnum;
import org.apache.commons.lang.StringUtils;

public class PayAcceptFillAgentInfoEdit
extends AbstractTmcBillEdit
implements HyperLinkClickListener,
BeforeF7SelectListener {
    private static String SELECT_FIELDS = "id,billno,org,payeracctbank,currency,actpayamt,bizdate,agentpayeraccount,paymentchannel,settletype,usage";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
        BasedataEdit acctBank = (BasedataEdit)this.getView().getControl("payeracctbank");
        acctBank.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit settleType = (BasedataEdit)this.getView().getControl("settletype");
        settleType.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String key;
        switch (key = evt.getProperty().getName()) {
            case "payeracctbank": {
                this.payerAcctBankF7(evt);
                break;
            }
            case "settletype": {
                this.settleTypeF7(evt);
            }
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        List ids = (List)customParams.get("ids");
        if (EmptyUtil.isNoEmpty((Object)ids)) {
            DynamicObject[] payBills = TmcDataServiceHelper.load((String)"ifm_payacceptancebill", (String)SELECT_FIELDS, (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)ids)});
            this.batchCreateEntry(payBills);
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent event) {
        String fieldName = event.getFieldName();
        if ("operation".equals(fieldName)) {
            int entryCurrentRowIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
            this.getModel().deleteEntryRow("entryentity", entryCurrentRowIndex);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        if (!args.getOperationResult().isSuccess()) {
            return;
        }
        switch (operateKey) {
            case "save": {
                this.PayAccepTanceFillBySave();
                break;
            }
            case "submit": {
                this.PayAccepTanceFillBySubmit();
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String prop;
        switch (prop = e.getProperty().getName()) {
            case "payeracctbank": {
                ChangeData[] changeSet = e.getChangeSet();
                int entryIdx = changeSet[0].getRowIndex();
                DynamicObject payBank = (DynamicObject)this.getModel().getValue("payeracctbank", entryIdx);
                String chanNel = PaymentChanEnum.COUNTER.getValue();
                if (payBank != null) {
                    if (payBank.getBoolean("issetbankinterface")) {
                        chanNel = PaymentChanEnum.BEI.getValue();
                    } else if (payBank.getBoolean("isopenbank")) {
                        chanNel = PaymentChanEnum.ONLINEBANK.getValue();
                    }
                }
                this.getModel().setValue("paymentchannel", (Object)chanNel, entryIdx);
                if (entryIdx != 0) break;
                this.getModel().beginInit();
                int entryRowCount = this.getModel().getEntryRowCount("entryentity");
                for (int i = 1; i < entryRowCount; ++i) {
                    DynamicObject currPayBank = (DynamicObject)this.getModel().getValue("payeracctbank", i);
                    if (EmptyUtil.isNoEmpty((DynamicObject)currPayBank)) continue;
                    this.getModel().setValue("payeracctbank", (Object)payBank, i);
                    this.getModel().setValue("paymentchannel", (Object)chanNel, i);
                }
                this.getModel().endInit();
                this.getView().updateView("entryentity");
            }
        }
    }

    private String checkMsg(boolean isSubmit) {
        int entryRowCount = this.getModel().getEntryRowCount("entryentity");
        if (entryRowCount == 0) {
            return ResManager.loadKDString((String)"\u6682\u65e0\u6570\u636e\u3002", (String)"PayAcceptFillAgentInfoEdit_10", (String)"tmc-ifm-formplugin", (Object[])new Object[0]);
        }
        StringBuilder checkMsg = new StringBuilder();
        for (int i = 0; i < entryRowCount; ++i) {
            StringBuilder checkEntry = new StringBuilder();
            DynamicObject rowEntity = this.getModel().getEntryRowEntity("entryentity", i);
            DynamicObject payBank = rowEntity.getDynamicObject("payeracctbank");
            String paymentChannel = rowEntity.getString("paymentchannel");
            String usage = rowEntity.getString("usage");
            if (PaymentChanEnum.BEI.getValue().equals(paymentChannel) && EmptyUtil.isNoEmpty((DynamicObject)payBank) && !payBank.getBoolean("issetbankinterface") || PaymentChanEnum.ONLINEBANK.getValue().equals(paymentChannel) && EmptyUtil.isNoEmpty((DynamicObject)payBank) && !payBank.getBoolean("isopenbank")) {
                checkEntry.append(ResManager.loadKDString((String)"\u4ed8\u6b3e\u8d26\u53f7\u4e0e\u652f\u4ed8\u6e20\u9053\u4e0d\u5339\u914d\uff0c\u8bf7\u4fee\u6539", (String)"PayAcceptFillAgentInfoEdit_0", (String)"tmc-ifm-formplugin", (Object[])new Object[0])).append(",");
            }
            if (EmptyUtil.isEmpty((DynamicObject)payBank)) {
                checkEntry.append(ResManager.loadKDString((String)"\u4ed8\u6b3e\u8d26\u53f7\u5fc5\u586b", (String)"PayAcceptFillAgentInfoEdit_1", (String)"tmc-ifm-formplugin", (Object[])new Object[0])).append(",");
            } else {
                DynamicObjectCollection settlementTypes = payBank.getDynamicObjectCollection("settlementtype");
                if (EmptyUtil.isNoEmpty((DynamicObjectCollection)settlementTypes)) {
                    Set settleTypeIds = settlementTypes.stream().map(o -> o.getDynamicObject("fbasedataid").getPkValue()).collect(Collectors.toSet());
                    Map settleTypeMap = TmcDataServiceHelper.loadFromCache((String)"bd_settlementtype", (String)"id,name", (QFilter[])new QFilter[]{new QFilter("id", "in", settleTypeIds)});
                    Set settleTypeNames = settleTypeMap.values().stream().map(o -> o.getString("name")).collect(Collectors.toSet());
                    DynamicObject settleType = rowEntity.getDynamicObject("settletype");
                    if (settleType != null && !settleTypeIds.contains(settleType.getPkValue())) {
                        checkEntry.append(ResManager.loadKDString((String)"\u7ed3\u7b97\u65b9\u5f0f\u548c\u4ed8\u6b3e\u8d26\u53f7\u9650\u5b9a\u7ed3\u7b97\u65b9\u5f0f[%s]\u4e0d\u5339\u914d\uff0c\u8bf7\u4fee\u6539", (String)"PayAcceptFillAgentInfoEdit_2", (String)"tmc-ifm-formplugin", (Object[])new Object[]{StringUtils.join(settleTypeNames, (String)",")})).append(",");
                    }
                }
            }
            if (isSubmit && PaymentChanEnum.BEI.getValue().equals(paymentChannel) && EmptyUtil.isEmpty((String)usage)) {
                checkEntry.append(ResManager.loadKDString((String)"\u652f\u4ed8\u6e20\u9053\u4e3a\u94f6\u4f01\u4e92\u8054\uff0c\u8f6c\u8d26\u9644\u8a00\u5fc5\u586b", (String)"PayAcceptFillAgentInfoEdit_3", (String)"tmc-ifm-formplugin", (Object[])new Object[0])).append(",");
            }
            if (!EmptyUtil.isNoEmpty((String)checkEntry.toString())) continue;
            checkMsg.append(ResManager.loadKDString((String)"\u7b2c%s\u884c", (String)"PayAcceptFillAgentInfoEdit_4", (String)"tmc-ifm-formplugin", (Object[])new Object[]{i + 1})).append(",").append(checkEntry.substring(0, checkEntry.length())).append("\n");
        }
        return checkMsg.toString();
    }

    private void PayAccepTanceFillBySubmit() {
        String msg = this.checkMsg(true);
        if (EmptyUtil.isNoEmpty((String)msg)) {
            this.getView().showTipNotification(msg, Integer.valueOf(6000));
            return;
        }
        DynamicObjectCollection entrys = this.getModel().getEntryEntity("entryentity");
        Object[] payBillIds = entrys.stream().map(o -> o.get("billid")).toArray();
        DynamicObject[] payBills = TmcDataServiceHelper.load((Object[])payBillIds, (DynamicObjectType)TmcDataServiceHelper.newDynamicObject((String)"ifm_payacceptancebill").getDynamicObjectType());
        this.updeatePayBill(payBills, entrys);
        OperationResult result = TmcOperateServiceHelper.execOperateWithoutThrow((String)"submit", (String)"ifm_payacceptancebill", (DynamicObject[])payBills, (OperateOption)OperateOption.create());
        List successPkIds = result.getSuccessPkIds();
        if (entrys.size() == successPkIds.size()) {
            this.getView().returnDataToParent((Object)true);
            this.getView().close();
            return;
        }
        if (!result.isSuccess()) {
            this.deleteRowAfterOper(result.getSuccessPkIds());
            this.getView().showTipNotification(TmcOperateServiceHelper.decodeErrorMsg((OperationResult)result));
        }
    }

    private void deleteRowAfterOper(List<Object> successPkIds) {
        Set successIds = successPkIds.stream().map(Object::toString).collect(Collectors.toSet());
        DynamicObjectCollection entrys = this.getModel().getEntryEntity("entryentity");
        entrys.removeIf(o -> successIds.contains(o.getString("billid")));
        this.getView().updateView("entryentity");
    }

    private void PayAccepTanceFillBySave() {
        String msg = this.checkMsg(false);
        if (EmptyUtil.isNoEmpty((String)msg)) {
            this.getView().showTipNotification(msg, Integer.valueOf(6000));
            return;
        }
        DynamicObjectCollection entrys = this.getModel().getEntryEntity("entryentity");
        Object[] payBillIds = entrys.stream().map(o -> o.get("billid")).toArray();
        DynamicObject[] payBills = TmcDataServiceHelper.load((Object[])payBillIds, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"ifm_payacceptancebill"));
        this.updeatePayBill(payBills, entrys);
        OperationResult result = TmcOperateServiceHelper.execOperate((String)"save", (String)"ifm_payacceptancebill", (DynamicObject[])payBills, (OperateOption)OperateOption.create());
        if (result.isSuccess()) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"PayAcceptFillAgentInfoEdit_6", (String)"tmc-ifm-formplugin", (Object[])new Object[0]));
        }
    }

    private void updeatePayBill(DynamicObject[] payBills, DynamicObjectCollection entrys) {
        HashMap billMap = Arrays.stream(payBills).collect(HashMap::new, (k, v) -> k.put(v.getLong("id"), v), HashMap::putAll);
        for (DynamicObject entry : entrys) {
            Boolean isCrossPay;
            DynamicObject bill = (DynamicObject)billMap.get(entry.getLong("billid"));
            DynamicObject payerBank = entry.getDynamicObject("payeracctbank");
            bill.set("bizdate", (Object)entry.getDate("bizdate"));
            bill.set("agentpayeraccount", (Object)entry.getDynamicObject("payeracctbank"));
            bill.set("paymentchannel", (Object)entry.getString("paymentchannel"));
            bill.set("settletype", (Object)entry.getDynamicObject("settletype"));
            bill.set("usage", (Object)entry.getString("usage"));
            if (EmptyUtil.isNoEmpty((DynamicObject)payerBank)) {
                DynamicObject bank = payerBank.getDynamicObject("bank");
                bill.set("agentfinorg", (Object)payerBank.getDynamicObject("bank"));
                if (bank != null) {
                    DynamicObject bankCate = TmcDataServiceHelper.loadSingleFromCache((Object)bank.getPkValue(), (String)"bd_finorginfo", (String)"id,bank_cate");
                    bill.set("agentfinorgcat", (Object)bankCate.getDynamicObject("bank_cate"));
                }
            }
            if (!(isCrossPay = Boolean.valueOf(bill.getBoolean("iscrosspay"))).booleanValue()) continue;
            bill.set("feecurrency", (Object)bill.getDynamicObject("currency"));
            boolean isFeeRec = FeePayerEnum.isRec((String)bill.getString("feepayer"));
            if (isFeeRec) continue;
            bill.set("feeactbank", (Object)entry.getDynamicObject("payeracctbank"));
        }
    }

    private void settleTypeF7(BeforeF7SelectEvent evt) {
        DynamicObject settleType;
        DynamicObjectCollection settlementTypes;
        int entryIdx = this.getModel().getEntryCurrentRowIndex("entryentity");
        DynamicObject payAcct = (DynamicObject)this.getModel().getValue("payeracctbank", entryIdx);
        ListShowParameter showPara = (ListShowParameter)evt.getFormShowParameter();
        List qFilters = showPara.getListFilterParameter().getQFilters();
        if (EmptyUtil.isNoEmpty((DynamicObject)payAcct) && EmptyUtil.isNoEmpty((DynamicObjectCollection)(settlementTypes = payAcct.getDynamicObjectCollection("settlementtype")))) {
            QFilter filter = new QFilter("id", "in", settlementTypes.stream().map(o -> o.getDynamicObject("fbasedataid").getPkValue()).collect(Collectors.toSet()));
            qFilters.add(filter);
        }
        if (EmptyUtil.isNoEmpty((DynamicObject)(settleType = (DynamicObject)this.getModel().getValue("settletype", entryIdx)))) {
            String type = settleType.getString("settlementtype");
            boolean isCdm = SettleMentTypeEnum.isBankOrBusiness((String)type) || SettleMentTypeEnum.isCheck((String)type) || SettleMentTypeEnum.isPromissory((String)type);
            qFilters.add(new QFilter("settlementtype", isCdm ? "in" : "not in", (Object)new String[]{"1", "2", "5", "6"}));
        }
        showPara.setMultiSelect(false);
    }

    private void payerAcctBankF7(BeforeF7SelectEvent evt) {
        int entryIdx = this.getModel().getEntryCurrentRowIndex("entryentity");
        DynamicObject innerAcct = (DynamicObject)this.getModel().getValue("inneracct", entryIdx);
        DynamicObject currency = (DynamicObject)this.getModel().getValue("currency", entryIdx);
        if (!EmptyUtil.isAnyoneEmpty((Object[])new Object[]{innerAcct, currency})) {
            DynamicObject bank = innerAcct.getDynamicObject("bank");
            DynamicObject finOrgInfo = TmcDataServiceHelper.loadSingleFromCache((Object)bank.getPkValue(), (String)"bd_finorginfo", (String)"id,org");
            DynamicObject org = finOrgInfo.getDynamicObject("org");
            if (EmptyUtil.isEmpty((DynamicObject)org)) {
                evt.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u7ef4\u62a4\u7ed3\u7b97\u4e2d\u5fc3[%s]\u5bf9\u5e94\u7684\u4e1a\u52a1\u5355\u5143\u3002", (String)"PayAcceptFillAgentInfoEdit_7", (String)"tmc-ifm-formplugin", (Object[])new Object[]{finOrgInfo.getString("name")}));
                return;
            }
            QFilter filter = TmcAccountHelper.getAccountBankFilterByOrg((Long)org.getLong("id"));
            filter = filter.and("currency.fbasedataid.id", "=", currency.getPkValue()).and("acctstatus", "=", (Object)BankAcctStatusEnum.NORMAL.getValue()).and("bank.bank_cate.number", "!=", (Object)"BC-9999").and("acctclassify", "!=", (Object)"I").and("enable", "=", (Object)BaseEnableEnum.ENABLE.getValue());
            ListShowParameter showPara = (ListShowParameter)evt.getFormShowParameter();
            showPara.setMultiSelect(false);
            showPara.getListFilterParameter().setFilter(filter);
        } else {
            evt.setCancel(true);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5185\u90e8\u8d26\u6237\u6216\u5e01\u79cd\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"PayAcceptFillAgentInfoEdit_8", (String)"tmc-ifm-formplugin", (Object[])new Object[0]));
        }
    }

    private void batchCreateEntry(DynamicObject[] payBills) {
        if (EmptyUtil.isEmpty((Object[])payBills)) {
            return;
        }
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.beginInit();
        TableValueSetter vs = new TableValueSetter(new String[0]);
        vs.addField("billid", new Object[0]);
        vs.addField("billno", new Object[0]);
        vs.addField("org", new Object[0]);
        vs.addField("inneracct", new Object[0]);
        vs.addField("currency", new Object[0]);
        vs.addField("amount", new Object[0]);
        vs.addField("bizdate", new Object[0]);
        vs.addField("payeracctbank", new Object[0]);
        vs.addField("paymentchannel", new Object[0]);
        vs.addField("settletype", new Object[0]);
        vs.addField("usage", new Object[0]);
        vs.addField("operation", new Object[0]);
        for (DynamicObject payBill : payBills) {
            Object[] rowData = new Object[]{payBill.getLong("id"), payBill.getString("billno"), this.getDynamicObjId(payBill, "org"), this.getDynamicObjId(payBill, "payeracctbank"), this.getDynamicObjId(payBill, "currency"), payBill.getBigDecimal("actpayamt"), payBill.getDate("bizdate"), this.getDynamicObjId(payBill, "agentpayeraccount"), payBill.getString("paymentchannel"), this.getDynamicObjId(payBill, "settletype"), payBill.getString("usage"), ResManager.loadKDString((String)"\u5220\u9664", (String)"PayAcceptFillAgentInfoEdit_9", (String)"tmc-ifm-formplugin", (Object[])new Object[0])};
            vs.addRow(rowData);
        }
        model.batchCreateNewEntryRow("entryentity", vs);
        model.endInit();
        HashMap<String, Boolean> map = new HashMap<String, Boolean>(1);
        map.put("heightLimit", false);
        this.getView().updateControlMetadata("entryentity", map);
        this.getView().updateView("entryentity");
    }

    private Object getDynamicObjId(DynamicObject payBill, String prop) {
        DynamicObject value = payBill.getDynamicObject(prop);
        return EmptyUtil.isNoEmpty((DynamicObject)value) ? value.getPkValue() : Long.valueOf(0L);
    }
}

