/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.formplugin.setting;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.field.ComboItem;
import kd.bos.orm.util.CollectionUtils;
import kd.tmc.fbp.formplugin.list.AbstractTmcBillBaseList;
import kd.tmc.ifm.helper.IfmSettleCenterHelper;

public class SettlementSetFilterPlugin
extends AbstractTmcBillBaseList {
    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        for (FilterColumn filterColumn : args.getFilterContainerInitEvent().getCommonFilterColumns()) {
            List settleCenterBanks;
            CommonFilterColumn commonFilterColumn = (CommonFilterColumn)filterColumn;
            String fieldName = commonFilterColumn.getFieldName();
            if (fieldName.startsWith("settlecenter.") && (settleCenterBanks = IfmSettleCenterHelper.getSettleCenterBanks()) != null) {
                List<DynamicObject> settleCenterList = settleCenterBanks.stream().sorted(Comparator.comparing(e -> e.getLong("id"))).collect(Collectors.toList());
                commonFilterColumn.setComboItems(this.initSCItemsList(settleCenterList));
            }
            if (!fieldName.startsWith("usestatus")) continue;
            ArrayList<ComboItem> sCItems = new ArrayList<ComboItem>(10);
            for (int i = 0; i < 2; ++i) {
                ComboItem item = new ComboItem();
                if (i == 0) {
                    item.setCaption(new LocaleString(ResManager.loadKDString((String)"\u505c\u7528", (String)"SettlementSetFilterPlugin_0", (String)"tmc-ifm-formplugin", (Object[])new Object[0])));
                } else {
                    item.setCaption(new LocaleString(ResManager.loadKDString((String)"\u542f\u7528", (String)"SettlementSetFilterPlugin_1", (String)"tmc-ifm-formplugin", (Object[])new Object[0])));
                }
                item.setValue(i + "");
                sCItems.add(item);
            }
            commonFilterColumn.setComboItems(sCItems);
        }
    }

    private List<ComboItem> initSCItemsList(List<DynamicObject> settleCenters) {
        ArrayList<ComboItem> sCItems = new ArrayList<ComboItem>(10);
        if (!CollectionUtils.isEmpty(settleCenters)) {
            for (DynamicObject settleCenter : settleCenters) {
                ComboItem item = new ComboItem();
                item.setCaption(new LocaleString(settleCenter.getString("name")));
                item.setValue(settleCenter.getString("id"));
                sCItems.add(item);
            }
        }
        return sCItems;
    }
}

