/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.formplugin.settlement;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.plugin.AbstractPrintServicePlugin;
import kd.bos.entity.plugin.args.CustomPrintDataEntitiesArgs;
import kd.bos.form.IFormView;
import kd.bos.list.IListView;
import kd.bos.mvc.SessionManager;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class ReceiptPrintPlugin
extends AbstractPrintServicePlugin {
    public void customPrintDataEntities(CustomPrintDataEntitiesArgs e) {
        super.customPrintDataEntities(e);
        String pageId = e.getPageId();
        List dynS = e.getDataEntities();
        String datasource = e.getDataSourceName();
        if (datasource.startsWith("ifm_transdetail")) {
            this.initPrintTransDetailData(dynS, pageId);
            e.setDataEntities(dynS);
        } else if (datasource.startsWith("ifm_receiptdetail")) {
            this.initReceiptData(dynS, pageId);
            e.setDataEntities(dynS);
        }
    }

    private void initReceiptData(List<DynamicObject> dynS, String pageId) {
        IFormView view = SessionManager.getCurrent().getView(pageId);
        String formId = view.getFormShowParameter().getFormId();
        Object transId = null;
        if ("bos_list".equals(formId)) {
            IListView listView = (IListView)view;
            ListSelectedRowCollection selectedRows = listView.getSelectedRows();
            ListSelectedRow listSelectedRow = selectedRows.get(0);
            transId = listSelectedRow.getPrimaryKeyValue();
        } else {
            DynamicObject dynFormObj = view.getModel().getDataEntity(true);
            transId = dynFormObj.get("transid");
        }
        DynamicObject transDetailObject = BusinessDataServiceHelper.loadSingle((Object)transId, (String)"ifm_transdetail");
        DynamicObjectType dsDataType = new DynamicObjectType();
        dsDataType.registerProperty("tradeno", String.class, (Object)"", false);
        dsDataType.registerProperty("title", String.class, (Object)"", false);
        dsDataType.registerProperty("paybankname", String.class, (Object)"", false);
        dsDataType.registerProperty("payaccountname", String.class, (Object)"", false);
        dsDataType.registerProperty("payaccountnumber", String.class, null, false);
        dsDataType.registerProperty("incomebankname", String.class, null, false);
        dsDataType.registerProperty("incomeaccountname", String.class, null, false);
        dsDataType.registerProperty("incomeaccountnumber", String.class, null, false);
        dsDataType.registerProperty("tradeamount", BigDecimal.class, null, false);
        DynamicObject newDynamic = new DynamicObject(dsDataType);
        newDynamic.set("title", (Object)String.format(ResManager.loadKDString((String)"%1$s\u7535\u5b50\u56de\u5355", (String)"ReceiptPrintPlugin_0", (String)"tmc-ifm-formplugin", (Object[])new Object[0]), transDetailObject.getString("bank.name")));
        String payBankName = transDetailObject.getString("bank.name");
        String payAccountName = transDetailObject.getString("accountbank.name");
        String payAccountNumber = transDetailObject.getString("accountbank.bankaccountnumber");
        String incomeBankName = transDetailObject.getString("oppbank");
        String incomeAccountName = transDetailObject.getString("oppunit");
        String incomeAccountNumber = transDetailObject.getString("oppbanknumber");
        BigDecimal tradeAmount = transDetailObject.getBigDecimal("debitamount");
        BigDecimal creditAmount = transDetailObject.getBigDecimal("creditamount");
        if (creditAmount.compareTo(new BigDecimal(0)) != 0) {
            payBankName = incomeBankName;
            payAccountName = incomeAccountName;
            payAccountNumber = incomeAccountNumber;
            incomeBankName = transDetailObject.getString("bank.name");
            incomeAccountName = transDetailObject.getString("accountbank.name");
            incomeAccountNumber = transDetailObject.getString("accountbank.bankaccountnumber");
            tradeAmount = creditAmount;
        }
        newDynamic.set("tradeno", (Object)transDetailObject.getString("billno"));
        newDynamic.set("paybankname", (Object)payBankName);
        newDynamic.set("payaccountname", (Object)payAccountName);
        newDynamic.set("payaccountnumber", (Object)payAccountNumber);
        newDynamic.set("incomebankname", (Object)incomeBankName);
        newDynamic.set("incomeaccountname", (Object)incomeAccountName);
        newDynamic.set("incomeaccountnumber", (Object)incomeAccountNumber);
        newDynamic.set("tradeamount", (Object)tradeAmount.setScale(2, RoundingMode.HALF_UP));
        dynS.add(newDynamic);
    }

    private void initPrintTransDetailData(List<DynamicObject> dynS, String pageId) {
        IFormView view = SessionManager.getCurrent().getView(pageId);
        String formId = view.getFormShowParameter().getFormId();
        if ("bos_list".equals(formId)) {
            return;
        }
        DynamicObject dynFormObj = view.getModel().getDataEntity(true);
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)dynFormObj.get("transid"), (String)"ifm_transdetail");
        dynS.add(dynamicObject);
    }
}

