/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.formplugin.settlement;

import java.util.Collections;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.list.BillList;
import kd.bos.report.ReportShowParameter;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.formplugin.list.AbstractTmcBillBaseList;
import kd.tmc.ifm.helper.ElecReceiptViewHelper;

public class TransDetailListPlugin
extends AbstractTmcBillBaseList {
    private static final String OP_KEY_SHOW_RECEIPT = "showreceipt";
    private static final String OP_KEY_SHOW_STATEMENT = "showstatement";

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String key;
        super.afterDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        switch (key = op.getOperateKey()) {
            case "showreceipt": {
                this.openReceipt();
                break;
            }
            case "showstatement": {
                this.openStatementWindow();
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        String key = op.getOperateKey();
        if (OP_KEY_SHOW_STATEMENT.equals(key)) {
            this.checkSelectedList(args, ResManager.loadKDString((String)"\u53ea\u80fd\u9009\u62e9\u4e00\u6761\u8bb0\u5f55\u67e5\u770b\u5bf9\u8d26\u5355\u3002", (String)"TransDetailList_2", (String)"tmc-ifm-formplugin", (Object[])new Object[0]));
        }
    }

    private void checkSelectedList(BeforeDoOperationEventArgs args, String tipMsg) {
        List selectedIdList = this.getSelectedIdList();
        if (selectedIdList.size() == 0) {
            args.setCancel(true);
            return;
        }
        if (selectedIdList.size() > 1) {
            this.getView().showTipNotification(tipMsg);
            args.setCancel(true);
            return;
        }
    }

    private void openStatementWindow() {
        List selectedIdList = this.getSelectedIdList();
        Long selectedId = (Long)selectedIdList.get(0);
        ReportShowParameter showParameter = new ReportShowParameter();
        showParameter.setFormId("ifm_statementrpt");
        showParameter.setCustomParam("selectedId", (Object)selectedId);
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private void openReceipt() {
        BillList billList = (BillList)this.getControl("billlistap");
        ListSelectedRow currRow = billList.getCurrentSelectedRowInfo();
        DynamicObject transDetail = TmcDataServiceHelper.loadSingle((Object)currRow.getPrimaryKeyValue(), (String)"ifm_transdetail", (String)"id,receiptno");
        ElecReceiptViewHelper.openElecView(Collections.singletonList(transDetail.getString("receiptno")), (IFormView)this.getView());
    }
}

