/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.lc.report.data;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.report.data.AbstractTmcTreeReportDataPlugin;
import kd.tmc.lc.report.helper.DetailReportHelper;
import kd.tmc.lc.report.helper.ReportHelper;

public abstract class AbstractDetailReportDataListPlugin
extends AbstractTmcTreeReportDataPlugin {
    private static final String SPLIT_STR = ",";
    private static final String LETT_TEXT = ",currency.number as currencyNumber, currency.name as currencyName";
    private static final String LETT_FIELD = ",orgtext,currencyNumber,currencyName,entrys.contractnum as contractnums";

    public DataSet queryDataSet(ReportQueryParam queryParam) {
        Map paramMap = this.transQueryParam(queryParam);
        this.getQueryParam().getCustomParam().put("filter_statdim", paramMap.get("filter_statdim"));
        paramMap.put("filter_org", this.getQueryOrgIds(queryParam));
        DataSet details = this.getLetterCreditData(paramMap);
        String statdim = (String)paramMap.get("filter_statdim");
        return details.orderBy(statdim.split(SPLIT_STR));
    }

    private DataSet getLetterCreditData(Map<String, Object> paramMap) {
        QFilter filter = this.getFilter(paramMap);
        String firstColumnText = ReportHelper.getFirstColumnText(paramMap);
        String selectField = DetailReportHelper.getSelectFields(paramMap, this.getBillFields());
        DataSet letterCredits = QueryServiceHelper.queryDataSet((String)"DetailReportDataListPluginCredit", (String)this.getBillEntryName(), (String)(selectField + LETT_TEXT + firstColumnText), (QFilter[])new QFilter[]{filter}, null);
        DataSet contractNumSet = QueryServiceHelper.queryDataSet((String)"DetailReportDataListPluginCreditEntry", (String)this.getBillEntryName(), (String)"id,entrys.contractnum", (QFilter[])new QFilter[]{filter}, null).groupBy(new String[]{"id"}).groupConcat("entrys.contractnum").finish();
        DataSet details = letterCredits.leftJoin(contractNumSet).on("id", "id").select((selectField + LETT_FIELD).split(SPLIT_STR)).finish().updateField("contractnums", "case when contractnums='null' then '' else contractnums end");
        selectField = DetailReportHelper.getSelectFields(paramMap, String.join((CharSequence)SPLIT_STR, this.getBillCoverFields()));
        details = DetailReportHelper.getLetterCreditByRateUnit(details.copy(), this.getArrBillEntryName(), paramMap, selectField.split(SPLIT_STR));
        return details;
    }

    private static String[] getStatDimByTotal(Map<String, Object> paramMap) {
        String statDim = (String)paramMap.get("filter_statdim");
        DynamicObject toCurrency = (DynamicObject)paramMap.get("filter_statcurrency");
        if (EmptyUtil.isNoEmpty((DynamicObject)toCurrency)) {
            statDim = statDim + SPLIT_STR + "currency";
        }
        return statDim.split(SPLIT_STR);
    }

    protected abstract String getBillFields();

    protected abstract String[] getBillCoverFields();

    protected abstract String getBillEntryName();

    protected abstract String getArrBillEntryName();

    protected abstract QFilter getFilter(Map<String, Object> var1);

    protected boolean isNeedOrgTree() {
        return true;
    }

    protected boolean isOrgNeedAddRootNode() {
        return true;
    }

    protected String getReportField(String field) {
        return "rate" + field;
    }

    protected List<String> orinalAmountField() {
        ArrayList<String> amountFields = new ArrayList<String>(10);
        amountFields.add("amount");
        amountFields.add("arramount");
        amountFields.add("notarramount");
        amountFields.add("letnotpayamount");
        amountFields.add("arrpayamount");
        amountFields.add("arrnotpayamount");
        return amountFields;
    }

    public List<String> sumAmountFields() {
        ArrayList<String> sumFields = new ArrayList<String>(2);
        sumFields.add("rateamount");
        sumFields.add("arrnum");
        return sumFields;
    }

    public String sumNameField() {
        return (String)this.getBizAndReportOrgProp().getRight();
    }

    public List<String> groupFields() {
        return Arrays.stream(AbstractDetailReportDataListPlugin.getStatDimByTotal(Collections.singletonMap("filter_statdim", this.getQueryParam().getCustomParam().get("filter_statdim")))).distinct().collect(Collectors.toList());
    }
}

