/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.lc.report.data;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.report.data.AbstractTmcTreeReportDataPlugin;
import kd.tmc.lc.report.helper.ReportHelper;

public abstract class AbstractSumBaseReportDataListPlugin
extends AbstractTmcTreeReportDataPlugin {
    private static final String[] CREDIT_SELECT_FIELD = new String[]{"id", "orgtext", "tarcurrency", "rate", "totalamt", "totalnumber", "0 as sumlevel"};
    private static final String[] ARRIVAL_SELECT_FIELD = new String[]{"confirmtotalamt", "donetotalamt", "todototalamt"};

    public DataSet queryDataSet(ReportQueryParam queryParam) {
        Map paramMap = this.transQueryParam(queryParam);
        this.getQueryParam().getCustomParam().put("filter_statdim", paramMap.get("filter_statdim"));
        paramMap.put("filter_org", this.getQueryOrgIds(queryParam));
        QFilter filter = this.getFilter(paramMap);
        DataSet creditDateSet = this.getLetterCreditDateSet(paramMap, filter);
        return this.getLetterCreditByRateUnit(creditDateSet, paramMap);
    }

    protected QFilter getFilter(Map<String, Object> paramMap) {
        QFilter filter = new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue());
        ArrayList orgIds = (ArrayList)paramMap.get("filter_org");
        filter.and("org", "in", (Object)orgIds);
        DynamicObjectCollection creditTypes = (DynamicObjectCollection)paramMap.get("filter_credittypes");
        if (creditTypes != null && !creditTypes.isEmpty()) {
            filter.and("credittype", "in", creditTypes.stream().map(DataEntityBase::getPkValue).collect(Collectors.toList()));
        }
        this.buildDateRangesFilter(paramMap, filter);
        DynamicObject bank = (DynamicObject)paramMap.get("filter_bank");
        ReportHelper.buildDynamicObjectFilter(filter, bank, "bank");
        DynamicObject currency = (DynamicObject)paramMap.get("filter_bizcurrency");
        ReportHelper.buildDynamicObjectFilter(filter, currency, "currency");
        return filter;
    }

    private DataSet getLetterCreditDateSet(Map<String, Object> paramMap, QFilter filter) {
        String selectField = String.join((CharSequence)",", this.getSelectFields(paramMap));
        String firstColumnText = ReportHelper.getFirstColumnText(paramMap);
        return QueryServiceHelper.queryDataSet((String)"SumBaseReportDataListPlugin_0", (String)this.getQueryReportEntity(), (String)(selectField + firstColumnText + ",amount as totalamt,1 as totalnumber,id,currency.number as currencyNumber,currency.name as currencyName"), (QFilter[])filter.toArray(), null);
    }

    private List<String> getSelectFields(Map<String, Object> paramMap) {
        Set fields = (Set)paramMap.get("fields");
        HashSet<String> noSelectFields = new HashSet<String>(16);
        noSelectFields.add("orgtext");
        noSelectFields.add("statcurrency");
        noSelectFields.add("tarcurrency");
        noSelectFields.add("rate");
        noSelectFields.add("totalnumber");
        noSelectFields.add("totalamt");
        noSelectFields.add("totalamt_cal");
        noSelectFields.add("confirmtotalamt");
        noSelectFields.add("confirmtotalamt_cal");
        noSelectFields.add("donetotalamt");
        noSelectFields.add("donetotalamt_cal");
        noSelectFields.add("todototalamt");
        noSelectFields.add("todototalamt_cal");
        noSelectFields.add("sumlevel");
        ArrayList<String> selectField = new ArrayList<String>(16);
        for (String field : fields) {
            if (noSelectFields.contains(field)) continue;
            selectField.add(field);
        }
        return selectField;
    }

    private DataSet getLetterCreditByRateUnit(DataSet creditDateSet, Map<String, Object> paramMap) {
        long tarCurrencyId = ((DynamicObject)paramMap.get("filter_statcurrency")).getLong("id");
        String[] addFields = this.getSelectFields(paramMap).toArray(new String[0]);
        String[] newArray = this.concat(addFields, CREDIT_SELECT_FIELD);
        DataSet arrivalSet = this.getArrivalDateSet(creditDateSet, paramMap);
        creditDateSet = creditDateSet.addFields(new String[]{tarCurrencyId + "L", "1.0"}, new String[]{"tarcurrency", "rate"});
        DataSet select = creditDateSet.leftJoin(arrivalSet).on("id", "lettercredit").select(newArray, ARRIVAL_SELECT_FIELD).finish();
        select = select.groupBy(AbstractSumBaseReportDataListPlugin.getStatDim(paramMap)).sum("totalnumber").sum("totalamt").sum("confirmtotalamt").sum("donetotalamt").sum("todototalamt").finish();
        return select.orderBy(AbstractSumBaseReportDataListPlugin.getStatDimByTotal(paramMap));
    }

    private static String[] getStatDim(Map<String, Object> paramMap) {
        String statDim = (String)paramMap.get("filter_statdim");
        Set<String> otherStatdim = Arrays.stream(statDim.split(",")).filter(s -> !s.equals("org") && !s.equals("bank") && !s.equals("currency")).collect(Collectors.toSet());
        otherStatdim.add("org");
        otherStatdim.add("orgtext");
        otherStatdim.add("bank");
        otherStatdim.add("currency");
        String[] statDimArr = new String[otherStatdim.size()];
        return otherStatdim.toArray(statDimArr);
    }

    private static String[] getStatDimByTotal(Map<String, Object> paramMap) {
        String statDim = (String)paramMap.get("filter_statdim");
        DynamicObject toCurrency = (DynamicObject)paramMap.get("filter_statcurrency");
        if (EmptyUtil.isNoEmpty((DynamicObject)toCurrency)) {
            statDim = statDim + "," + "currency";
        }
        return statDim.split(",");
    }

    private DataSet getArrivalDateSet(DataSet creditDateSet, Map<String, Object> paramMap) {
        List<Long> dataSetIds = AbstractSumBaseReportDataListPlugin.getDataSetIds(creditDateSet);
        QFilter qFilter = new QFilter("lettercredit", "in", dataSetIds);
        this.setRelatedQueryFilter(qFilter);
        Date queryEndDate = (Date)paramMap.get("filter_queryenddate");
        if (queryEndDate != null) {
            queryEndDate = DateUtils.getDataFormat((Date)queryEndDate, (boolean)false);
            qFilter.and(new QFilter("arrivaldate", "<=", (Object)queryEndDate));
        }
        DataSet arrivalDataset = QueryServiceHelper.queryDataSet((String)"SumBaseReportDataListPlugin_1", (String)this.getRelatedEntity(), (String)"id,lettercredit,doneamount as donetotalamt,arrivalamount as confirmtotalamt,arrivalamount-doneamount as todototalamt", (QFilter[])qFilter.toArray(), null);
        DataSet resultArrivalDataset = arrivalDataset.copy().groupBy(new String[]{"lettercredit"}).sum("confirmtotalamt").sum("donetotalamt").sum("todototalamt").finish();
        if (queryEndDate != null) {
            List<Long> arrivalDatasetId = AbstractSumBaseReportDataListPlugin.getDataSetIds(arrivalDataset);
            DataSet arrPayAmountSet = QueryServiceHelper.queryDataSet((String)"DetailReportDataListPluginArr", (String)"lc_arrival", (String)"id,lettercredit,arrivalamount,entrys.arrpayamount", (QFilter[])new QFilter[]{new QFilter("id", "in", arrivalDatasetId), new QFilter("entrys.realpaydate", "<=", (Object)queryEndDate)}, null).groupBy(new String[]{"lettercredit"}).sum("entrys.arrpayamount", "arrpayamount").finish();
            resultArrivalDataset = resultArrivalDataset.leftJoin(arrPayAmountSet).on("lettercredit", "lettercredit").select(resultArrivalDataset.getRowMeta().getFieldNames(), new String[]{"arrpayamount"}).finish().updateField("donetotalamt", "arrpayamount");
        }
        return resultArrivalDataset;
    }

    private static List<Long> getDataSetIds(DataSet dataSet) {
        DataSet fsDS = dataSet.copy();
        ArrayList<Long> ids = new ArrayList<Long>(16);
        for (Row row : fsDS) {
            ids.add(row.getLong("id"));
        }
        return ids;
    }

    private String[] concat(String[] a, String[] b) {
        String[] newArry = new String[a.length + b.length];
        System.arraycopy(a, 0, newArry, 0, a.length);
        System.arraycopy(b, 0, newArry, a.length, b.length);
        return newArry;
    }

    protected abstract String getQueryReportEntity();

    protected abstract String getRelatedEntity();

    protected abstract void setRelatedQueryFilter(QFilter var1);

    protected abstract void buildDateRangesFilter(Map<String, Object> var1, QFilter var2);

    protected boolean isNeedOrgTree() {
        return true;
    }

    protected boolean isOrgNeedAddRootNode() {
        return false;
    }

    public List<String> sumAmountFields() {
        ArrayList<String> sumFields = new ArrayList<String>(10);
        sumFields.add("totalnumber");
        sumFields.add("totalamt_cal");
        sumFields.add("confirmtotalamt_cal");
        sumFields.add("donetotalamt_cal");
        sumFields.add("todototalamt_cal");
        return sumFields;
    }

    protected List<String> orinalAmountField() {
        ArrayList<String> amountFields = new ArrayList<String>(10);
        amountFields.add("totalamt");
        amountFields.add("confirmtotalamt");
        amountFields.add("donetotalamt");
        amountFields.add("todototalamt");
        return amountFields;
    }

    public List<String> groupFields() {
        return Arrays.stream(AbstractSumBaseReportDataListPlugin.getStatDimByTotal(Collections.singletonMap("filter_statdim", this.getQueryParam().getCustomParam().get("filter_statdim")))).distinct().collect(Collectors.toList());
    }

    protected String getReportField(String field) {
        return field + "_cal";
    }

    public String sumNameField() {
        return (String)this.getBizAndReportOrgProp().getRight();
    }
}

