/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.lc.report.data;

import java.util.Date;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbp.common.enums.BeBillStatusEnum;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.lc.report.data.AbstractDetailReportDataListPlugin;
import kd.tmc.lc.report.helper.DetailReportHelper;
import kd.tmc.lc.report.helper.ReportHelper;

public class DetailLetterReportDataListPlugin
extends AbstractDetailReportDataListPlugin {
    @Override
    protected String getBillFields() {
        return "id,org,creditno,bizdate,bank,isnationalcard,isforward,forwarddays,currency,amount,noticebank,benefitertype,amountscaleupper,amountscalelow,benefiterother,validdate,lastdate,bizcontactor,credittype,remark";
    }

    @Override
    protected String[] getBillCoverFields() {
        return new String[]{"id", "org", "creditno", "orgtext", "bizdate", "bank", "isnationalcard", "isforward", "forwarddays", "currency", "amount", "noticebank", "benefitertype", "amountscaleupper", "amountscalelow", "benefiterother", "validdate", "lastdate", "bizcontactor", "credittype", "remark", "contractnums"};
    }

    @Override
    protected String getBillEntryName() {
        return "lc_lettercredit";
    }

    @Override
    protected String getArrBillEntryName() {
        return "lc_arrival";
    }

    @Override
    protected QFilter getFilter(Map<String, Object> paramMap) {
        QFilter filter = DetailReportHelper.getFilter(paramMap);
        QFilter offFiliter = new QFilter("tradechannel", "!=", (Object)"online");
        QFilter onlineFiliter = new QFilter("tradechannel", "=", (Object)"online");
        onlineFiliter = onlineFiliter.and(new QFilter("bebankstatus", "=", (Object)BeBillStatusEnum.TS.getValue()));
        QFilter tradeChannelFilter = offFiliter.or(onlineFiliter);
        filter.and(tradeChannelFilter);
        Date queryEndDate = (Date)paramMap.get("filter_queryenddate");
        queryEndDate = DateUtils.getDataFormat((Date)queryEndDate, (boolean)false);
        filter.and("bizdate", "<=", (Object)queryEndDate);
        paramMap.put("reportType", "letterReport");
        this.addExtFilter(paramMap, filter);
        return filter;
    }

    protected QFilter addExtFilter(Map<String, Object> paramMap, QFilter filter) {
        for (Map.Entry<String, Object> entry : paramMap.entrySet()) {
            if (!entry.getKey().endsWith("_exflt")) continue;
            String key = entry.getKey();
            String fieldName = key.substring(0, key.lastIndexOf("_exflt"));
            Object value = entry.getValue();
            if (EmptyUtil.isEmpty((Object)value)) continue;
            if (value instanceof DynamicObject) {
                DynamicObject dynamicObject = (DynamicObject)value;
                ReportHelper.buildDynamicObjectFilter(filter, dynamicObject, fieldName);
                continue;
            }
            if (value instanceof DynamicObjectCollection) {
                DynamicObjectCollection doc = (DynamicObjectCollection)value;
                filter.and(fieldName, "in", doc.stream().map(DataEntityBase::getPkValue).collect(Collectors.toList()));
                continue;
            }
            if (!(value instanceof String)) continue;
            ReportHelper.buildStrFilter(filter, (String)value, fieldName);
        }
        return filter;
    }
}

