/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.lc.report.form;

import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.IReportListModel;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.report.IReportView;
import kd.bos.report.ReportList;
import kd.bos.report.ReportShowParameter;
import kd.bos.report.events.CreateColumnEvent;
import kd.bos.report.filter.ReportFilter;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.report.form.AbstractTmcOrgViewRptFormPlugin;
import kd.tmc.lc.report.helper.ReportHelper;

public class SumBaseReportFormPlugin
extends AbstractTmcOrgViewRptFormPlugin
implements HyperLinkClickListener,
BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        ReportList reportList = (ReportList)this.getControl("reportlistap");
        reportList.addHyperClickListener((HyperLinkClickListener)this);
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    public void beforeQuery(ReportQueryParam queryParam) {
        String statdim = (String)this.getModel().getValue("filter_statdim");
        queryParam.getFilter().addFilterItem("filter_statdim", (Object)statdim);
        this.getModel().setValue("filter_isshowsubtotal", (Object)true);
        queryParam.getFilter().addFilterItem("fields", this.getAllFields());
        super.beforeQuery(queryParam);
    }

    protected String getFilterOrgField() {
        return "filter_org";
    }

    protected String getFilterOrgViewField() {
        return "filter_orgview";
    }

    public void afterCreateColumn(CreateColumnEvent event) {
        super.afterCreateColumn(event);
        Map<String, LocaleString> columnFieldMap = ReportHelper.getColumnField(event);
        String groupColum = ReportHelper.getGroupColums((String)this.getModel().getValue("filter_statdim"));
        DynamicObject toCurrency = (DynamicObject)this.getModel().getValue("filter_statcurrency");
        List columns = event.getColumns();
        columns.removeIf(columm -> {
            ReportColumn reportColumn = (ReportColumn)columm;
            if ("orgtext".equals(reportColumn.getFieldKey()) && !"org".equals(groupColum)) {
                reportColumn.setCaption((LocaleString)columnFieldMap.get(groupColum));
            }
            return EmptyUtil.isEmpty((DynamicObject)toCurrency) && reportColumn.getFieldKey().contains("cal") || reportColumn.getFieldKey().equals(groupColum);
        });
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key;
        switch (key = e.getProperty().getName()) {
            case "filter_bizdate_startdate": {
                ReportHelper.controlFilterDate((IFormView)this.getView(), "filter_bizdate_startdate");
                break;
            }
            case "filter_bizdate_enddate": {
                ReportHelper.controlFilterDate((IFormView)this.getView(), "filter_bizdate_enddate");
                break;
            }
            case "filter_redate_startdate": {
                ReportHelper.controlFilterDate((IFormView)this.getView(), "filter_redate_startdate");
                break;
            }
            case "filter_redate_enddate": {
                ReportHelper.controlFilterDate((IFormView)this.getView(), "filter_redate_enddate");
                break;
            }
            case "filter_statdim": {
                ReportFilter rptFilter = (ReportFilter)this.getControl("reportfilterap");
                try {
                    rptFilter.search();
                }
                catch (KDBizException bizEx) {
                    this.getView().showErrorNotification(bizEx.getMessage());
                }
                break;
            }
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        int rowIndex = evt.getRowIndex();
        ReportList reportList = (ReportList)evt.getSource();
        IReportListModel reportModel = reportList.getReportModel();
        DynamicObject rowData = reportModel.getRowData(rowIndex);
        String fieldName = evt.getFieldName();
        if ("totalnumber".equals(fieldName)) {
            this.showDetailReport(rowData);
        }
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        Date queryEndDate;
        String formId = this.getView().getFormShowParameter().getFormId();
        if ("lc_sum_lettercredit".equals(formId) && EmptyUtil.isEmpty((Object)(queryEndDate = (Date)this.getModel().getValue("filter_queryenddate")))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u67e5\u8be2\u622a\u6b62\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a", (String)"DetailBaseReportFormPlugin_4", (String)"tmc-lc-report", (Object[])new Object[0]));
            return false;
        }
        return TmcViewInputHelper.checkMustInput((IFormView)this.getView(), (IDataModel)this.getModel(), (boolean)false, (String)"filter_statcurrency");
    }

    private void showDetailReport(DynamicObject rowData) {
        IReportView view;
        String formId;
        ReportQueryParam queryParam = this.getQueryParam();
        FilterInfo queryFilter = queryParam.getFilter();
        FilterInfo toDetailFilter = new FilterInfo();
        int sumlevel = (Integer)rowData.get("sumlevel");
        if (sumlevel == 0) {
            List<String> resetList = Arrays.asList("filter_org", "filter_bank", "filter_bizcurrency");
            for (FilterItemInfo item : queryFilter.getFilterItems()) {
                if (resetList.contains(item.getPropName())) continue;
                toDetailFilter.getFilterItems().add(item);
            }
            DynamicObject org = rowData.getDynamicObject("org");
            DynamicObject bank = rowData.getDynamicObject("bank");
            DynamicObject currency = rowData.getDynamicObject("currency");
            toDetailFilter.addFilterItem("filter_org", (Object)TmcDataServiceHelper.generateMultiPropValue((DynamicObject)this.getModel().getDataEntity(), (String)"filter_org", (DynamicObject[])new DynamicObject[]{org}));
            toDetailFilter.addFilterItem("filter_bank", (Object)bank);
            toDetailFilter.addFilterItem("filter_bizcurrency", (Object)currency);
        }
        if (sumlevel == 1) {
            String statdim = (String)this.getModel().getValue("filter_statdim");
            for (FilterItemInfo item : queryFilter.getFilterItems()) {
                if (statdim.contains(item.getPropName())) continue;
                toDetailFilter.getFilterItems().add(item);
            }
            if (statdim.contains("org")) {
                List filterItems = toDetailFilter.getFilterItems();
                for (int i = 0; i < filterItems.size(); ++i) {
                    if (!"filter_org".equals(((FilterItemInfo)filterItems.get(i)).getPropName())) continue;
                    filterItems.remove(i);
                }
                DynamicObject org = rowData.getDynamicObject("org");
                toDetailFilter.addFilterItem("filter_org", (Object)TmcDataServiceHelper.generateMultiPropValue((DynamicObject)this.getModel().getDataEntity(), (String)"filter_org", (DynamicObject[])new DynamicObject[]{org}));
            } else {
                this.removeOrgFilterItem(toDetailFilter);
            }
            if (statdim.contains("bank")) {
                DynamicObject bank = rowData.getDynamicObject("bank");
                toDetailFilter.addFilterItem("filter_bank", (Object)bank);
            }
            if (statdim.contains("currency")) {
                DynamicObject currency = rowData.getDynamicObject("currency");
                toDetailFilter.addFilterItem("filter_bizcurrency", (Object)currency);
            }
        }
        if (sumlevel == 2) {
            this.removeOrgFilterItem(queryParam);
            toDetailFilter = queryParam.getFilter();
        }
        if ("lc_sum_lettercredit".equals(formId = (view = this.getView()).getFormShowParameter().getFormId())) {
            Date queryEndDate = (Date)this.getModel().getValue("filter_queryenddate");
            toDetailFilter.addFilterItem("arrivaldate", (Object)queryEndDate, "<=");
        }
        ReportShowParameter parameter = new ReportShowParameter();
        parameter.setCustomParam("filter", (Object)SerializationUtils.serializeToBase64((Object)toDetailFilter));
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        parameter.setFormId("lc_sum_lettercredit".equals(formId) ? "lc_detail_lettercredit" : "lc_detail_receipt");
        view.showForm((FormShowParameter)parameter);
    }

    private Set<String> getAllFields() {
        ReportList reportList = (ReportList)this.getControl("reportlistap");
        List columns = reportList.getColumns();
        return columns.stream().map(s -> ((ReportColumn)s).getFieldKey()).collect(Collectors.toSet());
    }

    private void removeOrgFilterItem(ReportQueryParam queryParam) {
        FilterItemInfo filterItem = queryParam.getFilter().getFilterItem("filter_org");
        if (filterItem != null && filterItem.getValue() != null) {
            List filterItems = queryParam.getFilter().getFilterItems();
            for (int i = filterItems.size() - 1; i >= 0; --i) {
                if (!((FilterItemInfo)filterItems.get(i)).getPropName().equals("filter_org")) continue;
                FilterItemInfo filterItemInfo = new FilterItemInfo();
                filterItemInfo.setPropName("filter_org_id");
                filterItemInfo.setValue(((FilterItemInfo)filterItems.get(i)).getValue());
                filterItems.remove(i);
                filterItems.add(filterItemInfo);
            }
        }
    }

    private void removeOrgFilterItem(FilterInfo filterInfo) {
        List filterItems = filterInfo.getFilterItems();
        for (int i = filterItems.size() - 1; i >= 0; --i) {
            if (!((FilterItemInfo)filterItems.get(i)).getPropName().equals("filter_org")) continue;
            FilterItemInfo filterItemInfo = new FilterItemInfo();
            filterItemInfo.setPropName("filter_org_id");
            filterItemInfo.setValue(((FilterItemInfo)filterItems.get(i)).getValue());
            filterItems.remove(i);
            filterItems.add(filterItemInfo);
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey = evt.getItemKey();
        if ("querydetail".equals(itemKey)) {
            ReportQueryParam queryParam = this.getQueryParam();
            ReportShowParameter showParameter = new ReportShowParameter();
            this.removeOrgFilterItem(queryParam);
            showParameter.getCustomParams().put("queryDetail", "true");
            showParameter.getCustomParams().put("filter", SerializationUtils.serializeToBase64((Object)queryParam));
            showParameter.setFormId("lc_detail_lettercredit");
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            this.getView().showForm((FormShowParameter)showParameter);
        }
    }
}

