/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.lc.report.helper;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.report.IReportListModel;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.lc.common.enums.ArrivalStatusEnum;
import kd.tmc.lc.common.enums.PresentStatusEnum;
import kd.tmc.lc.common.property.LetterCreditProp;
import kd.tmc.lc.report.helper.ReportHelper;

public class DetailReportHelper {
    public static DataSet getArrivalSet(DataSet letterCreditDatas, String entryName) {
        List<Long> dataSetIds = DetailReportHelper.getDataSetIds(letterCreditDatas);
        boolean isArrival = entryName.equals("lc_arrival");
        return QueryServiceHelper.queryDataSet((String)"DetailReportDataListPluginArr", (String)entryName, (String)"id,lettercredit,doneamount,todoamount,arrivalamount", (QFilter[])new QFilter[]{new QFilter("lettercredit", "in", dataSetIds), new QFilter("arrivalstatus", "!=", (Object)(isArrival ? ArrivalStatusEnum.ARRIVAL_REGISTER.getValue() : PresentStatusEnum.PRESENT_REGISTER.getValue()))}, null).groupBy(new String[]{"lettercredit"}).count().sum("arrivalamount").sum("doneamount").sum("todoamount").finish();
    }

    public static DataSet getLetterCreditByRateUnit(DataSet letterCreditData, String entryName, Map<String, Object> paramMap, String[] fields) {
        letterCreditData = letterCreditData.addField("0L", "tarcurrency").addField("1", "rate");
        DataSet select = "letterReport".equals(paramMap.get("reportType")) ? DetailReportHelper.getLetterArrivalData(letterCreditData, entryName, fields, paramMap) : DetailReportHelper.getReceiptArrivalData(letterCreditData, entryName, fields);
        return select;
    }

    private static DataSet getReceiptArrivalData(DataSet letterCreditDatas, String entryName, String[] fields) {
        letterCreditDatas = letterCreditDatas.addField("amount * (1 + amountscaleupper/100)", "letmount");
        DataSet arrivalSet = DetailReportHelper.getArrivalSet(letterCreditDatas, entryName);
        return letterCreditDatas.leftJoin(arrivalSet).on("id", "lettercredit").select(fields, new String[]{"lettercredit", "count as arrnum", "arrivalamount as arramount", "doneamount as arrpayamount", "todoamount as arrnotpayamount", "doneamount", "arrivalamount"}).finish().addField("case when lettercredit==null then (amount * (1 + amountscaleupper/100)) else (amount * (1 + amountscaleupper/100) -doneamount) end", "letnotpayamount").addField("case when lettercredit==null then (amount * (1 + amountscaleupper/100)) else (amount * (1 + amountscaleupper/100)-arrivalamount) end", "notarramount");
    }

    private static DataSet getLetterArrivalData(DataSet letterCreditDatas, String entryName, String[] fields, Map<String, Object> paramMap) {
        List<Long> creditSetIds = DetailReportHelper.getDataSetIds(letterCreditDatas);
        boolean isArrival = entryName.equals("lc_arrival");
        Date queryEndDate = (Date)paramMap.get("filter_queryenddate");
        queryEndDate = DateUtils.getDataFormat((Date)queryEndDate, (boolean)false);
        DataSet arrivalSet = QueryServiceHelper.queryDataSet((String)"DetailReportDataListPluginArr", (String)"lc_arrival", (String)"id,lettercredit,arrivalamount", (QFilter[])new QFilter[]{new QFilter("lettercredit", "in", creditSetIds), new QFilter("arrivalstatus", "!=", (Object)ArrivalStatusEnum.ARRIVAL_REGISTER.getValue())}, null);
        List<Long> arrivalSetIds = DetailReportHelper.getDataSetIds(arrivalSet);
        DataSet arrAmountSet = QueryServiceHelper.queryDataSet((String)"DetailReportDataListPluginArr", (String)"lc_arrival", (String)"id,lettercredit,arrivalamount", (QFilter[])new QFilter[]{new QFilter("id", "in", arrivalSetIds), new QFilter("arrivaldate", "<=", (Object)queryEndDate)}, null).groupBy(new String[]{"lettercredit"}).count("arrnum").sum("arrivalamount", "arramount").finish();
        DataSet arrPayAmountSet = QueryServiceHelper.queryDataSet((String)"DetailReportDataListPluginArr", (String)"lc_arrival", (String)"id,lettercredit,arrivalamount,entrys.arrpayamount", (QFilter[])new QFilter[]{new QFilter("id", "in", arrivalSetIds), new QFilter("entrys.realpaydate", "<=", (Object)queryEndDate)}, null).groupBy(new String[]{"lettercredit"}).sum("entrys.arrpayamount", "arrpayamount").finish();
        DataSet result = letterCreditDatas.leftJoin(arrAmountSet).on("id", "lettercredit").select(fields, new String[]{"arrnum", "arramount"}).finish().updateField("arramount", "case when arramount is null then 0 else arramount end").addField("amount * (1 + amountscaleupper/100) - arramount", "notarramount");
        result = result.leftJoin(arrPayAmountSet).on("id", "lettercredit").select(result.getRowMeta().getFieldNames(), new String[]{"arrpayamount"}).finish().updateField("arrpayamount", "case when arrpayamount is null then 0 else arrpayamount end").addField("amount * (1 + amountscaleupper/100) - arrpayamount", "letnotpayamount").addField("arramount-arrpayamount", "arrnotpayamount");
        return result;
    }

    public static QFilter getFilter(Map<String, Object> paramMap) {
        DynamicObjectCollection creditTypes;
        QFilter filter = new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue());
        ArrayList orgIds = (ArrayList)paramMap.get("filter_org");
        filter.and("org", "in", (Object)orgIds);
        DynamicObjectCollection letterCredits = (DynamicObjectCollection)paramMap.get("filter_lettercredit");
        if (letterCredits != null && letterCredits.size() > 0) {
            List ids = letterCredits.stream().map(DataEntityBase::getPkValue).collect(Collectors.toList());
            filter.and("id", "in", ids);
            return filter;
        }
        String bizDateRanges = (String)paramMap.get("filter_bizdate");
        ReportHelper.buildDateRangesFilter(filter, "filter_bizdate", bizDateRanges, "bizdate", paramMap);
        DynamicObject bank = (DynamicObject)paramMap.get("filter_bank");
        ReportHelper.buildDynamicObjectFilter(filter, bank, "bank");
        DynamicObject currency = (DynamicObject)paramMap.get("filter_bizcurrency");
        ReportHelper.buildDynamicObjectFilter(filter, currency, "currency");
        String validDateRanges = (String)paramMap.get("filter_vadate");
        ReportHelper.buildDateRangesFilter(filter, "filter_vadate", validDateRanges, "validdate", paramMap);
        String isNationalcard = (String)paramMap.get("filter_isnationalcard");
        ReportHelper.buildStrFilter(filter, isNationalcard, LetterCreditProp.ISNATIONALCARD);
        String isForward = (String)paramMap.get("filter_isforward");
        ReportHelper.buildStrFilter(filter, isForward, "isforward");
        DynamicObject credittype = (DynamicObject)paramMap.get("filter_credittype");
        if (EmptyUtil.isNoEmpty((DynamicObject)credittype)) {
            ReportHelper.buildDynamicObjectFilter(filter, credittype, "credittype");
        }
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)(creditTypes = (DynamicObjectCollection)paramMap.get("filter_credittypes")))) {
            filter.and("credittype", "in", creditTypes.stream().map(DataEntityBase::getPkValue).collect(Collectors.toList()));
        }
        return filter;
    }

    public static List<Long> getDataSetIds(DataSet dataSet) {
        DataSet fsDS = dataSet.copy();
        ArrayList<Long> ids = new ArrayList<Long>(16);
        for (Row row : fsDS) {
            ids.add(row.getLong("id"));
        }
        return ids;
    }

    public static Set<Long> getLettIds(IReportListModel reportModel, int index) {
        HashSet<Long> ids = new HashSet<Long>(16);
        DynamicObject rowIdxData = reportModel.getRowData(index);
        int initLevel = rowIdxData.getInt("sumlevel");
        for (int i = index - 1; i > 0; --i) {
            DynamicObject rowData = reportModel.getRowData(i);
            if (initLevel != 2 && EmptyUtil.isEmpty((DynamicObject)rowData.getDynamicObject("id"))) break;
            if (EmptyUtil.isEmpty((DynamicObject)rowData.getDynamicObject("id"))) continue;
            if (rowData.getInt("sumlevel") >= initLevel) {
                return ids;
            }
            ids.add(rowData.getDynamicObject("id").getLong("id"));
        }
        return ids;
    }

    public static String getSelectFields(Map<String, Object> paramMap, String selectField) {
        Set fields = (Set)paramMap.get("fields");
        Set<String> noSelectFields = DetailReportHelper.getNoSelectField();
        StringBuilder builder = new StringBuilder();
        builder.append(selectField);
        for (String field : fields) {
            if (selectField.contains(field) || noSelectFields.contains(field)) continue;
            builder.append(",");
            builder.append(field);
        }
        return builder.toString();
    }

    public static Set<String> getNoSelectField() {
        HashSet<String> fields = new HashSet<String>(16);
        fields.add("orgtext");
        fields.add("contractnums");
        fields.add("rate");
        fields.add("rateamount");
        fields.add("arrnum");
        fields.add("arramount");
        fields.add("notarramount");
        fields.add("letnotpayamount");
        fields.add("arrpayamount");
        fields.add("arrnotpayamount");
        fields.add("sumlevel");
        fields.add("statcurrency");
        fields.add("tarcurrency");
        return fields;
    }
}

