/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.lc.common.helper;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.tmc.fbp.common.enums.BasisEnum;
import kd.tmc.fbp.common.enums.RepaymentWayEnum;
import kd.tmc.fbp.common.model.interest.BizBillInfo;
import kd.tmc.fbp.common.model.interest.IntBillInfo;
import kd.tmc.fbp.common.model.interest.IntCalRequest;
import kd.tmc.fbp.common.model.interest.RateInfo;
import kd.tmc.fbp.service.factory.IntCallFactory;
import kd.tmc.fbp.service.inst.interest.IIntCallStragety;

public class InterestCalcHelper {
    public static IntBillInfo callInt(DynamicObject currency, BasisEnum basis, BigDecimal principle, BigDecimal rate, Date effectDate, Date beginDate, Date endDate) {
        Set<RateInfo> rateList = InterestCalcHelper.getRateList(rate, effectDate);
        return InterestCalcHelper.callInt(currency, basis, rateList, beginDate, endDate, principle);
    }

    private static IntBillInfo callInt(DynamicObject currency, BasisEnum basis, Set<RateInfo> rateList, Date beginDate, Date endDate, BigDecimal principle) {
        IntCalRequest request = new IntCalRequest();
        BizBillInfo bizBill = InterestCalcHelper.getBizBill(currency, principle, basis, beginDate, endDate);
        request.setBizBill(bizBill);
        request.setRateList(rateList);
        IIntCallStragety stragety = IntCallFactory.getInstance((RepaymentWayEnum)bizBill.getRepayWay());
        return stragety.callInt(request);
    }

    private static BizBillInfo getBizBill(DynamicObject currency, BigDecimal principle, BasisEnum basis, Date beginDate, Date endDate) {
        BizBillInfo bizBill = new BizBillInfo();
        bizBill.setLoanAmount(principle);
        bizBill.setBeginDate(beginDate);
        bizBill.setEndDate(endDate);
        bizBill.setRepayWay(RepaymentWayEnum.dqhbdqhx);
        bizBill.setBasis(basis);
        bizBill.setCurrencyId(currency.getLong("id"));
        return bizBill;
    }

    private static Set<RateInfo> getRateList(BigDecimal rate, Date effectDate) {
        RateInfo info = new RateInfo();
        info.setEffectiveDate(effectDate);
        info.setRate(rate);
        HashSet<RateInfo> rateSet = new HashSet<RateInfo>();
        rateSet.add(info);
        return rateSet;
    }
}

