/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.lc.common.helper;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.common.enums.FeeSourceEnum;
import kd.tmc.fbp.common.enums.ProductTypeEnum;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class LcFeeDetailHelper {
    private static String[] feeProps = new String[]{"entry.producttype", "entry.excrate", "feescheme", "feetype", "currency", "paydate", "payamt", "amountrate", "settlementtype", "feeacctbank", "oppunittype", "oppunit", "oppunittext", "oppacctbank", "oppbebank", "feesource", "issettle", "description", "id", "entry.id", "billno"};

    public static void saveHistoryFeeTabInfo(DynamicObject history, DynamicObject bizBill) {
        QFilter feeFilter = new QFilter("entry.srcbillid", "=", bizBill.getPkValue()).and(new QFilter("feesource", "=", (Object)FeeSourceEnum.LINKGEN.getValue()));
        DynamicObjectCollection feeEntryBills = QueryServiceHelper.query((String)"cfm_feebill", (String)String.join((CharSequence)",", feeProps), (QFilter[])new QFilter[]{feeFilter});
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)feeEntryBills)) {
            DynamicObjectCollection feeDetails = history.getDynamicObjectCollection("feedetail");
            feeDetails.clear();
            int seq = 1;
            for (DynamicObject feeEntryBill : feeEntryBills) {
                DynamicObject intDetail = feeDetails.addNew();
                intDetail.set("seq", (Object)seq++);
                intDetail.set("feeproducttype", (Object)LcFeeDetailHelper.getFeeProductTypeNum(feeEntryBill));
                intDetail.set("feescheme", feeEntryBill.get("feescheme"));
                intDetail.set("feetype", feeEntryBill.get("feetype"));
                intDetail.set("feecurrency", feeEntryBill.get("currency"));
                intDetail.set("feepaydate", feeEntryBill.get("paydate"));
                intDetail.set("feeamt", feeEntryBill.get("payamt"));
                intDetail.set("feerate", feeEntryBill.get("amountrate"));
                intDetail.set("feesettletype", feeEntryBill.get("settlementtype"));
                intDetail.set("feeacctbank", feeEntryBill.get("feeacctbank"));
                intDetail.set("feeoppunittype", feeEntryBill.get("oppunittype"));
                intDetail.set("feeoppunit", feeEntryBill.get("oppunit"));
                intDetail.set("feeoppunittext", feeEntryBill.get("oppunittext"));
                intDetail.set("feeoppacctbank", feeEntryBill.get("oppacctbank"));
                intDetail.set("feeoppbebank", feeEntryBill.get("oppbebank"));
                intDetail.set("feesource", feeEntryBill.get("feesource"));
                intDetail.set("feeissettle", feeEntryBill.get("issettle"));
                intDetail.set("feeremark", feeEntryBill.get("description"));
                intDetail.set("feebillentryid", feeEntryBill.get("entry.id"));
                intDetail.set("feebillid", feeEntryBill.getPkValue());
                intDetail.set("feebillnum", feeEntryBill.get("billno"));
                intDetail.set("excrate", feeEntryBill.get("entry.excrate"));
            }
        }
    }

    public static void updateFeeDetailBill(DynamicObject historyBill, DynamicObject info, ProductTypeEnum productTypeEnum) {
        DynamicObjectCollection hisFeeDetails = historyBill.getDynamicObjectCollection("feedetail");
        QFilter feeFilter = new QFilter("entry.srcbillid", "=", info.getPkValue()).and(new QFilter("feesource", "=", (Object)FeeSourceEnum.LINKGEN.getValue()));
        DynamicObjectCollection feeBillDBs = QueryServiceHelper.query((String)"cfm_feebill", (String)"id,billno,org,creator,modifier,modifytime,createtime", (QFilter[])new QFilter[]{feeFilter});
        Map<Long, Object> idCreatorMap = feeBillDBs.stream().collect(Collectors.toMap(o -> o.getLong("id"), o -> o.get("creator")));
        Map<Long, Object> idmodifierMap = feeBillDBs.stream().collect(Collectors.toMap(o -> o.getLong("id"), o -> o.get("modifier")));
        Map<Long, Object> idCreatetimeMap = feeBillDBs.stream().collect(Collectors.toMap(o -> o.getLong("id"), o -> o.get("createtime")));
        Map<Long, Object> idModifytimeMap = feeBillDBs.stream().collect(Collectors.toMap(o -> o.getLong("id"), o -> o.get("modifytime")));
        DeleteServiceHelper.delete((String)"cfm_feebill", (QFilter[])new QFilter[]{feeFilter});
        if (!hisFeeDetails.isEmpty()) {
            List hisLinkgenFeeEntrys = hisFeeDetails.stream().filter(o -> FeeSourceEnum.LINKGEN.getValue().equals(o.getString("feesource"))).collect(Collectors.toList());
            if (hisLinkgenFeeEntrys.size() <= 0) {
                return;
            }
            ArrayList<DynamicObject> needSaveFeeBillLists = new ArrayList<DynamicObject>(hisLinkgenFeeEntrys.size());
            Long thisOrgId = info.getDynamicObject("org").getLong("id");
            for (DynamicObject hisLinkgenFeeEntry : hisLinkgenFeeEntrys) {
                DynamicObject feeBillDo = BusinessDataServiceHelper.newDynamicObject((String)"cfm_feebill");
                Long feeBillId = hisLinkgenFeeEntry.getLong("feebillid");
                feeBillDo.set("id", (Object)feeBillId);
                feeBillDo.set("billno", (Object)hisLinkgenFeeEntry.getString("feebillnum"));
                feeBillDo.set("org", (Object)thisOrgId);
                feeBillDo.set("feescheme", (Object)LcFeeDetailHelper.getIdByBaseDo(hisLinkgenFeeEntry, "feescheme"));
                feeBillDo.set("feetype", (Object)LcFeeDetailHelper.getIdByBaseDo(hisLinkgenFeeEntry, "feetype"));
                feeBillDo.set("paydate", (Object)hisLinkgenFeeEntry.getDate("feepaydate"));
                feeBillDo.set("currency", (Object)LcFeeDetailHelper.getIdByBaseDo(hisLinkgenFeeEntry, "feecurrency"));
                feeBillDo.set("payamt", (Object)hisLinkgenFeeEntry.getBigDecimal("feeamt"));
                feeBillDo.set("amountrate", (Object)hisLinkgenFeeEntry.getBigDecimal("feerate"));
                feeBillDo.set("settlementtype", (Object)LcFeeDetailHelper.getIdByBaseDo(hisLinkgenFeeEntry, "feesettletype"));
                feeBillDo.set("feeacctbank", (Object)LcFeeDetailHelper.getIdByBaseDo(hisLinkgenFeeEntry, "feeacctbank"));
                feeBillDo.set("oppunittype", (Object)hisLinkgenFeeEntry.getString("feeoppunittype"));
                feeBillDo.set("oppunit", (Object)LcFeeDetailHelper.getIdByBaseDo(hisLinkgenFeeEntry, "feeoppunit"));
                feeBillDo.set("oppunittext", (Object)hisLinkgenFeeEntry.getString("feeoppunittext"));
                feeBillDo.set("oppacctbank", (Object)hisLinkgenFeeEntry.getString("feeoppacctbank"));
                feeBillDo.set("oppbebank", (Object)LcFeeDetailHelper.getIdByBaseDo(hisLinkgenFeeEntry, "feeoppbebank"));
                feeBillDo.set("billstatus", (Object)info.getString("billstatus"));
                feeBillDo.set("feesource", (Object)hisLinkgenFeeEntry.getString("feesource"));
                feeBillDo.set("issettle", (Object)hisLinkgenFeeEntry.getBoolean("feeissettle"));
                LcFeeDetailHelper.setSysBillDefaultVal(idCreatorMap, idmodifierMap, idCreatetimeMap, idModifytimeMap, feeBillDo, feeBillId);
                feeBillDo.set("appsource", (Object)"lc");
                DynamicObjectCollection entrys = feeBillDo.getDynamicObjectCollection("entry");
                DynamicObject entry = entrys.addNew();
                entry.set("producttype", (Object)LcFeeDetailHelper.getProductBaseId(hisLinkgenFeeEntry.getString("feeproducttype")));
                entry.set("srcbillno", (Object)info.getString("billno"));
                LcFeeDetailHelper.lcBizDeal(info, productTypeEnum, entry);
                entry.set("srcbillid", (Object)info.getLong("id"));
                entry.set("feeratio", (Object)100);
                entry.set("feedetailamt", (Object)hisLinkgenFeeEntry.getBigDecimal("feeamt"));
                entry.set("remark", (Object)hisLinkgenFeeEntry.getString("feeremark"));
                entry.set("id", (Object)hisLinkgenFeeEntry.getLong("feebillentryid"));
                entry.set("excrate", (Object)hisLinkgenFeeEntry.getBigDecimal("excrate"));
                needSaveFeeBillLists.add(feeBillDo);
            }
            if (EmptyUtil.isNoEmpty(needSaveFeeBillLists)) {
                SaveServiceHelper.save((DynamicObject[])needSaveFeeBillLists.toArray(new DynamicObject[0]));
            }
        }
    }

    private static Long getProductBaseId(String value) {
        for (ProductTypeEnum productType : ProductTypeEnum.values()) {
            if (!value.equals(productType.getValue())) continue;
            return Long.valueOf(productType.getId());
        }
        return 0L;
    }

    private static void setSysBillDefaultVal(Map<Long, Object> idCreatorMap, Map<Long, Object> idmodifierMap, Map<Long, Object> idCreatetimeMap, Map<Long, Object> idModifytimeMap, DynamicObject feeBillDo, Long feeBillId) {
        Object createTime = idCreatetimeMap.get(feeBillId);
        if (EmptyUtil.isNoEmpty((Object)createTime)) {
            feeBillDo.set("createtime", createTime);
        } else {
            feeBillDo.set("createtime", (Object)DateUtils.getCurrentTime());
        }
        Object modifyTime = idModifytimeMap.get(feeBillId);
        if (EmptyUtil.isNoEmpty((Object)modifyTime)) {
            feeBillDo.set("modifytime", modifyTime);
        } else {
            feeBillDo.set("modifytime", (Object)DateUtils.getCurrentTime());
        }
        long user = Long.parseLong(RequestContext.get().getUserId());
        Object creator = idCreatorMap.get(feeBillId);
        if (EmptyUtil.isNoEmpty((Object)creator)) {
            feeBillDo.set("creator", creator);
        } else {
            feeBillDo.set("creator", (Object)user);
        }
        Object modifier = idmodifierMap.get(feeBillId);
        if (EmptyUtil.isNoEmpty((Object)modifier)) {
            feeBillDo.set("modifier", modifier);
        } else {
            feeBillDo.set("modifier", (Object)user);
        }
    }

    private static void lcBizDeal(DynamicObject info, ProductTypeEnum typeEnum, DynamicObject entry) {
        String entityName = typeEnum.getEntity();
        if (ProductTypeEnum.LC_LETTER.getEntity().equals(entityName)) {
            entry.set("creditno", (Object)info.getString("creditno"));
        } else if (ProductTypeEnum.LC_ARRIVAL.getEntity().equals(entityName) || ProductTypeEnum.LC_PRESENT.getEntity().equals(entityName)) {
            DynamicObject letterCredit = info.getDynamicObject("lettercredit");
            if (EmptyUtil.isNoEmpty((DynamicObject)letterCredit)) {
                entry.set("creditno", (Object)letterCredit.getString("number"));
            }
            entry.set("arrisubno", (Object)info.getString("arrivalno"));
        } else if (ProductTypeEnum.LC_FORFAIT.getEntity().equals(entityName)) {
            DynamicObject arrivalno;
            DynamicObject letterCredit = info.getDynamicObject("lettercredit");
            if (EmptyUtil.isNoEmpty((DynamicObject)letterCredit)) {
                entry.set("creditno", (Object)letterCredit.getString("number"));
            }
            if (EmptyUtil.isNoEmpty((DynamicObject)(arrivalno = info.getDynamicObject("arrivalno")))) {
                entry.set("arrisubno", (Object)arrivalno.getString("arrivalno"));
            }
        }
    }

    private static Long getIdByBaseDo(DynamicObject info, String propKey) {
        DynamicObject propVal = info.getDynamicObject(propKey);
        return EmptyUtil.isEmpty((DynamicObject)propVal) ? 0L : propVal.getLong("id");
    }

    private static String getFeeProductTypeNum(DynamicObject feeBill) {
        String productTypeId = String.valueOf(feeBill.get("entry.producttype"));
        for (ProductTypeEnum productType : ProductTypeEnum.values()) {
            if (!productTypeId.equals(productType.getId())) continue;
            return productType.getValue();
        }
        return "";
    }
}

