/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.lc.common.helper;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.events.BeforeFieldPostBackEvent;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.common.enums.BeBillStatusEnum;
import kd.tmc.fbp.common.helper.CreditLimitServiceHelper;
import kd.tmc.fbp.common.helper.GuaranteeUseHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.model.guaranteeuse.GuaranteeUseReturnBean;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.service.ebservice.utils.BeServiceHelper;
import kd.tmc.fbp.webapi.ebentity.biz.lettercredit.OpenCreditResponseBody;
import kd.tmc.fbp.webapi.ebentity.biz.lettercredit.OpenCreditResponseDetail;
import kd.tmc.lc.common.enums.ArrivalStatusEnum;
import kd.tmc.lc.common.helper.LetterCreditHelper;

public class OnlineServiceHelper {
    public static final Long CCB_BANKTYPE = 544782186595789006L;
    public static final Long CNCB_BANKTYPE = 544782186595789009L;

    public static QFilter getDateQfilter(String fieldName, List<Object> values) {
        if (EmptyUtil.isEmpty(values)) {
            return null;
        }
        Date startDate = null;
        Date endDate = null;
        if (values.size() == 2) {
            startDate = DateUtils.stringToDate((String)values.get(0).toString(), (String)"yyyy-MM-dd");
            endDate = DateUtils.stringToDate((String)values.get(1).toString(), (String)"yyyy-MM-dd");
            return new QFilter(fieldName, ">=", (Object)DateUtils.getDataFormat((Date)startDate, (boolean)true)).and(new QFilter(fieldName, "<=", (Object)DateUtils.getDataFormat((Date)endDate, (boolean)false)));
        }
        String value = values.get(0).toString();
        if (EmptyUtil.isEmpty((String)value)) {
            return new QFilter("1", "=", (Object)1);
        }
        switch (value) {
            case "13": {
                startDate = DateUtils.getCurrentDate();
                endDate = DateUtils.getCurrentDate();
                break;
            }
            case "10": {
                Map weekDate = DateUtils.getWeekDate();
                startDate = (Date)weekDate.get("beginDate");
                endDate = (Date)weekDate.get("endDate");
                break;
            }
            case "63": {
                startDate = DateUtils.getMinMonthDate((Date)DateUtils.getCurrentDate());
                endDate = DateUtils.getMaxMonthDate((Date)DateUtils.getCurrentDate());
                break;
            }
            case "24": {
                startDate = DateUtils.getLastMonth((Date)DateUtils.getCurrentDate(), (int)3);
                endDate = DateUtils.getCurrentDate();
                break;
            }
        }
        return new QFilter(fieldName, ">=", (Object)DateUtils.getDataFormat((Date)startDate, (boolean)true)).and(new QFilter(fieldName, "<=", (Object)DateUtils.getDataFormat((Date)endDate, (boolean)false)));
    }

    public static List<String> getDynamicListFilters(Map<String, List<Map<String, List<Object>>>> filterMap, List<String> commonFilterColumns) {
        ArrayList<String> qfilters = new ArrayList<String>();
        OnlineServiceHelper.addCustomFilter(filterMap.get("customfilter"), qfilters, commonFilterColumns);
        OnlineServiceHelper.addFastFilter(filterMap.get("fastfilter"), qfilters);
        return qfilters;
    }

    private static void addCustomFilter(List<Map<String, List<Object>>> customfilter, List<String> qfilters, List<String> commonFilterColumns) {
        if (EmptyUtil.isEmpty(customfilter)) {
            return;
        }
        for (Map<String, List<Object>> customfilterMap : customfilter) {
            String fieldName;
            List values = customfilterMap.get("Value").stream().filter(EmptyUtil::isNoEmpty).collect(Collectors.toList());
            if (EmptyUtil.isEmpty(values) || EmptyUtil.isEmpty((String)(fieldName = customfilterMap.get("FieldName").get(0).toString()))) continue;
            String mainField = fieldName;
            if (fieldName.indexOf(".") > 0) {
                mainField = fieldName.substring(0, fieldName.indexOf("."));
            }
            if (!commonFilterColumns.contains(mainField)) continue;
            if (StringUtils.endsWith((CharSequence)fieldName, (CharSequence)".id")) {
                qfilters.add(new QFilter(fieldName, "in", values.stream().map(v -> Long.valueOf(v.toString())).collect(Collectors.toList())).toSerializedString());
                continue;
            }
            List compareStrs = customfilterMap.get("Compare").stream().filter(EmptyUtil::isNoEmpty).collect(Collectors.toList());
            if (EmptyUtil.isEmpty(compareStrs) && !fieldName.equals("bizdate")) {
                qfilters.add(new QFilter(fieldName, "in", values).toSerializedString());
                continue;
            }
            QFilter dateQfilter = OnlineServiceHelper.getDateQfilter(fieldName, values.stream().map(Object::toString).collect(Collectors.toList()));
            if (null == dateQfilter) continue;
            qfilters.add(dateQfilter.toSerializedString());
        }
    }

    private static void addFastFilter(List<Map<String, List<Object>>> fastFilter, List<String> qfilters) {
        if (EmptyUtil.isEmpty(fastFilter)) {
            return;
        }
        Map<String, List<Object>> fastFilterMap = fastFilter.get(0);
        List values = fastFilterMap.get("Value").stream().filter(EmptyUtil::isNoEmpty).collect(Collectors.toList());
        if (EmptyUtil.isEmpty(values)) {
            return;
        }
        List<Object> fieldNames = fastFilterMap.get("FieldName");
        QFilter qfilter = null;
        for (Object fieldName : fieldNames) {
            for (Object value : values) {
                QFilter orFilter = new QFilter(fieldName.toString(), "like", (Object)("%" + value + "%"));
                qfilter = null == qfilter ? orFilter : qfilter.or(orFilter);
            }
        }
        if (null != qfilter) {
            qfilters.add(qfilter.toSerializedString());
        }
    }

    public static void dealOnlineOpenCredit(String resultBody, DynamicObject letterCreditBill) {
        OpenCreditResponseBody responseBody = (OpenCreditResponseBody)JSON.parseObject((String)resultBody, OpenCreditResponseBody.class);
        List detailList = responseBody.getDetails();
        if (EmptyUtil.isEmpty((Collection)detailList)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u94f6\u4f01\u8fd4\u56de\u660e\u7ec6\u4e3a\u7a7a\uff01\u8be6\u60c5\u8bf7\u67e5\u770b\u540c\u6b65\u65e5\u5fd7\u3002", (String)"OnlineServiceHelper_1", (String)"tmc-lc-common", (Object[])new Object[0]));
        }
        OpenCreditResponseDetail detail = (OpenCreditResponseDetail)detailList.get(0);
        if (detail.getDetailSeqID().equals(letterCreditBill.getPkValue().toString())) {
            BeBillStatusEnum status = BeServiceHelper.transferState((String)detail.getEbStatus());
            if (BeBillStatusEnum.TS.getValue().equals(status.getValue())) {
                letterCreditBill.set("bebankstatus", (Object)status.getValue());
                letterCreditBill.set("returnmsg", (Object)"");
                letterCreditBill.set("creditno", (Object)detail.getCreditNo());
            } else {
                letterCreditBill.set("bebankstatus", (Object)status.getValue());
                letterCreditBill.set("returnmsg", (Object)detail.getEbStatusMsg());
            }
        }
        try (TXHandle tx = TX.requiresNew();){
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{letterCreditBill});
        }
    }

    public static void dealOnlineArrival(String resultBody, DynamicObject arrival, String subBizType) {
        OpenCreditResponseBody responseBody = (OpenCreditResponseBody)JSON.parseObject((String)resultBody, OpenCreditResponseBody.class);
        List detailList = responseBody.getDetails();
        if (EmptyUtil.isEmpty((Collection)detailList)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u94f6\u4f01\u8fd4\u56de\u660e\u7ec6\u4e3a\u7a7a\uff01\u8be6\u60c5\u8bf7\u67e5\u770b\u540c\u6b65\u65e5\u5fd7\u3002", (String)"OnlineServiceHelper_1", (String)"tmc-lc-common", (Object[])new Object[0]));
        }
        OpenCreditResponseDetail detail = (OpenCreditResponseDetail)detailList.get(0);
        if (detail.getDetailSeqID().equals(arrival.getPkValue().toString())) {
            BeBillStatusEnum status = BeServiceHelper.transferState((String)detail.getEbStatus());
            if (BeBillStatusEnum.TS.getValue().equals(status.getValue())) {
                if ("aceptCredit".equals(subBizType)) {
                    arrival.set("acceptbebankstatus", (Object)status.getValue());
                    arrival.set("acceptreturnmsg", (Object)"");
                } else {
                    arrival.set("bebankstatus", (Object)status.getValue());
                    arrival.set("returnmsg", (Object)"");
                }
                switch (subBizType) {
                    case "aceptCredit": {
                        OnlineServiceHelper.setArrivalEndPayDate(arrival, detail);
                        OnlineServiceHelper.dealAcceptSuccessScene(arrival, false);
                        break;
                    }
                    case "paymentCredit": {
                        OnlineServiceHelper.setArrivalEndPayDate(arrival, detail);
                        if (EmptyUtil.isEmpty((String)arrival.getString("acceptbebankstatus"))) {
                            OnlineServiceHelper.dealAcceptSuccessScene(arrival, false);
                        }
                        OnlineServiceHelper.dealPaySuccessScene(arrival);
                        break;
                    }
                    case "refuseCredit": {
                        OnlineServiceHelper.dealAcceptSuccessScene(arrival, true);
                        break;
                    }
                }
            } else if ("aceptCredit".equals(subBizType)) {
                arrival.set("acceptbebankstatus", (Object)status.getValue());
                arrival.set("acceptreturnmsg", (Object)detail.getEbStatusMsg());
            } else {
                arrival.set("bebankstatus", (Object)status.getValue());
                arrival.set("returnmsg", (Object)detail.getEbStatusMsg());
            }
        }
        TXHandle tx = TX.requiresNew();
        Object object = null;
        try {
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{arrival});
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (object != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }

    private static void setArrivalEndPayDate(DynamicObject arrival, OpenCreditResponseDetail detail) {
        String bankRefDate = detail.getBankRefDate();
        if (EmptyUtil.isNoEmpty((String)bankRefDate)) {
            arrival.set("endpaydate", (Object)DateUtils.stringToDate((String)bankRefDate, (String)"yyyyMMdd"));
        }
    }

    public static void dealAcceptSuccessScene(DynamicObject arrival, boolean isRefusePay) {
        arrival.set("arrivalstatus", (Object)ArrivalStatusEnum.ARRIVAL_CONFIRM.getValue());
        arrival.set("configtime", (Object)arrival.getDate("submittime"));
        HashMap<Long, BigDecimal> letterArrMap = new HashMap<Long, BigDecimal>(8);
        long lcId = arrival.getLong("lettercredit.id");
        letterArrMap.put(lcId, arrival.getBigDecimal("arrivalamount"));
        HashMap<Long, Date> letterDateArrMap = new HashMap<Long, Date>(8);
        if (arrival.getBoolean("lettercredit.isnegotiating")) {
            letterDateArrMap.put(lcId, arrival.getDate("endpaydate"));
        }
        if (isRefusePay) {
            LetterCreditHelper.updateLetterCreditLimit("lc_lettercredit", lcId, arrival, Boolean.TRUE);
        }
        LetterCreditHelper.updateLetterArr("lc_lettercredit", letterArrMap, letterDateArrMap);
    }

    public static void dealPaySuccessScene(DynamicObject arrival) {
        DynamicObjectCollection entry = arrival.getDynamicObjectCollection("entrys");
        DynamicObject creatEntry = entry.addNew();
        creatEntry.set("arrpayamount", (Object)arrival.getBigDecimal("arrivalamount"));
        creatEntry.set("realpaydate", (Object)DateUtils.truncateDate((Date)arrival.getDate("submittime")));
        creatEntry.set("isdiffcur", (Object)Boolean.FALSE);
        creatEntry.set("arrpaycurrency", arrival.get("arrivalcurrency"));
        arrival.set("arrivalstatus", (Object)ArrivalStatusEnum.ARRIVAL_PAY.getValue());
        arrival.set("doneamount", (Object)arrival.getBigDecimal("arrivalamount"));
        arrival.set("todoamount", (Object)BigDecimal.ZERO);
        arrival.set("ispayconfig", (Object)"1");
        DynamicObject credit = TmcDataServiceHelper.loadSingle((Object)arrival.getDynamicObject("lettercredit").getPkValue(), (String)"lc_lettercredit");
        if (EmptyUtil.isNoEmpty((DynamicObject)credit.getDynamicObject("creditlimit"))) {
            boolean isPayAll = LetterCreditHelper.checkPayamount(credit, BigDecimal.ZERO);
            CreditLimitServiceHelper.returnCreditLimit((DynamicObject)arrival, (DynamicObject)credit, (boolean)false, (BigDecimal)arrival.getBigDecimal("arrivalamount"), (Long)((Long)creatEntry.getPkValue()), (boolean)isPayAll, (Date)DateUtils.truncateDate((Date)arrival.getDate("submittime")));
        }
        if (credit.getBoolean("isclosed")) {
            credit.set("isclosed", (Object)Boolean.FALSE);
            SaveServiceHelper.update((DynamicObject[])new DynamicObject[]{credit});
        }
        GuaranteeUseReturnBean returnContractBean = new GuaranteeUseReturnBean();
        returnContractBean.setBizBillId(Long.valueOf(arrival.getDynamicObject("lettercredit").getLong("id")));
        returnContractBean.setReturnBillId(Long.valueOf(arrival.getLong("id")));
        returnContractBean.setReturnBillType(arrival.getDataEntityType().getName());
        returnContractBean.setReturnAmount(arrival.getBigDecimal("doneamount"));
        GuaranteeUseHelper.returnGuaranteeUse(Collections.singletonList(returnContractBean));
    }

    public static DynamicObject getDirectConnSet(DynamicObject lcDyn) {
        Long orgId = Optional.ofNullable(lcDyn.getDynamicObject("org")).map(r -> r.getLong("id")).orElse(0L);
        Long bankCateId = Optional.ofNullable(lcDyn.getDynamicObject("bank")).map(r -> r.getDynamicObject("bank_cate")).map(r -> r.getLong("id")).orElse(0L);
        QFilter qFilter = new QFilter("org", "=", (Object)orgId);
        qFilter.and(new QFilter("banktype", "=", (Object)bankCateId));
        qFilter.and(new QFilter("enable", "=", (Object)Boolean.TRUE));
        return TmcDataServiceHelper.loadSingleFromCache((String)"lc_directconnset", (String)"defaultaccount", (QFilter[])new QFilter[]{qFilter});
    }

    public static DynamicObject getDirectConnSetForArrival(DynamicObject arrival) {
        Long orgId = Optional.ofNullable(arrival.getDynamicObject("org")).map(r -> r.getLong("id")).orElse(0L);
        Long bankCateId = Optional.ofNullable(arrival.getDynamicObject("arrivalbank")).map(r -> r.getDynamicObject("bank_cate")).map(r -> r.getLong("id")).orElse(0L);
        QFilter qFilter = new QFilter("org", "=", (Object)orgId);
        qFilter.and(new QFilter("banktype", "=", (Object)bankCateId));
        qFilter.and(new QFilter("enable", "=", (Object)Boolean.TRUE));
        return TmcDataServiceHelper.loadSingleFromCache((String)"lc_directconnset", (String)"defaultaccount", (QFilter[])new QFilter[]{qFilter});
    }

    public static DynamicObject getDirectConnSet(Map map) {
        Long orgId = Optional.ofNullable((String)map.get("org")).filter(r -> EmptyUtil.isNoEmpty((String)r)).map(r -> Long.valueOf(r)).orElse(0L);
        Long bankCateId = Optional.ofNullable((String)map.get("bank")).filter(r -> EmptyUtil.isNoEmpty((String)r)).map(r -> Long.valueOf(r)).orElse(0L);
        QFilter qFilter = new QFilter("org", "=", (Object)orgId);
        qFilter.and(new QFilter("banktype", "=", (Object)bankCateId));
        qFilter.and(new QFilter("enable", "=", (Object)Boolean.TRUE));
        return TmcDataServiceHelper.loadSingleFromCache((String)"lc_directconnset", (String)"defaultaccount", (QFilter[])new QFilter[]{qFilter});
    }

    public static List<Object> getLetterCreditIds(DynamicObject onlineDyn) {
        QFilter qFilter = new QFilter("org", "=", (Object)onlineDyn.getLong("org_id"));
        qFilter.and(new QFilter("creditno", "=", (Object)onlineDyn.getString("creditno")));
        DynamicObject currency = onlineDyn.getDynamicObject("currencyid");
        if (EmptyUtil.isNoEmpty((DynamicObject)currency)) {
            qFilter.and(new QFilter("currency", "=", onlineDyn.getDynamicObject("currencyid").get("id")));
        }
        return QueryServiceHelper.queryPrimaryKeys((String)"lc_lettercredit", (QFilter[])new QFilter[]{qFilter}, (String)"", (int)-1);
    }

    public static DynamicObject getLetterCreditBillStatus(DynamicObject onlineDyn) {
        QFilter qFilter = new QFilter("org", "=", (Object)onlineDyn.getLong("org_id"));
        qFilter.and(new QFilter("creditno", "=", (Object)onlineDyn.getString("creditno")));
        DynamicObject currency = onlineDyn.getDynamicObject("currencyid");
        if (EmptyUtil.isNoEmpty((DynamicObject)currency)) {
            qFilter.and(new QFilter("currency", "=", onlineDyn.getDynamicObject("currencyid").get("id")));
        }
        qFilter.and(new QFilter("bizdate", "=", (Object)DateUtils.stringToDate((String)onlineDyn.getString("opendate"), (String)"yyyyMMdd")));
        return QueryServiceHelper.queryOne((String)"lc_lettercredit", (String)"id,billstatus", (QFilter[])new QFilter[]{qFilter});
    }

    public static boolean isNumeric(String str) {
        Pattern pattern = Pattern.compile("[0-9]*");
        return pattern.matcher(str).matches();
    }

    public static void validateIsNumeric(BeforeFieldPostBackEvent e, IFormView view) {
        String value = (String)e.getValue();
        if (EmptyUtil.isEmpty((String)value)) {
            return;
        }
        if (!OnlineServiceHelper.isNumeric(value)) {
            e.setCancel(true);
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u51656\u4f4d\u6570\u5b57\u3002", (String)"OnlineServiceHelper_2", (String)"tmc-lc-common", (Object[])new Object[0]));
            view.updateView(e.getKey());
        }
    }

    public static String getCommitBatchSeqId(DynamicObject arrival) {
        DynamicObjectCollection entry = arrival.getDynamicObjectCollection("commitentry");
        Optional<DynamicObject> first = entry.stream().filter(r -> !EmptyUtil.isAnyoneEmpty((Object[])new Object[]{r.getLong("batchseqid"), r.getDate("committime")})).sorted(Comparator.comparing(r -> r.getDate("committime"), Comparator.reverseOrder())).findFirst();
        if (!first.isPresent()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u63d0\u4ea4\u94f6\u4f01\u6279\u6b21\u53f7\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\uff01", (String)"ArrivalCommitDataSource_1", (String)"tmc-lc-business", (Object[])new Object[0]));
        }
        return first.get().getString("batchseqid");
    }
}

