/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.lc.business.opservice.apply;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.entity.property.EntryProp;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.login.actions.SerializationUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.service.metadata.util.GzipUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.lc.common.property.LetterCreditHistoryProp;

public class LetterCreditHistoryDataUpService
extends AbstractTmcBizOppService {
    private static final String[] NO_SAVE_PROPERTYS = new String[]{"feedetail", "multilanguagetext", "entry_gcontract", "entry_surety", "sourcebillid", "modifydate"};
    private static final String[] NO_COPY_PROPERTYS = new String[]{"id", "billhead_lk", "feedetail", "multilanguagetext", "entry_gcontract", "entry_surety", "sourcebillid", "modifydate"};

    public List<String> getSelector() {
        List sic = super.getSelector();
        sic.add("lettercredit");
        return sic;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        Set ids = Arrays.stream(dataEntities).map(s -> s.getDynamicObject("lettercredit").getLong("id")).collect(Collectors.toSet());
        ArrayList<DynamicObject> saveLists = new ArrayList<DynamicObject>(16);
        QFilter qFilter = new QFilter(LetterCreditHistoryProp.SOURCEBILLID, "!=", (Object)0);
        qFilter.and("lettercredit", "in", ids);
        qFilter.and("datasources", "!=", (Object)"up");
        DynamicObject entityObj = TmcDataServiceHelper.newDynamicObject((String)"lc_lettercredit_h");
        ArrayList<String> listProps = new ArrayList<String>(16);
        for (IDataEntityProperty property : entityObj.getDataEntityType().getProperties()) {
            String name = property.getName();
            if (Arrays.asList(NO_SAVE_PROPERTYS).contains(name)) continue;
            listProps.add(name);
            if (!(property instanceof EntryProp)) continue;
            EntryProp p = (EntryProp)property;
            DataEntityPropertyCollection entryProps = p.getDynamicCollectionItemPropertyType().getProperties();
            entryProps.forEach(entryp -> {
                String entryPropName = entryp.getName();
                if (!"multilanguagetext".equals(entryPropName) && !entryPropName.endsWith("_id")) {
                    listProps.add(name + "." + entryp.getName());
                }
            });
        }
        String join = String.join((CharSequence)",", listProps);
        Object[] load = BusinessDataServiceHelper.load((String)"lc_lettercredit_h", (String)join, (QFilter[])qFilter.toArray(), (String)"createtime asc");
        if (EmptyUtil.isNoEmpty((Object[])load)) {
            Map<Object, List<DynamicObject>> map = Arrays.stream(load).collect(Collectors.groupingBy(s -> s.getDynamicObject("lettercredit").getPkValue()));
            for (Map.Entry<Object, List<DynamicObject>> entry : map.entrySet()) {
                List<DynamicObject> values = entry.getValue();
                for (int i = 0; i < values.size(); ++i) {
                    boolean lastHistory;
                    DynamicObject value = values.get(i);
                    long applyid = value.getLong("applyid");
                    Long letterId = value.getDynamicObject("lettercredit").getLong("id");
                    String applyentity = null;
                    String applyNumber = null;
                    String applyReason = null;
                    int seq = i + 1;
                    boolean bl = lastHistory = seq == values.size();
                    if (applyid != 0L) {
                        applyentity = "lc_bizapply";
                        DynamicObject applyInfo = TmcDataServiceHelper.loadSingle((Object)applyid, (String)applyentity, (String)"billno,applyreason");
                        if (EmptyUtil.isNoEmpty((DynamicObject)applyInfo)) {
                            applyNumber = applyInfo.getString("billno");
                            applyReason = applyInfo.getString("applyreason");
                        }
                    }
                    DynamicObject saveData = LetterCreditHistoryDataUpService.addChangeHistory(applyid, applyentity, applyNumber, applyReason, i + 1, lastHistory, value, letterId);
                    value.set("datasources", (Object)"up");
                    saveLists.add(saveData);
                }
            }
        }
        if (EmptyUtil.isNoEmpty(saveLists)) {
            SaveServiceHelper.update((DynamicObject[])load);
            SaveServiceHelper.save((DynamicObject[])saveLists.toArray(new DynamicObject[0]));
        }
    }

    public static DynamicObject addChangeHistory(Long applyId, String applyentity, String applybillno, String applyReason, int seq, boolean lastHistory, DynamicObject historyData, Long letterId) {
        DynamicObject bizInfo = LetterCreditHistoryDataUpService.genBizInfo(letterId, historyData);
        String bizEntityName = "lc_lettercredit";
        DynamicObject changeHistory = TmcDataServiceHelper.newDynamicObject((String)"fcs_changehistory");
        changeHistory.set("applyid", (Object)applyId);
        changeHistory.set("applyentity", (Object)applyentity);
        changeHistory.set("applybillno", (Object)applybillno);
        changeHistory.set("bizid", (Object)letterId);
        changeHistory.set("bizentity", (Object)bizEntityName);
        changeHistory.set("reason", (Object)applyReason);
        if (applyentity != null && !bizEntityName.equals(applyentity)) {
            changeHistory.set("applycreate", (Object)true);
        }
        String serialize = SerializationUtils.serializeToBase64((Object)bizInfo);
        try {
            changeHistory.set("billinfo_tag", (Object)GzipUtils.compress((String)serialize, (String)"UTF-8"));
        }
        catch (IOException e) {
            throw new KDBizException(e.getMessage());
        }
        changeHistory.set("version", (Object)historyData.getString("version"));
        changeHistory.set("seqnumber", (Object)seq);
        changeHistory.set("creator", (Object)1);
        changeHistory.set("lastversion", (Object)lastHistory);
        return changeHistory;
    }

    private static DynamicObject genBizInfo(Long letterId, DynamicObject historyData) {
        DynamicObject bizInfo = TmcDataServiceHelper.newDynamicObject((String)"lc_lettercredit");
        DataEntityPropertyCollection applyProperties = historyData.getDataEntityType().getProperties();
        for (IDataEntityProperty property : applyProperties) {
            String prop = property.getName();
            DataEntityPropertyCollection properties = bizInfo.getDataEntityType().getProperties();
            if (!properties.containsKey((Object)prop) || Arrays.asList(NO_COPY_PROPERTYS).contains(prop)) continue;
            Object value = historyData.get(prop);
            if (value instanceof DynamicObjectCollection) {
                LetterCreditHistoryDataUpService.setEntryInfo(historyData, bizInfo, prop);
            }
            bizInfo.set(prop, value);
        }
        bizInfo.set("id", (Object)letterId);
        return bizInfo;
    }

    private static void setEntryInfo(DynamicObject historyData, DynamicObject bizInfo, String prop) {
        bizInfo.getDynamicObjectCollection(prop).clear();
        for (DynamicObject entry_a : historyData.getDynamicObjectCollection(prop)) {
            DynamicObject entry_l = bizInfo.getDynamicObjectCollection(prop).addNew();
            for (IDataEntityProperty property : entry_a.getDataEntityType().getProperties()) {
                String name = property.getName();
                if (!entry_l.getDataEntityType().getProperties().containsKey((Object)name)) continue;
                entry_l.set(property, entry_a.get(property));
            }
            entry_l.set("id", entry_a.get("id"));
        }
    }
}

