/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.lc.business.opservice.arrival;

import com.alibaba.fastjson.JSONArray;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.AttDto;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcBotpHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.webapi.ebentity.biz.arrival.FileListResponseDetail;
import kd.tmc.lc.common.enums.DataSourceEnum;
import kd.tmc.lc.common.enums.TradeChannelEnum;

public class ArrivalBillRegisterService
extends AbstractTmcBizOppService {
    private static final Log LOG = LogFactory.getLog(ArrivalBillRegisterService.class);
    private Map<String, String> arri2OnlineMap = new HashMap<String, String>(8);
    private List<Object> arrivalIdList = new ArrayList<Object>(8);

    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("receivedno");
        selector.add("creditno");
        selector.add("fbankname");
        selector.add("fbankcnapscode");
        selector.add("amount");
        selector.add("batchno");
        selector.add("isregister");
        selector.add("duedate");
        selector.add("remitamount");
        selector.add("receivedflag");
        selector.add("filelist_tag");
        selector.add("filelistres_tag");
        selector.add("lcbillno");
        return selector;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        int length = dataEntities.length;
        ArrayList<DynamicObject> curBillList = new ArrayList<DynamicObject>(length);
        ArrayList<DynamicObject> arrBillList = new ArrayList<DynamicObject>(length);
        ArrayList<DynamicObject> arrUpdateList = new ArrayList<DynamicObject>(length);
        ArrayList<Long> saveUpdateList = new ArrayList<Long>(length);
        ArrayList<Long> submitUpdateList = new ArrayList<Long>(length);
        for (DynamicObject arrOnline : dataEntities) {
            String arrivalNo = arrOnline.getString("receivedno");
            QFilter qFilter = new QFilter("arrivalno", "=", (Object)arrivalNo);
            List arrivalIds = QueryServiceHelper.queryPrimaryKeys((String)"lc_arrival", (QFilter[])new QFilter[]{qFilter}, (String)"", (int)-1);
            if (EmptyUtil.isEmpty((Collection)arrivalIds)) {
                QFilter lcQfilter = new QFilter("creditno", "=", (Object)arrOnline.getString("creditno"));
                lcQfilter.and(new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()));
                List lcIds = QueryServiceHelper.queryPrimaryKeys((String)"lc_lettercredit", (QFilter[])new QFilter[]{lcQfilter}, (String)"", (int)-1);
                DynamicObject[] arrivalBills = TmcBotpHelper.batchPush((Object[])lcIds.toArray(), (String)"lc_lettercredit", (String)"lc_arrival");
                DynamicObject arrivalBill = arrivalBills[0];
                String billNo = arrivalBill.getString("billno");
                if (EmptyUtil.isEmpty((String)billNo)) {
                    billNo = CodeRuleServiceHelper.getNumber((String)"lc_arrival", (DynamicObject)arrivalBill, (String)arrivalBill.getDynamicObject("org").getString("id"));
                    arrivalBill.set("billno", (Object)billNo);
                }
                arrivalBill.set("arrivalno", (Object)arrivalNo);
                arrivalBill.set("tradechannel", (Object)TradeChannelEnum.ONLINE.getValue());
                arrivalBill.set("frombankname", (Object)arrOnline.getString("fbankname"));
                arrivalBill.set("frombankno", (Object)arrOnline.getString("fbankcnapscode"));
                arrivalBill.set("imagebatchno", (Object)arrOnline.getString("batchno"));
                arrivalBill.set("datasource", (Object)DataSourceEnum.BANK.getValue());
                arrivalBill.set("arrivalamount", (Object)arrOnline.getString("remitamount"));
                arrivalBill.set("todoamount", (Object)arrOnline.getString("remitamount"));
                arrivalBill.set("invoiceamt", (Object)arrOnline.getString("amount"));
                arrivalBill.set("receivedflag", (Object)arrOnline.getString("receivedflag"));
                String dueDate = arrOnline.getString("duedate");
                if (EmptyUtil.isNoEmpty((String)dueDate)) {
                    Date lastPayDate = DateUtils.stringToDate((String)dueDate, (String)"yyyyMMdd");
                    arrivalBill.set("endpaydate", (Object)lastPayDate);
                }
                this.dealFileList(arrOnline, this.arri2OnlineMap);
                arrOnline.set("lcbillno", (Object)arrivalBill.getString("billno"));
                arrBillList.add(arrivalBill);
            } else {
                DynamicObject dbArrival = TmcDataServiceHelper.loadSingle(arrivalIds.get(0), (String)"lc_arrival");
                dbArrival.set("frombankname", (Object)arrOnline.getString("fbankname"));
                dbArrival.set("frombankno", (Object)arrOnline.getString("fbankcnapscode"));
                dbArrival.set("imagebatchno", (Object)arrOnline.getString("batchno"));
                dbArrival.set("datasource", (Object)DataSourceEnum.BANK.getValue());
                dbArrival.set("tradechannel", (Object)TradeChannelEnum.ONLINE.getValue());
                dbArrival.set("arrivalamount", (Object)arrOnline.getString("remitamount"));
                dbArrival.set("todoamount", (Object)arrOnline.getString("remitamount"));
                dbArrival.set("invoiceamt", (Object)arrOnline.getString("amount"));
                arrUpdateList.add(dbArrival);
                String billStatus = dbArrival.getString("billstatus");
                if (BillStatusEnum.isSave((String)billStatus)) {
                    saveUpdateList.add(dbArrival.getLong("id"));
                } else if (BillStatusEnum.isSubmit((String)billStatus)) {
                    submitUpdateList.add(dbArrival.getLong("id"));
                }
                arrOnline.set("lcbillno", (Object)dbArrival.getString("billno"));
            }
            arrOnline.set("isregister", (Object)Boolean.TRUE);
            curBillList.add(arrOnline);
        }
        if (EmptyUtil.isNoEmpty(arrBillList)) {
            OperateOption option = OperateOption.create();
            OperationResult saveResult = TmcOperateServiceHelper.execOperate((String)"save", (String)"lc_arrival", (DynamicObject[])arrBillList.toArray(new DynamicObject[0]), (OperateOption)option);
            Object[] arrivalIds = saveResult.getSuccessPkIds().toArray();
            if (EmptyUtil.isNoEmpty((Object[])arrivalIds)) {
                option.setVariableValue("WF", "TRUE");
                TmcOperateServiceHelper.execOperate((String)"submit", (String)"lc_arrival", (Object[])arrivalIds, (OperateOption)option);
                TmcOperateServiceHelper.execOperate((String)"audit", (String)"lc_arrival", (Object[])arrivalIds, (OperateOption)option);
                Arrays.stream(arrivalIds).forEach(r -> this.arrivalIdList.add(r));
            }
        }
        if (EmptyUtil.isNoEmpty(arrUpdateList)) {
            SaveServiceHelper.update((DynamicObject[])arrUpdateList.toArray(new DynamicObject[0]));
        }
        if (EmptyUtil.isNoEmpty(curBillList)) {
            SaveServiceHelper.update((DynamicObject[])curBillList.toArray(new DynamicObject[0]));
        }
        this.updateExistsBillStatus(saveUpdateList, submitUpdateList);
    }

    public void afterProcess(DynamicObject[] dataEntities) throws KDException {
        this.bindFileToAttachment(this.arri2OnlineMap, this.arrivalIdList);
    }

    private void dealFileList(DynamicObject arrOnline, Map<String, String> map) {
        if (EmptyUtil.isEmpty((String)arrOnline.getString("filelist_tag"))) {
            return;
        }
        String fileRes = arrOnline.getString("filelistres_tag");
        if (EmptyUtil.isEmpty((String)fileRes)) {
            return;
        }
        map.put(arrOnline.getString("receivedno"), fileRes);
    }

    private void bindFileToAttachment(Map<String, String> map, List<Object> arrivalIdList) {
        if (map.isEmpty()) {
            return;
        }
        if (EmptyUtil.isEmpty(arrivalIdList)) {
            return;
        }
        DynamicObjectCollection cols = QueryServiceHelper.query((String)"lc_arrival", (String)"id,arrivalno", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)arrivalIdList.toArray())});
        Map<String, Long> no2IdMap = cols.stream().collect(Collectors.toMap(r -> r.getString("arrivalno"), r -> r.getLong("id")));
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String arrivalNo = entry.getKey();
            List fileResList = JSONArray.parseArray((String)entry.getValue(), FileListResponseDetail.class);
            ArrayList<AttDto> attDtoList = new ArrayList<AttDto>(fileResList.size());
            for (FileListResponseDetail perFile : fileResList) {
                AttDto attDto = new AttDto();
                String filePath = perFile.getFilePath();
                if (!filePath.endsWith("/")) {
                    filePath = filePath + "/";
                }
                filePath = filePath + perFile.getFileName();
                attDto.setPath(filePath);
                attDto.setAttKey("attachmentpanel");
                try {
                    Long fileSize = perFile.getFileSize();
                    if (EmptyUtil.isEmpty((Long)fileSize)) {
                        fileSize = AttachmentServiceHelper.getFileSizeByPath((String)attDto.getPath());
                    }
                    attDto.setSize(fileSize);
                }
                catch (Exception e) {
                    LOG.error("Calc File Size Error");
                    LOG.error(e.getMessage(), (Throwable)e);
                }
                attDtoList.add(attDto);
            }
            TXHandle h = TX.requiresNew();
            Throwable throwable = null;
            try {
                try {
                    Map bindingParam = AttachmentServiceHelper.genBindingParam((String)"lc_arrival", (String)String.valueOf(no2IdMap.get(arrivalNo)), attDtoList);
                    Map resultMap = AttachmentServiceHelper.bindingAttachment((Map)bindingParam);
                    LOG.info("File Bind Bill Status\uff1a{}", resultMap.get("success"));
                }
                catch (Throwable e) {
                    h.markRollback();
                    LOG.error("File Upload Error");
                    LOG.error(e.getMessage(), e);
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (h == null) continue;
                if (throwable != null) {
                    try {
                        h.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                h.close();
            }
        }
    }

    private void updateExistsBillStatus(List<Long> saveUpdateList, List<Long> submitUpdateList) {
        OperateOption option = OperateOption.create();
        if (EmptyUtil.isNoEmpty(saveUpdateList)) {
            option.setVariableValue("WF", "TRUE");
            TmcOperateServiceHelper.execOperate((String)"submit", (String)"lc_arrival", (Object[])saveUpdateList.toArray(), (OperateOption)option);
            TmcOperateServiceHelper.execOperate((String)"audit", (String)"lc_arrival", (Object[])saveUpdateList.toArray(), (OperateOption)option);
        }
        if (EmptyUtil.isNoEmpty(submitUpdateList)) {
            TmcOperateServiceHelper.execOperate((String)"audit", (String)"lc_arrival", (Object[])submitUpdateList.toArray(), (OperateOption)option);
        }
    }
}

