/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.lc.business.opservice.config;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.KDException;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.helper.CreditLimitServiceHelper;
import kd.tmc.fbp.common.helper.GuaranteeUseHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.model.guaranteeuse.GuaranteeUseReturnBean;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.lc.common.enums.ArrivalStatusEnum;
import kd.tmc.lc.common.enums.ArrivalTypeEnum;
import kd.tmc.lc.common.helper.LetterCreditHelper;

public class PayConfigConfirmService
extends AbstractTmcBizOppService {
    public List<String> getSelector() {
        List sic = super.getSelector();
        sic.add("id");
        sic.add("realpaydate");
        sic.add("paycurrency");
        sic.add("payamount");
        sic.add("exchangerate");
        sic.add("payremark");
        sic.add("arrpayamount");
        sic.add("isdiffcur");
        return sic;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        ArrayList<GuaranteeUseReturnBean> returnList = new ArrayList<GuaranteeUseReturnBean>(8);
        for (DynamicObject data : dataEntities) {
            DynamicObject arrivalBill = TmcDataServiceHelper.loadSingle((Object)data.getLong("id"), (String)"lc_arrival");
            boolean isDiffcur = data.getBoolean("isdiffcur");
            DynamicObjectCollection entrys = arrivalBill.getDynamicObjectCollection("entrys");
            BigDecimal arrPayAmount = data.getBigDecimal("arrpayamount");
            int seq = entrys.stream().map(s -> s.getInt("seq")).reduce(Integer::max).orElse(0);
            DynamicObject creatEntry = entrys.addNew();
            creatEntry.set("seq", (Object)(seq + 1));
            creatEntry.set("arrpayamount", (Object)arrPayAmount);
            creatEntry.set("realpaydate", data.get("realpaydate"));
            creatEntry.set("isdiffcur", (Object)isDiffcur);
            creatEntry.set("payremark", data.get("payremark"));
            creatEntry.set("arrpaycurrency", data.get("arrivalcurrency"));
            if (isDiffcur) {
                creatEntry.set("paycurrency", data.get("paycurrency"));
                creatEntry.set("payamount", data.get("payamount"));
                creatEntry.set("exchangerate", data.get("exchangerate"));
            }
            arrivalBill.set("doneamount", (Object)arrivalBill.getBigDecimal("doneamount").add(arrPayAmount));
            BigDecimal calTodoAmt = arrivalBill.getBigDecimal("todoamount").subtract(arrPayAmount);
            arrivalBill.set("todoamount", (Object)calTodoAmt);
            if (BigDecimal.ZERO.compareTo(calTodoAmt) == 0) {
                arrivalBill.set("arrivalstatus", (Object)ArrivalStatusEnum.ARRIVAL_PAY.getValue());
            }
            arrivalBill.set("ispayconfig", (Object)"1");
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{arrivalBill});
            String arrivalType = arrivalBill.getString("arrivaltype");
            if (ArrivalTypeEnum.CREDIT.getValue().equals(arrivalType)) {
                DynamicObject credit = TmcDataServiceHelper.loadSingle((Object)arrivalBill.getDynamicObject("lettercredit").getPkValue(), (String)"lc_lettercredit");
                if (EmptyUtil.isNoEmpty((DynamicObject)credit.getDynamicObject("creditlimit"))) {
                    boolean isPayAll = LetterCreditHelper.checkPayamount((DynamicObject)credit, (BigDecimal)BigDecimal.ZERO);
                    CreditLimitServiceHelper.returnCreditLimit((DynamicObject)arrivalBill, (DynamicObject)credit, (boolean)false, (BigDecimal)arrPayAmount, (Long)((Long)creatEntry.getPkValue()), (boolean)isPayAll, (Date)data.getDate("realpaydate"));
                }
                if (credit.getBoolean("isclosed")) {
                    credit.set("isclosed", (Object)Boolean.FALSE);
                    SaveServiceHelper.update((DynamicObject[])new DynamicObject[]{credit});
                }
            }
            if (!EmptyUtil.isNoEmpty((DynamicObject)arrivalBill.getDynamicObject("lettercredit"))) continue;
            GuaranteeUseReturnBean returnContractBean = new GuaranteeUseReturnBean();
            returnContractBean.setBizBillId(Long.valueOf(arrivalBill.getDynamicObject("lettercredit").getLong("id")));
            returnContractBean.setReturnBillId(Long.valueOf(data.getLong("id")));
            returnContractBean.setReturnBillType(data.getDataEntityType().getName());
            returnContractBean.setReturnAmount(arrivalBill.getBigDecimal("doneamount"));
            returnList.add(returnContractBean);
        }
        GuaranteeUseHelper.returnGuaranteeUse(returnList);
    }
}

