/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.lc.business.opservice.ebservice.api;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.tmc.fbp.common.errorcode.TmcErrorCode;
import kd.tmc.fbp.common.helper.MutexServiceHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.service.ebservice.bean.SyncStatusResult;
import kd.tmc.fbp.service.ebservice.data.EBResult;
import kd.tmc.fbp.service.ebservice.data.EBResultStatusCode;
import kd.tmc.fbp.service.ebservice.data.PageQueryCreditResult;
import kd.tmc.fbp.service.ebservice.service.IEBService;
import kd.tmc.fbp.service.ebservice.service.IEBServiceExecutor;
import kd.tmc.lc.business.opservice.ebservice.api.IEBServiceFacade;
import kd.tmc.lc.business.opservice.ebservice.service.EBOnlineServiceFactory;
import kd.tmc.lc.business.opservice.ebservice.service.EBServiceExecutorFactory;

public class EBServiceFacadeImpl
implements IEBServiceFacade {
    private static final String OP_PAY = "pay";
    private static final Log logger = LogFactory.getLog(EBServiceFacadeImpl.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<SyncStatusResult> commit(String bussinessKey, String entityName, List<Long> billIdList) {
        SyncStatusResult resultList = new ArrayList();
        ArrayList<String> requestIds = new ArrayList<String>();
        ArrayList<Long> requestFailIds = new ArrayList<Long>();
        List idList = billIdList.stream().map(String::valueOf).collect(Collectors.toList());
        Map request = MutexServiceHelper.batchRequest(idList, (String)entityName, (String)OP_PAY);
        try {
            List<Object> requestDatas;
            SyncStatusResult result;
            for (Map.Entry entry : request.entrySet()) {
                String key = (String)entry.getKey();
                if (((Boolean)entry.getValue()).booleanValue()) {
                    requestIds.add(key);
                    continue;
                }
                requestFailIds.add(Long.valueOf(key));
            }
            if (requestFailIds.size() > 0) {
                DynamicObject[] failDataArr = BusinessDataServiceHelper.load((Object[])requestFailIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)entityName));
                TmcErrorCode tmcErrorCode = new TmcErrorCode();
                for (DynamicObject data : failDataArr) {
                    result = new SyncStatusResult();
                    result.setBankBillId(Long.valueOf(data.getLong("id")));
                    result.setStatusCode(EBResultStatusCode.ERROR);
                    result.setErrMsg(tmcErrorCode.BILL_MUTEX_LOCK_WITH_NUMBER(data.getString("billno")).getMessage());
                    resultList.add(result);
                }
            }
            if (CollectionUtils.isEmpty(requestDatas = billIdList.stream().filter(bankBillId -> requestIds.contains(String.valueOf(bankBillId))).collect(Collectors.toList()))) {
                result = resultList;
                return result;
            }
            try {
                DynamicObject[] billArr;
                for (DynamicObject bussinessBill : billArr = TmcDataServiceHelper.load((Object[])requestDatas.toArray(new Object[0]), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)entityName))) {
                    IEBService<SyncStatusResult> service = EBOnlineServiceFactory.getOnlineService(bussinessKey, bussinessBill);
                    IEBServiceExecutor ebServiceExecutor = EBServiceExecutorFactory.getEBServiceExecutor();
                    SyncStatusResult ebResult = (SyncStatusResult)ebServiceExecutor.execute(service);
                    resultList.add(ebResult);
                }
            }
            catch (Exception e) {
                logger.error((Throwable)e);
                SyncStatusResult result2 = new SyncStatusResult();
                result2.setStatusCode(EBResultStatusCode.ERROR);
                result2.setErrMsg(e.getMessage());
                resultList.add(result2);
            }
        }
        finally {
            MutexServiceHelper.batchRelease(requestIds, (String)entityName, (String)OP_PAY);
        }
        return resultList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<EBResult> queryBankDealResult(String bussinessKey, String entityName, List<Long> billIdList) {
        EBResult resultList = new ArrayList();
        ArrayList<String> requestIds = new ArrayList<String>();
        ArrayList<Long> requestFailIds = new ArrayList<Long>();
        List idList = billIdList.stream().map(String::valueOf).collect(Collectors.toList());
        Map request = MutexServiceHelper.batchRequest(idList, (String)entityName, (String)OP_PAY);
        try {
            List<Object> requestDatas;
            EBResult result;
            for (Map.Entry entry : request.entrySet()) {
                String key = (String)entry.getKey();
                if (((Boolean)entry.getValue()).booleanValue()) {
                    requestIds.add(key);
                    continue;
                }
                requestFailIds.add(Long.valueOf(key));
            }
            if (requestFailIds.size() > 0) {
                DynamicObject[] failDataArr = BusinessDataServiceHelper.load((Object[])requestFailIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)entityName));
                EBResult ebResult = new EBResult();
                TmcErrorCode tmcErrorCode = new TmcErrorCode();
                for (DynamicObject data : failDataArr) {
                    ebResult.setStatusCode(EBResultStatusCode.ERROR);
                    ebResult.setErrMsg(tmcErrorCode.BILL_MUTEX_LOCK_WITH_NUMBER(data.getString("billno")).getMessage());
                    result = ebResult;
                    result.setBankBillId(Long.valueOf(data.getLong("id")));
                    resultList.add(result);
                }
            }
            if (CollectionUtils.isEmpty(requestDatas = billIdList.stream().filter(bankBillId -> requestIds.contains(String.valueOf(bankBillId))).collect(Collectors.toList()))) {
                result = resultList;
                return result;
            }
            try {
                DynamicObject[] billArr;
                for (DynamicObject bussinessBill : billArr = TmcDataServiceHelper.load((Object[])requestDatas.toArray(new Object[0]), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)entityName))) {
                    IEBService<EBResult> service = EBOnlineServiceFactory.getQueryService(bussinessKey, bussinessBill);
                    IEBServiceExecutor ebServiceExecutor = EBServiceExecutorFactory.getEBServiceExecutor();
                    EBResult result2 = (EBResult)ebServiceExecutor.execute(service);
                    resultList.add(result2);
                }
            }
            catch (Exception e) {
                logger.error((Throwable)e);
                EBResult result3 = new EBResult(EBResultStatusCode.ERROR, e.getMessage());
                resultList.add((EBResult)result3);
            }
        }
        finally {
            MutexServiceHelper.batchRelease(requestIds, (String)entityName, (String)OP_PAY);
        }
        return resultList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<EBResult> updateStatus(String bussinessKey, String reason, DynamicObject bussBill) {
        ArrayList<EBResult> resultList;
        block6: {
            logger.info("directUpdateIdList:" + bussBill);
            resultList = new ArrayList<EBResult>();
            List requestIds = new ArrayList();
            ArrayList errors = new ArrayList();
            ArrayList<String> idList = new ArrayList<String>();
            idList.add(bussBill.getPkValue().toString());
            String entityName = bussBill.getDataEntityType().getName();
            Map request = MutexServiceHelper.batchRequest(idList, (String)entityName, (String)OP_PAY);
            try {
                requestIds = MutexServiceHelper.getRequestResultList((DynamicObject[])new DynamicObject[]{bussBill}, errors, (Map)request);
                try {
                    EBResult ebResult = new EBResult();
                    TmcErrorCode tmcErrorCode = new TmcErrorCode();
                    if (requestIds.contains(bussBill.getString("id"))) {
                        IEBService<EBResult> service = EBOnlineServiceFactory.getUpdateStatusService(bussinessKey, reason, bussBill);
                        IEBServiceExecutor ebServiceExecutor = EBServiceExecutorFactory.getEBServiceExecutor();
                        EBResult result = (EBResult)ebServiceExecutor.execute(service);
                        resultList.add(result);
                        break block6;
                    }
                    ebResult.setStatusCode(EBResultStatusCode.ERROR);
                    ebResult.setErrMsg(tmcErrorCode.BILL_MUTEX_LOCK_WITH_NUMBER(bussBill.getString("billno")).getMessage());
                    EBResult result = ebResult;
                    result.setBankBillId(Long.valueOf(bussBill.getLong("id")));
                    resultList.add(result);
                }
                catch (Exception e) {
                    logger.error((Throwable)e);
                    EBResult result = new EBResult(EBResultStatusCode.ERROR, e.getMessage());
                    resultList.add(result);
                }
            }
            finally {
                MutexServiceHelper.batchRelease(requestIds, (String)entityName, (String)OP_PAY);
            }
        }
        return resultList;
    }

    @Override
    public PageQueryCreditResult queryBankInfos(String entityName, Map paraMap) {
        IEBService<PageQueryCreditResult> service = EBOnlineServiceFactory.getOnlineService(entityName, paraMap);
        IEBServiceExecutor ebServiceExecutor = EBServiceExecutorFactory.getEBServiceExecutor();
        PageQueryCreditResult result = (PageQueryCreditResult)ebServiceExecutor.execute(service);
        return result;
    }
}

