/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.lc.business.opservice.ebservice.request;

import java.util.Map;
import kd.bos.context.RequestContext;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.webapi.ebentity.EBHeader;
import kd.tmc.fbp.webapi.ebentity.EBRequest;
import kd.tmc.fbp.webapi.ebentity.biz.arrival.QueryCreditReceivedBody;
import kd.tmc.fbp.webapi.ebentity.biz.arrival.QueryCreditReceivedRequest;
import kd.tmc.lc.business.opservice.ebservice.request.AbstractRequestBuilder;
import kd.tmc.lc.business.opservice.ebservice.request.datasource.IEBRequestDataSource;
import kd.tmc.lc.business.opservice.ebservice.request.datasource.arrival.QueryCreditReceivedDataSource;

public class QueryCreditReceivedRequestBuilder
extends AbstractRequestBuilder {
    private final String bizType;
    private final String subBizType;

    public QueryCreditReceivedRequestBuilder(IEBRequestDataSource dataSource, String bizType, String subBizType) {
        super(dataSource);
        this.bizType = bizType;
        this.subBizType = subBizType;
    }

    public EBRequest buildRequest() {
        QueryCreditReceivedRequest request = new QueryCreditReceivedRequest();
        request.setHeader(this.buildHeader());
        request.setBody(this.buildBody());
        return request;
    }

    @Override
    protected EBHeader buildHeader() {
        EBHeader header = super.buildHeader();
        header.setBizType(this.bizType);
        header.setSubBizType(this.subBizType);
        header.setOperatorId(RequestContext.get().getUserId());
        return header;
    }

    private QueryCreditReceivedBody buildBody() {
        QueryCreditReceivedBody body = new QueryCreditReceivedBody();
        QueryCreditReceivedDataSource dataSource = (QueryCreditReceivedDataSource)this.getDataSource();
        Map queryCredit = dataSource.getQueryArrival();
        body.setBatchSeqId(dataSource.getBatchSeqId());
        body.setApplicantCreditNum((String)queryCredit.get("applicantcreditnum"));
        body.setStartDate((String)queryCredit.get("startdate"));
        body.setEndDate((String)queryCredit.get("enddate"));
        body.setPageNum((String)queryCredit.get("pageNum"));
        String creditNo = (String)queryCredit.get("creditno");
        if (EmptyUtil.isNoEmpty((String)creditNo)) {
            body.setCreditNo(creditNo);
        }
        return body;
    }
}

