/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.lc.business.opservice.ebservice.service.arrival;

import java.util.Collections;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.common.log.PayLogger;
import kd.tmc.fbp.common.log.builder.PayTraceLogBankBillBuilder;
import kd.tmc.fbp.common.log.enums.PayLogLevelEnum;
import kd.tmc.fbp.common.log.enums.PayTraceLogStepEmum;
import kd.tmc.fbp.service.ebservice.bean.SyncStatusResult;
import kd.tmc.fbp.service.ebservice.data.EBResultStatusCode;
import kd.tmc.fbp.service.ebservice.log.BankLogInfo;
import kd.tmc.fbp.service.ebservice.request.IEBRequestBuilder;
import kd.tmc.fbp.service.ebservice.service.IEBService;
import kd.tmc.lc.business.opservice.ebservice.request.ArrivalCommitRequestBuilder;
import kd.tmc.lc.business.opservice.ebservice.request.datasource.arrival.ArrivalCommitDataSource;
import kd.tmc.lc.business.opservice.ebservice.service.lettercredit.OpenCreditService;
import kd.tmc.lc.common.helper.OnlineServiceHelper;

public abstract class AbstractArrivalCommitService
implements IEBService<SyncStatusResult> {
    private final DynamicObject arrival;
    private SyncStatusResult ebResult;
    private static final PayLogger traceLogger = PayLogger.create(OpenCreditService.class);

    public AbstractArrivalCommitService(DynamicObject arrival) {
        this.arrival = arrival;
        this.ebResult = new SyncStatusResult();
    }

    public DynamicObject getArrival() {
        return this.arrival;
    }

    public boolean validate() {
        return true;
    }

    public void beforeRequest() {
    }

    public void handleResultBody(String resultBody) {
        OnlineServiceHelper.dealOnlineArrival((String)resultBody, (DynamicObject)this.arrival, (String)this.getSubBizType());
        this.ebResult.setStatusCode(EBResultStatusCode.SUCCESS);
    }

    public void rollback(String errMsg, Exception e) {
        this.ebResult.setStatusCode(EBResultStatusCode.ROLLBACK);
        this.ebResult.setErrMsg(errMsg);
        this.ebResult.setBankBillId(Long.valueOf(this.arrival.getLong("id")));
        try (TXHandle tx = TX.requiresNew();){
            this.dealRollBack(this.arrival);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{this.arrival});
        }
    }

    public void handleEBException(String resultBody, String errMsg, Exception e) {
        traceLogger.logBatch(new PayTraceLogBankBillBuilder(Collections.singletonList(this.getArrival()), PayLogLevelEnum.INFO.getValue(), PayTraceLogStepEmum.PAY.getValue(), "Deal Exception Message", resultBody, e).build());
        this.ebResult.setStatusCode(EBResultStatusCode.ERROR);
        this.ebResult.setErrMsg(errMsg);
        this.ebResult.setBankBillId(Long.valueOf(this.arrival.getLong("id")));
        try (TXHandle tx = TX.requiresNew();){
            this.dealException(this.arrival);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{this.arrival});
        }
    }

    public IEBRequestBuilder getRequestBuilder() {
        ArrivalCommitDataSource dataSource = new ArrivalCommitDataSource(this.arrival, this.getSubBizType());
        return new ArrivalCommitRequestBuilder(dataSource, "openCredit", this.getSubBizType());
    }

    public String getEntityName() {
        return this.arrival.getDynamicObjectType().getName();
    }

    public BankLogInfo getBankLogInfo() {
        BankLogInfo logInfo = new BankLogInfo();
        logInfo.setSourceId(Long.valueOf(this.arrival.getLong("id")));
        logInfo.setBillNo(this.arrival.getString("billno"));
        logInfo.setEntityName(this.getEntityName());
        logInfo.setOrgid((Long)this.arrival.getDynamicObject("org").getPkValue());
        return logInfo;
    }

    public SyncStatusResult getEBResult() {
        return this.ebResult;
    }

    public Long getBankCateId() {
        return Optional.ofNullable(this.arrival.getDynamicObject("arrivalbank")).map(r -> r.getDynamicObject("bank_cate")).map(r -> r.getLong("id")).orElse(0L);
    }

    protected abstract String getSubBizType();

    protected abstract void dealRollBack(DynamicObject var1);

    protected abstract void dealException(DynamicObject var1);
}

