/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.lc.business.opservice.ebservice.service.arrival;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.service.ebservice.data.EBResultStatusCode;
import kd.tmc.fbp.service.ebservice.data.PageQueryCreditResult;
import kd.tmc.fbp.service.ebservice.log.BankLogInfo;
import kd.tmc.fbp.service.ebservice.request.IEBRequestBuilder;
import kd.tmc.fbp.service.ebservice.service.IEBService;
import kd.tmc.fbp.webapi.ebentity.biz.arrival.QueryCreditReceivedReponseBody;
import kd.tmc.fbp.webapi.ebentity.biz.arrival.QueryCreditReceivedReponseDetail;
import kd.tmc.lc.business.opservice.ebservice.request.QueryCreditReceivedRequestBuilder;
import kd.tmc.lc.business.opservice.ebservice.request.datasource.arrival.QueryCreditReceivedDataSource;
import kd.tmc.lc.common.helper.OnlineServiceHelper;

public class QueryCreditReceivedService
implements IEBService<PageQueryCreditResult> {
    private Map paraMap;
    private PageQueryCreditResult ebResult;
    private static final Log LOG = LogFactory.getLog(QueryCreditReceivedService.class);

    public QueryCreditReceivedService(Map paraMap) {
        this.paraMap = paraMap;
        this.ebResult = new PageQueryCreditResult();
    }

    public boolean validate() {
        return true;
    }

    public void beforeRequest() {
    }

    public void rollback(String errMsg, Exception e) {
    }

    public void handleEBException(String resultBody, String errMsg, Exception e) {
        this.ebResult.setStatusCode(EBResultStatusCode.ERROR);
        this.ebResult.setKeepFlag("1");
        LOG.info("\u672c\u6279\u6b21\u4ece\u94f6\u884c\u540c\u6b65\u6570\u636e\u5f02\u5e38\uff0c\u5f02\u5e38\u4fe1\u606f\uff1a{}", (Object)errMsg);
        JSONObject bodyJson = JSON.parseObject((String)resultBody);
        String msg = ResManager.loadKDString((String)"\u5728\u7ebf\u83b7\u53d6\u4fe1\u7528\u8bc1\u4fe1\u606f\u65f6\uff0c\u94f6\u4f01\u8fd4\u56de\u7684\u660e\u7ec6\u4e3a\u7a7a\uff01\u8be6\u60c5\u8bf7\u67e5\u770b\u540c\u6b65\u65e5\u5fd7\u3002", (String)"QueryCreditService_0", (String)"tmc-lc-business", (Object[])new Object[0]);
        if (EmptyUtil.isEmpty((Object)bodyJson)) {
            throw new KDBizException(msg);
        }
        String detailStr = JSONObject.toJSONString((Object)bodyJson.get((Object)"receivedCredits"));
        List detailList = JSONObject.parseArray((String)detailStr, JSONObject.class);
        if (EmptyUtil.isEmpty((Collection)detailList)) {
            throw new KDBizException(msg);
        }
    }

    public void handleResultBody(String resultBody) {
        Date startDate;
        List<QueryCreditReceivedReponseDetail> detailList = this.getQueryCreReceResponseDetails(resultBody);
        if (EmptyUtil.isEmpty(detailList)) {
            return;
        }
        LOG.info("\u672c\u6279\u6b21\u4ece\u94f6\u884c\u62c9\u56de\u6570\u636e{}\u6761", (Object)detailList.size());
        Map<String, Long> currencyNumToIdMap = this.turnCurrencyNumToId(detailList);
        ArrayList<DynamicObject> arrQueryResultList = new ArrayList<DynamicObject>(detailList.size());
        Long orgId = Optional.ofNullable((String)this.paraMap.get("org")).filter(r -> EmptyUtil.isNoEmpty((String)r)).map(r -> Long.valueOf(r)).orElse(0L);
        LOG.info("\u672c\u6279\u6b21\u5904\u7406\u7ec4\u7ec7id={}", (Object)orgId);
        QFilter qFilter = new QFilter("org", "=", (Object)orgId);
        Long bankType = Optional.ofNullable((String)this.paraMap.get("bank")).filter(r -> EmptyUtil.isNoEmpty((String)r)).map(r -> Long.valueOf(r)).orElse(0L);
        qFilter.and(new QFilter("banktype", "=", (Object)bankType));
        String creditNo = (String)this.paraMap.get("creditno");
        if (EmptyUtil.isNoEmpty((String)creditNo)) {
            qFilter.and(new QFilter("creditno", "=", (Object)creditNo));
        }
        if (OnlineServiceHelper.CCB_BANKTYPE.equals(bankType)) {
            startDate = DateUtils.stringToDate((String)((String)this.paraMap.get("startdate")), (String)"yyyyMMdd");
            qFilter.and(new QFilter("bizdate", "=", (Object)startDate));
        } else {
            startDate = DateUtils.stringToDate((String)((String)this.paraMap.get("startdate")), (String)"yyyyMMdd");
            qFilter.and(new QFilter("bizdate", ">=", (Object)startDate));
            Date enddate = DateUtils.stringToDate((String)((String)this.paraMap.get("enddate")), (String)"yyyyMMdd");
            qFilter.and(new QFilter("bizdate", "<=", (Object)enddate));
        }
        DeleteServiceHelper.delete((String)"lc_arronlineresult", (QFilter[])qFilter.toArray());
        Map<String, String> lcBillNoMap = this.getDbLcBillNo(detailList, orgId, bankType);
        for (QueryCreditReceivedReponseDetail detail : detailList) {
            this.buildOnlineResultMapping(currencyNumToIdMap, detail, arrQueryResultList, lcBillNoMap);
        }
        OperationResult saveResult = TmcOperateServiceHelper.execOperate((String)"save", (String)"lc_arronlineresult", (DynamicObject[])arrQueryResultList.toArray(new DynamicObject[0]), (OperateOption)OperateOption.create());
        if (OnlineServiceHelper.CCB_BANKTYPE.equals(bankType)) {
            ThreadPools.executeOnceIncludeRequestContext((String)"downloadfile", () -> TmcOperateServiceHelper.execOperateWithoutThrow((String)"downloadfile", (String)"lc_arronlineresult", (Object[])saveResult.getSuccessPkIds().toArray(), (OperateOption)OperateOption.create()));
        }
        this.ebResult.setStatusCode(EBResultStatusCode.SUCCESS);
        LOG.info("\u672c\u6279\u6b21\u4ece\u94f6\u884c\u540c\u6b65\u66f4\u65b0\u6570\u636e\u6210\u529f\u3002");
    }

    public IEBRequestBuilder getRequestBuilder() {
        QueryCreditReceivedDataSource dataSource = new QueryCreditReceivedDataSource(this.paraMap);
        return new QueryCreditReceivedRequestBuilder(dataSource, "queryCreditReceived", "reply");
    }

    public String getEntityName() {
        return "lc_arronlineresult";
    }

    public BankLogInfo getBankLogInfo() {
        BankLogInfo logInfo = new BankLogInfo();
        logInfo.setEntityName(this.getEntityName());
        return logInfo;
    }

    public PageQueryCreditResult getEBResult() {
        return this.ebResult;
    }

    public Long getBankCateId() {
        return null;
    }

    private List<QueryCreditReceivedReponseDetail> getQueryCreReceResponseDetails(String resultBody) {
        QueryCreditReceivedReponseBody responseBody = (QueryCreditReceivedReponseBody)JSON.parseObject((String)resultBody, QueryCreditReceivedReponseBody.class);
        List detailList = responseBody.getReceivedCredits();
        this.ebResult.setKeepFlag(responseBody.getKeepFlag());
        this.ebResult.setPageNum(responseBody.getPageNum());
        return detailList;
    }

    private Map<String, Long> turnCurrencyNumToId(List<QueryCreditReceivedReponseDetail> detailList) {
        Set currencyNumber = detailList.stream().map(r -> r.getCurrency()).collect(Collectors.toSet());
        QFilter currencyFilter = new QFilter("number", "in", currencyNumber);
        DynamicObjectCollection bdCurrency = QueryServiceHelper.query((String)"bd_currency", (String)"id,number", (QFilter[])new QFilter[]{currencyFilter});
        return bdCurrency.stream().collect(Collectors.toMap(r -> r.getString("number"), r -> r.getLong("id")));
    }

    private void buildOnlineResultMapping(Map<String, Long> currencyNumToIdMap, QueryCreditReceivedReponseDetail detail, List<DynamicObject> updateLetterCreditList, Map<String, String> lcBillNoMap) {
        DynamicObject onlineLc = BusinessDataServiceHelper.newDynamicObject((String)"lc_arronlineresult");
        onlineLc.set("org", this.paraMap.get("org"));
        String currencyCode = detail.getCurrency();
        onlineLc.set("billcurrency", (Object)currencyNumToIdMap.get(currencyCode));
        onlineLc.set("banktype", this.paraMap.get("bank"));
        onlineLc.set("creditno", (Object)detail.getCreditNo());
        onlineLc.set("receivedno", (Object)detail.getReceivedNo());
        String amount = Optional.ofNullable(detail.getAmount()).filter(r -> EmptyUtil.isNoEmpty((String)r)).orElse("0");
        onlineLc.set("amount", (Object)new BigDecimal(amount));
        String bankCharge = Optional.ofNullable(detail.getPrsBankCharge()).filter(r -> EmptyUtil.isNoEmpty((String)r)).orElse("0");
        onlineLc.set("prsbankcharge", (Object)new BigDecimal(bankCharge));
        onlineLc.set("currency", (Object)currencyCode);
        onlineLc.set("opendate", (Object)detail.getOpenDate());
        onlineLc.set("contractno", (Object)detail.getContractNo());
        String contractAmt = Optional.ofNullable(detail.getContractAmount()).filter(r -> EmptyUtil.isNoEmpty((String)r)).orElse("0");
        onlineLc.set("contractamount", (Object)new BigDecimal(contractAmt));
        onlineLc.set("credittype", (Object)detail.getCreditType());
        onlineLc.set("receivedflag", (Object)detail.getReceivedFlag());
        onlineLc.set("fbankname", (Object)detail.getfBankName());
        onlineLc.set("fbankcnapscode", (Object)detail.getfBankCnapsCode());
        onlineLc.set("fdate", (Object)detail.getfDate());
        String arrivalDate = detail.getrDate();
        onlineLc.set("rdate", (Object)arrivalDate);
        if (EmptyUtil.isNoEmpty((String)arrivalDate)) {
            onlineLc.set("bizdate", (Object)DateUtils.stringToDate((String)arrivalDate, (String)"yyyyMMdd"));
        }
        onlineLc.set("rdate2", (Object)detail.getrDate2());
        String remitAmount = Optional.ofNullable(detail.getRemitAmount()).filter(r -> EmptyUtil.isNoEmpty((String)r)).orElse("0");
        BigDecimal totalAmt = new BigDecimal(remitAmount);
        if (EmptyUtil.isEmpty((BigDecimal)totalAmt)) {
            totalAmt = new BigDecimal(amount).add(new BigDecimal(bankCharge));
        }
        onlineLc.set("remitamount", (Object)totalAmt);
        onlineLc.set("startdate", (Object)detail.getStartDate());
        onlineLc.set("explain", (Object)detail.getExplain());
        onlineLc.set("duedate", (Object)detail.getDueDate());
        onlineLc.set("draftno", (Object)detail.getDraftNo());
        onlineLc.set("wayno", (Object)detail.getWayNo());
        onlineLc.set("billinfo", (Object)detail.getBillInfo());
        onlineLc.set("billdisdesc_tag", (Object)detail.getBillDisDesc());
        onlineLc.set("docs_tag", (Object)detail.getDocs());
        onlineLc.set("batchno", (Object)detail.getBatchNo());
        onlineLc.set("status", (Object)detail.getStatus());
        onlineLc.set("creditcurrency", (Object)detail.getCreditCurrency());
        onlineLc.set("payeeaccname", (Object)detail.getPayeeAccName());
        onlineLc.set("tenor", (Object)detail.getTenor());
        onlineLc.set("payeebanknameandadd", (Object)detail.getPayeeBankNameAndAdd());
        onlineLc.set("acptstatus", (Object)detail.getAcptStatus());
        onlineLc.set("filelist_tag", (Object)JSONObject.toJSONString((Object)detail.getFileList()));
        String lcBillNo = lcBillNoMap.get(detail.getReceivedNo());
        if (EmptyUtil.isNoEmpty((String)lcBillNo)) {
            onlineLc.set("lcbillno", (Object)lcBillNo);
            onlineLc.set("isregister", (Object)Boolean.TRUE);
        }
        updateLetterCreditList.add(onlineLc);
    }

    private Map<String, String> getDbLcBillNo(List<QueryCreditReceivedReponseDetail> detailList, Long orgId, Long bankType) {
        HashMap<String, String> result = new HashMap<String, String>(detailList.size());
        List arrivalNoList = detailList.stream().map(r -> r.getReceivedNo()).collect(Collectors.toList());
        QFilter qFilter = new QFilter("arrivalno", "in", arrivalNoList);
        qFilter.and(new QFilter("org", "=", (Object)orgId));
        qFilter.and(new QFilter("arrivalbank.bank_cate", "=", (Object)bankType));
        DynamicObjectCollection dbLcCols = QueryServiceHelper.query((String)"lc_arrival", (String)"arrivalno,billno", (QFilter[])new QFilter[]{qFilter});
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)dbLcCols)) {
            dbLcCols.stream().forEach(r -> result.put(r.getString("arrivalno"), r.getString("billno")));
        }
        return result;
    }
}

