/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.lc.business.opservice.ebservice.service.lettercredit;

import java.util.Date;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.common.enums.BeBillStatusEnum;
import kd.tmc.fbp.service.ebservice.data.EBResult;
import kd.tmc.fbp.service.ebservice.data.EBResultStatusCode;
import kd.tmc.fbp.service.ebservice.log.BankLogInfo;
import kd.tmc.fbp.service.ebservice.request.IEBRequestBuilder;
import kd.tmc.fbp.service.ebservice.service.IEBService;
import kd.tmc.lc.business.opservice.ebservice.request.OpenCreditQueryRequestBuilder;
import kd.tmc.lc.business.opservice.ebservice.request.datasource.lettercredit.OpenCreditQueryDataSource;
import kd.tmc.lc.common.enums.ArrivalWayEnum;
import kd.tmc.lc.common.helper.OnlineServiceHelper;

public class OpenCreditQueryService
implements IEBService<EBResult> {
    private EBResult ebResult;
    private final DynamicObject letterCreditBill;

    public OpenCreditQueryService(DynamicObject letterCreditBill) {
        this.letterCreditBill = letterCreditBill;
    }

    public DynamicObject getLetterCreditBill() {
        return this.letterCreditBill;
    }

    public boolean validate() {
        return true;
    }

    public void beforeRequest() {
    }

    public void rollback(String errMsg, Exception e) {
        this.ebResult = new EBResult();
        this.ebResult.setStatusCode(EBResultStatusCode.ROLLBACK);
        this.ebResult.setErrMsg(errMsg);
        this.ebResult.setBankBillId(Long.valueOf(this.letterCreditBill.getLong("id")));
        try (TXHandle tx = TX.requiresNew();){
            String entityName = this.letterCreditBill.getDynamicObjectType().getName();
            if ("lc_arrival".equals(entityName) && ArrivalWayEnum.isAccept((String)this.letterCreditBill.getString("opetype"))) {
                this.letterCreditBill.set("acceptbebankstatus", null);
                this.letterCreditBill.set("acceptsubmittime", null);
            } else {
                this.letterCreditBill.set("bebankstatus", null);
                this.letterCreditBill.set("submittime", null);
            }
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{this.letterCreditBill});
        }
    }

    public void handleEBException(String resultBody, String errMsg, Exception e) {
        this.ebResult = new EBResult();
        this.ebResult.setStatusCode(EBResultStatusCode.ERROR);
        this.ebResult.setErrMsg(errMsg);
        this.ebResult.setBankBillId(Long.valueOf(this.letterCreditBill.getLong("id")));
        try (TXHandle tx = TX.requiresNew();){
            String entityName = this.letterCreditBill.getDynamicObjectType().getName();
            if ("lc_arrival".equals(entityName) && ArrivalWayEnum.isAccept((String)this.letterCreditBill.getString("opetype"))) {
                this.letterCreditBill.set("acceptbebankstatus", (Object)BeBillStatusEnum.NC.getValue());
                this.letterCreditBill.set("acceptsubmittime", (Object)new Date());
            } else {
                this.letterCreditBill.set("bebankstatus", (Object)BeBillStatusEnum.NC.getValue());
                this.letterCreditBill.set("submittime", (Object)new Date());
            }
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{this.letterCreditBill});
        }
    }

    public void handleResultBody(String resultBody) {
        if ("lc_arrival".equals(this.getEntityName())) {
            OnlineServiceHelper.dealOnlineArrival((String)resultBody, (DynamicObject)this.letterCreditBill, (String)this.getSubBizType());
        } else {
            OnlineServiceHelper.dealOnlineOpenCredit((String)resultBody, (DynamicObject)this.letterCreditBill);
        }
        this.ebResult = new EBResult();
        this.ebResult.setStatusCode(EBResultStatusCode.SUCCESS);
    }

    public IEBRequestBuilder getRequestBuilder() {
        OpenCreditQueryDataSource creditQueryDataSource = new OpenCreditQueryDataSource(this.letterCreditBill);
        return new OpenCreditQueryRequestBuilder(creditQueryDataSource, "openCreditQuery", "openCreditQuery");
    }

    public String getEntityName() {
        return this.letterCreditBill.getDataEntityType().getName();
    }

    public BankLogInfo getBankLogInfo() {
        BankLogInfo logInfo = new BankLogInfo();
        logInfo.setSourceId(Long.valueOf(this.letterCreditBill.getLong("id")));
        logInfo.setBillNo(this.letterCreditBill.getString("billno"));
        logInfo.setEntityName(this.getEntityName());
        logInfo.setOrgid((Long)this.letterCreditBill.getDynamicObject("org").getPkValue());
        return logInfo;
    }

    public EBResult getEBResult() {
        return this.ebResult;
    }

    public Long getBankCateId() {
        if ("lc_arrival".equals(this.getEntityName())) {
            return Optional.ofNullable(this.letterCreditBill.getDynamicObject("arrivalbank")).map(r -> r.getDynamicObject("bank_cate")).map(r -> r.getLong("id")).orElse(0L);
        }
        return Optional.ofNullable(this.letterCreditBill.getDynamicObject("bank")).map(r -> r.getDynamicObject("bank_cate")).map(r -> r.getLong("id")).orElse(0L);
    }

    private String getSubBizType() {
        if (!"lc_arrival".equals(this.getEntityName())) {
            return "";
        }
        String opeType = this.letterCreditBill.getString("opetype");
        String result = "refuseCredit";
        if (ArrivalWayEnum.isAccept((String)opeType)) {
            result = "aceptCredit";
        } else if (ArrivalWayEnum.isPayment((String)opeType)) {
            result = "paymentCredit";
        }
        return result;
    }
}

