/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.lc.business.opservice.ebservice.service.lettercredit;

import java.util.Collections;
import java.util.Date;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.common.enums.BeBillStatusEnum;
import kd.tmc.fbp.common.log.PayLogger;
import kd.tmc.fbp.common.log.builder.PayTraceLogBankBillBuilder;
import kd.tmc.fbp.common.log.enums.PayLogLevelEnum;
import kd.tmc.fbp.common.log.enums.PayTraceLogStepEmum;
import kd.tmc.fbp.service.ebservice.bean.SyncStatusResult;
import kd.tmc.fbp.service.ebservice.data.EBResultStatusCode;
import kd.tmc.fbp.service.ebservice.log.BankLogInfo;
import kd.tmc.fbp.service.ebservice.request.IEBRequestBuilder;
import kd.tmc.fbp.service.ebservice.service.IEBService;
import kd.tmc.lc.business.opservice.ebservice.request.OpenCreditRequestBuilder;
import kd.tmc.lc.business.opservice.ebservice.request.datasource.lettercredit.OpenCreditDataSource;
import kd.tmc.lc.common.helper.OnlineServiceHelper;

public class OpenCreditService
implements IEBService<SyncStatusResult> {
    private final DynamicObject letterCreditBill;
    private SyncStatusResult ebResult;
    private static final PayLogger traceLogger = PayLogger.create(OpenCreditService.class);

    public OpenCreditService(DynamicObject letterCreditBill) {
        this.letterCreditBill = letterCreditBill;
    }

    public DynamicObject getLetterCreditBill() {
        return this.letterCreditBill;
    }

    public boolean validate() {
        return true;
    }

    public void beforeRequest() {
    }

    public void rollback(String errMsg, Exception e) {
        this.ebResult = new SyncStatusResult();
        this.ebResult.setStatusCode(EBResultStatusCode.ROLLBACK);
        this.ebResult.setErrMsg(errMsg);
        this.ebResult.setBankBillId(Long.valueOf(this.letterCreditBill.getLong("id")));
        try (TXHandle tx = TX.requiresNew();){
            this.letterCreditBill.set("bebankstatus", null);
            this.letterCreditBill.set("submittime", null);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{this.letterCreditBill});
        }
    }

    public void handleResultBody(String resultBody) {
        OnlineServiceHelper.dealOnlineOpenCredit((String)resultBody, (DynamicObject)this.letterCreditBill);
        this.ebResult = new SyncStatusResult();
        this.ebResult.setStatusCode(EBResultStatusCode.SUCCESS);
    }

    public void handleEBException(String resultBody, String errMsg, Exception e) {
        traceLogger.logBatch(new PayTraceLogBankBillBuilder(Collections.singletonList(this.getLetterCreditBill()), PayLogLevelEnum.INFO.getValue(), PayTraceLogStepEmum.PAY.getValue(), "Deal Exception Message", resultBody, e).build());
        this.ebResult = new SyncStatusResult();
        this.ebResult.setStatusCode(EBResultStatusCode.ERROR);
        this.ebResult.setErrMsg(errMsg);
        this.ebResult.setBankBillId(Long.valueOf(this.letterCreditBill.getLong("id")));
        try (TXHandle tx = TX.requiresNew();){
            this.letterCreditBill.set("bebankstatus", (Object)BeBillStatusEnum.NC.getValue());
            this.letterCreditBill.set("submittime", (Object)new Date());
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{this.letterCreditBill});
        }
    }

    public IEBRequestBuilder getRequestBuilder() {
        OpenCreditDataSource openCreditDataSource = new OpenCreditDataSource(this.letterCreditBill);
        return new OpenCreditRequestBuilder(openCreditDataSource, "openCredit", "openCredit");
    }

    public BankLogInfo getBankLogInfo() {
        BankLogInfo logInfo = new BankLogInfo();
        logInfo.setSourceId(Long.valueOf(this.letterCreditBill.getLong("id")));
        logInfo.setBillNo(this.letterCreditBill.getString("billno"));
        logInfo.setEntityName(this.getEntityName());
        logInfo.setOrgid((Long)this.letterCreditBill.getDynamicObject("org").getPkValue());
        return logInfo;
    }

    public SyncStatusResult getEBResult() {
        return this.ebResult;
    }

    public Long getBankCateId() {
        return Optional.ofNullable(this.letterCreditBill.getDynamicObject("bank")).map(r -> r.getDynamicObject("bank_cate")).map(r -> r.getLong("id")).orElse(0L);
    }

    public String getEntityName() {
        return this.letterCreditBill.getDataEntityType().getName();
    }
}

