/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.lc.business.opservice.lettercredit;

import java.util.Arrays;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.exception.KDException;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcBotpHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.lc.common.enums.LetterCreditStatusEnum;

public class LetterCreditRecommitBeService
extends AbstractTmcBizOppService {
    public void process(DynamicObject[] dataEntities) throws KDException {
        DynamicObject[] currentBills;
        Object[] pkIds = Arrays.stream(dataEntities).map(r -> r.getPkValue()).toArray();
        for (DynamicObject perBill : currentBills = TmcDataServiceHelper.load((Object[])pkIds, (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)dataEntities[0].getDataEntityType().getName()))) {
            perBill.set("isresubmit", (Object)Boolean.TRUE);
            this.generateCloneBill(perBill);
        }
        SaveServiceHelper.update((DynamicObject[])currentBills);
    }

    private void generateCloneBill(DynamicObject currentBill) {
        DynamicObject cloneBill = TmcDataServiceHelper.clone((DynamicObject)currentBill);
        cloneBill.set("billno", null);
        cloneBill.set("creditstatus", (Object)LetterCreditStatusEnum.DONE_REGISTER.getValue());
        cloneBill.set("billstatus", (Object)BillStatusEnum.SAVE.getValue());
        cloneBill.set("bebankstatus", (Object)"");
        cloneBill.set("isresubmit", (Object)false);
        cloneBill.set("returnmsg", (Object)"");
        cloneBill.set("submittime", (Object)"");
        cloneBill.set("createtime", (Object)DateUtils.getCurrentTime());
        cloneBill.set("creator", (Object)RequestContext.get().getCurrUserId());
        cloneBill.set("resubmitsrcno", (Object)currentBill.getString("billno"));
        TmcOperateServiceHelper.execOperate((String)"save", (String)currentBill.getDynamicObjectType().getName(), (DynamicObject[])new DynamicObject[]{cloneBill}, (OperateOption)OperateOption.create());
        DynamicObject srcBill = TmcBotpHelper.getSourceBill((String)"lc_lettercredit", (Object)currentBill.getPkValue(), (String)"lc_bizapply");
        if (EmptyUtil.isNoEmpty((DynamicObject)srcBill)) {
            TmcBotpHelper.saveRelation((DynamicObject)srcBill, (DynamicObject)cloneBill);
        }
    }
}

