/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.lc.business.opservice.lettercredit;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.property.EntryProp;
import kd.bos.exception.KDException;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.util.DynamicObjectSerializeUtil;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.constant.Constants;
import kd.tmc.fbp.common.enums.ProductTypeEnum;
import kd.tmc.fbp.common.helper.CodeRuleHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.service.paywriteback.PayBillWriteBackOperateEnum;
import kd.tmc.lc.business.opservice.helper.LetterCreditOpenHelper;
import kd.tmc.lc.common.helper.LetterCreditHelper;

public class LetterCreditSaveService
extends AbstractTmcBizOppService {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("billno");
        selector.add("creditlimit");
        selector.add("id");
        selector.add("amount");
        selector.add("amountscaleupper");
        selector.add("creditapplyno");
        selector.add("entrys");
        selector.add("currency");
        selector.add("bizdate");
        selector.add("notarramount");
        selector.add("totalarramount");
        selector.add("creditamount");
        selector.add("issurety");
        selector.add("sourcebilltype");
        selector.add("srcbillid");
        selector.add("creditno");
        selector.add("org");
        selector.add("bank");
        selector.add("benefitertype");
        selector.add("benefiterother");
        selector.add("e_createtime");
        return selector;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        if (this.operationVariable.containsKey("op_from_isc")) {
            return;
        }
        for (DynamicObject letterCredit : dataEntities) {
            if ("lc_lettercredit_init".equals(letterCredit.getDataEntityType().getName())) continue;
            BigDecimal totalArrAmount = letterCredit.getBigDecimal("totalarramount");
            letterCredit.set("notarramount", (Object)LetterCreditHelper.getAmount((DynamicObject)letterCredit).subtract(totalArrAmount));
            LetterCreditHelper.letterCreditSaveProcess((DynamicObject)letterCredit, (Map)this.operationVariable);
            this.dealEditApplyFeeEntryInfo(letterCredit);
            LetterCreditHelper.setIsSurety((DynamicObject)letterCredit);
        }
        LetterCreditOpenHelper.letterCreditWriteBackPay(Arrays.stream(dataEntities).collect(Collectors.toList()), PayBillWriteBackOperateEnum.SAVE.getValue());
    }

    private void dealEditApplyFeeEntryInfo(DynamicObject info) {
        String applyFeeEntrySeriStr = (String)this.operationVariable.get("EditApplyFeeEntrySeriStr");
        String applyFeeOpTypeFormId = (String)this.operationVariable.get("EditApplyFeeOpTypeFormId");
        if (EmptyUtil.isEmpty((String)applyFeeEntrySeriStr) || EmptyUtil.isEmpty((String)applyFeeOpTypeFormId)) {
            return;
        }
        Long thisOrgId = info.getDynamicObject("org").getLong("id");
        EntryProp prop = (EntryProp)EntityMetadataCache.getDataEntityType((String)"lc_bizapply").findProperty("feedetail");
        DynamicObjectType feeEntryType = prop.getDynamicCollectionItemPropertyType();
        Object[] letterCreditFeeEntryCol = DynamicObjectSerializeUtil.deserialize((String)applyFeeEntrySeriStr, (DynamicObjectType)feeEntryType);
        ArrayList<DynamicObject> needSaveFeeBillLists = new ArrayList<DynamicObject>(letterCreditFeeEntryCol.length);
        for (Object linkGenFeeEntryObj : letterCreditFeeEntryCol) {
            DynamicObject linkGenFeeEntry = (DynamicObject)linkGenFeeEntryObj;
            DynamicObject feeBillDo = BusinessDataServiceHelper.newDynamicObject((String)"cfm_feebill");
            String feeBillNum = linkGenFeeEntry.getString("feebillnum");
            if (EmptyUtil.isEmpty((String)feeBillNum)) {
                feeBillNum = CodeRuleHelper.generateNumber((String)"cfm_feebill", (DynamicObject)TmcDataServiceHelper.newDynamicObject((String)"cfm_feebill"), (String)String.valueOf(info.getDynamicObject("org").getPkValue()), (String)"");
            }
            feeBillDo.set("billno", (Object)feeBillNum);
            feeBillDo.set("org", (Object)thisOrgId);
            feeBillDo.set("feescheme", (Object)this.getIdByBaseDo(linkGenFeeEntry, "feescheme"));
            feeBillDo.set("feetype", (Object)this.getIdByBaseDo(linkGenFeeEntry, "feetype"));
            feeBillDo.set("paydate", (Object)linkGenFeeEntry.getDate("feepaydate"));
            feeBillDo.set("currency", (Object)this.getIdByBaseDo(linkGenFeeEntry, "feecurrency"));
            feeBillDo.set("payamt", (Object)linkGenFeeEntry.getBigDecimal("feeamt"));
            feeBillDo.set("amountrate", (Object)linkGenFeeEntry.getBigDecimal("feerate"));
            feeBillDo.set("settlementtype", (Object)this.getIdByBaseDo(linkGenFeeEntry, "feesettletype"));
            feeBillDo.set("feeacctbank", (Object)this.getIdByBaseDo(linkGenFeeEntry, "feeacctbank"));
            feeBillDo.set("oppunittype", (Object)linkGenFeeEntry.getString("feeoppunittype"));
            feeBillDo.set("oppunit", (Object)this.getIdByBaseDo(linkGenFeeEntry, "feeoppunit"));
            feeBillDo.set("oppunittext", (Object)linkGenFeeEntry.getString("feeoppunittext"));
            feeBillDo.set("oppacctbank", (Object)linkGenFeeEntry.getString("feeoppacctbank"));
            feeBillDo.set("oppbebank", (Object)this.getIdByBaseDo(linkGenFeeEntry, "feeoppbebank"));
            feeBillDo.set("billstatus", (Object)info.getString("billstatus"));
            feeBillDo.set("feesource", (Object)linkGenFeeEntry.getString("feesource"));
            feeBillDo.set("issettle", (Object)linkGenFeeEntry.getBoolean("feeissettle"));
            feeBillDo.set("createtime", (Object)DateUtils.getCurrentTime());
            feeBillDo.set("modifytime", (Object)DateUtils.getCurrentTime());
            long user = Long.parseLong(RequestContext.get().getUserId());
            feeBillDo.set("creator", (Object)user);
            feeBillDo.set("modifier", (Object)user);
            feeBillDo.set("appsource", (Object)"lc");
            DynamicObjectCollection entryCol = feeBillDo.getDynamicObjectCollection("entry");
            DynamicObject entry = entryCol.addNew();
            entry.set("producttype", (Object)Long.valueOf(ProductTypeEnum.getEnumByFormId((String)applyFeeOpTypeFormId).getId()));
            entry.set("srcbillno", (Object)info.getString("billno"));
            entry.set("srcbillid", (Object)info.getLong("id"));
            entry.set("creditno", (Object)info.getString("creditno"));
            entry.set("feeratio", (Object)Constants.ONE_HUNDRED);
            entry.set("feedetailamt", (Object)linkGenFeeEntry.getBigDecimal("feeamt"));
            entry.set("remark", (Object)linkGenFeeEntry.getString("feeremark"));
            entry.set("id", (Object)linkGenFeeEntry.getLong("feebillentryid"));
            needSaveFeeBillLists.add(feeBillDo);
        }
        if (EmptyUtil.isNoEmpty(needSaveFeeBillLists)) {
            SaveServiceHelper.save((DynamicObject[])needSaveFeeBillLists.toArray(new DynamicObject[0]));
        }
    }

    private Long getIdByBaseDo(DynamicObject info, String propKey) {
        DynamicObject propVal = info.getDynamicObject(propKey);
        return EmptyUtil.isEmpty((DynamicObject)propVal) ? 0L : propVal.getLong("id");
    }
}

