/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.lc.business.opservice.online;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.constant.DBRouteConst;
import kd.tmc.fbp.common.helper.TmcBusinessBaseHelper;
import kd.tmc.fbp.service.ebservice.bean.SyncStatusResult;
import kd.tmc.fbp.service.ebservice.data.EBResultStatusCode;
import kd.tmc.lc.business.opservice.ebservice.api.EBServiceFacadeImpl;
import kd.tmc.lc.common.enums.FileDownloadStatusEnum;

public class ArrOnlineDownloadFileService
extends AbstractTmcBizOppService {
    public void process(DynamicObject[] dataEntities) throws KDException {
        List idList = Arrays.stream(dataEntities).map(s -> (Long)s.getPkValue()).collect(Collectors.toList());
        String tableName = dataEntities[0].getDataEntityType().getAlias();
        String sql = "update " + tableName + " set ffilestatus = ? where fid in (" + TmcBusinessBaseHelper.idListToString(idList) + ") and ffilestatus = ' ' ";
        int[] result = DB.executeBatch((DBRoute)DBRouteConst.TMC, (String)sql, Collections.singletonList(new Object[]{FileDownloadStatusEnum.DONING.getValue()}));
        if (result.length < 1 || result[0] != idList.size()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6709\u672a\u5b8c\u6210\u7684\u6587\u4ef6\u4e0b\u8f7d\u670d\u52a1, \u4e0d\u5141\u8bb8\u518d\u6b21\u4e0b\u8f7d\u6587\u4ef6\u3002", (String)"ArrOnlineDownloadFileService_1", (String)"tmc-lc-business", (Object[])new Object[0]));
        }
    }

    public void afterProcess(DynamicObject[] dataEntities) throws KDException {
        super.afterProcess(dataEntities);
        List<Long> billIdList = Arrays.stream(dataEntities).map(o -> (Long)o.getPkValue()).collect(Collectors.toList());
        List<SyncStatusResult> result = new EBServiceFacadeImpl().commit("downloadBankFile", dataEntities[0].getDataEntityType().getName(), billIdList);
        List errList = result.stream().filter(o -> o.getStatusCode() == EBResultStatusCode.ERROR || o.getStatusCode() == EBResultStatusCode.ROLLBACK).collect(Collectors.toList());
        StringBuilder errMsg = new StringBuilder();
        for (SyncStatusResult errResult : errList) {
            errMsg.append(errResult.getErrMsg()).append(' ');
        }
        if (errMsg.length() > 0) {
            throw new KDBizException(errMsg.toString());
        }
    }
}

