/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.lc.business.opservice.online;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.enums.BeBillStatusEnum;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.lc.common.enums.ArrivalWayEnum;
import kd.tmc.lc.common.helper.OnlineServiceHelper;

public class OnlineUpdateStatSaveService
extends AbstractTmcBizOppService {
    private static final String ARRIVAL_PROPS = "id,bebankstatus,returnmsg,acceptbebankstatus,acceptreturnmsg,opetype,arrivalstatus,configtime,submittime,lettercredit,arrivalamount,arrivalcurrency,endpaydate,doneamount,todoamount,ispayconfig,entrys.arrpayamount,entrys.arrpaycurrency,entrys.realpaydate,entrys.isdiffcur,entrys.arrpaycurrency";
    private static final String CREDIT_PROPS = "id,bebankstatus,returnmsg,creditno";

    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("billtype");
        selector.add("entryentity");
        selector.add("srcid");
        selector.add("statusnew");
        selector.add("billstatus");
        selector.add("creditno");
        return selector;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        ArrayList<DynamicObject> srcBillList = new ArrayList<DynamicObject>(dataEntities.length);
        for (DynamicObject bill : dataEntities) {
            DynamicObject[] srcBills;
            bill.set("billstatus", (Object)BillStatusEnum.AUDIT.getValue());
            DynamicObjectCollection entry = bill.getDynamicObjectCollection("entryentity");
            if (EmptyUtil.isEmpty((DynamicObjectCollection)entry)) continue;
            Map<Long, DynamicObject> srcMap = entry.stream().collect(Collectors.toMap(r -> r.getLong("srcid"), r -> r));
            String entityName = bill.getString("billtype");
            String selectProp = "lc_arrival".equals(entityName) ? ARRIVAL_PROPS : CREDIT_PROPS;
            for (DynamicObject srcBill : srcBills = TmcDataServiceHelper.load((String)entityName, (String)selectProp, (QFilter[])new QFilter[]{new QFilter("id", "in", srcMap.keySet())}, (String)"")) {
                DynamicObject row = srcMap.get(srcBill.getLong("id"));
                String modifiedStat = row.getString("statusnew");
                if ("lc_arrival".equals(entityName) && ArrivalWayEnum.isAccept((String)srcBill.getString("opetype"))) {
                    srcBill.set("acceptbebankstatus", (Object)modifiedStat);
                    srcBill.set("acceptreturnmsg", null);
                } else {
                    srcBill.set("bebankstatus", (Object)modifiedStat);
                    srcBill.set("returnmsg", null);
                }
                if ("lc_lettercredit".equals(entityName)) {
                    srcBill.set("creditno", (Object)row.getString("creditno"));
                } else if (BeBillStatusEnum.isTS((String)modifiedStat) && "lc_arrival".equals(entityName)) {
                    String opeType = srcBill.getString("opetype");
                    if (ArrivalWayEnum.isAccept((String)opeType)) {
                        OnlineServiceHelper.dealAcceptSuccessScene((DynamicObject)srcBill, (boolean)false);
                    } else if (ArrivalWayEnum.isPayment((String)opeType)) {
                        if (EmptyUtil.isEmpty((String)srcBill.getString("acceptbebankstatus"))) {
                            OnlineServiceHelper.dealAcceptSuccessScene((DynamicObject)srcBill, (boolean)false);
                        }
                        OnlineServiceHelper.dealPaySuccessScene((DynamicObject)srcBill);
                    } else if (ArrivalWayEnum.isProtest((String)opeType)) {
                        OnlineServiceHelper.dealAcceptSuccessScene((DynamicObject)srcBill, (boolean)true);
                    }
                }
                srcBillList.add(srcBill);
            }
        }
        if (EmptyUtil.isNoEmpty(srcBillList)) {
            SaveServiceHelper.save((DynamicObject[])srcBillList.toArray(new DynamicObject[0]));
        }
    }
}

