/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.lc.business.opservice.present;

import java.util.Collection;
import java.util.List;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.enums.TmcAppEnum;
import kd.tmc.fbp.common.helper.TmcBotpHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.helper.TmcParameterHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class PresentBillAuditService
extends AbstractTmcBizOppService {
    public List<String> getSelector() {
        List sic = super.getSelector();
        sic.add("org");
        sic.add("arrivalstatus");
        sic.add("benefiter");
        sic.add("lettercredit");
        sic.add("lettercredit.benefitertype");
        sic.add("lettercredit.number");
        return sic;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        for (DynamicObject presentBill : dataEntities) {
            Object[] arrivalBills;
            String arrivalNo;
            QFilter arrivalFilter;
            boolean exists;
            DynamicObject receiptBillDo;
            DynamicObject receipt = presentBill.getDynamicObject("lettercredit");
            if (EmptyUtil.isNoEmpty((DynamicObject)receipt)) {
                TmcBotpHelper.saveRelation((String)"lc_receipt", (Long)((Long)receipt.getPkValue()), (String)"lc_present", (Long)((Long)presentBill.getPkValue()));
            }
            Long orgId = EmptyUtil.isNoEmpty((DynamicObject)presentBill.getDynamicObject("benefiter")) ? presentBill.getDynamicObject("benefiter").getLong("id") : 0L;
            boolean recCompPresent = TmcParameterHelper.getAppBoolParameter((String)TmcAppEnum.LC.getId(), (long)orgId, (String)"reccomppresent");
            if (!recCompPresent || !EmptyUtil.isNoEmpty((DynamicObject)(receiptBillDo = presentBill.getDynamicObject("lettercredit")))) continue;
            String creditNo = receiptBillDo.getString("number");
            QFilter qFilter = new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue());
            qFilter.and(new QFilter("number", "=", (Object)creditNo));
            DynamicObject letterCreditDo = TmcDataServiceHelper.loadSingle((String)"lc_lettercredit_f7", (QFilter[])qFilter.toArray());
            if (!EmptyUtil.isNoEmpty((DynamicObject)letterCreditDo) || !"bos_org".equals(letterCreditDo.getString("benefitertype")) || (exists = TmcDataServiceHelper.exists((String)"lc_arrival", (QFilter[])(arrivalFilter = new QFilter("arrivalno", "=", (Object)(arrivalNo = presentBill.getString("arrivalno")))).toArray())) || EmptyUtil.isEmpty((Object[])(arrivalBills = TmcBotpHelper.push((DynamicObject)presentBill, (String)"lc_arrival")))) continue;
            for (Object arrivalBill : arrivalBills) {
                arrivalBill.set("lettercredit", (Object)letterCreditDo);
            }
            OperateOption option = OperateOption.create();
            option.setVariableValue("WF", "TRUE");
            OperationResult submitResult = TmcOperateServiceHelper.execOperate((String)"submit", (String)"lc_arrival", (DynamicObject[])arrivalBills, (OperateOption)option);
            if (!submitResult.isSuccess() || EmptyUtil.isEmpty((Collection)submitResult.getSuccessPkIds())) continue;
            TmcOperateServiceHelper.execOperate((String)"audit", (String)"lc_arrival", (Object[])submitResult.getSuccessPkIds().toArray(), (OperateOption)option);
            TmcBotpHelper.deleteRation((String)"lc_arrival", (Long)presentBill.getLong("id"), (Long)((Long)submitResult.getSuccessPkIds().get(0)));
        }
    }
}

