/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.lc.business.opservice.present;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDException;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.lc.common.enums.PresentStatusEnum;
import kd.tmc.lc.common.helper.LetterCreditHelper;

public class PresentBillAutoConfirmService
extends AbstractTmcBizOppService {
    public void process(DynamicObject[] dataEntities) throws KDException {
        HashMap<Long, BigDecimal> receiptArrMap = new HashMap<Long, BigDecimal>();
        HashMap<Long, Date> letterDateArrMap = new HashMap<Long, Date>();
        for (DynamicObject presentBill : dataEntities) {
            presentBill.set("arrivalstatus", (Object)PresentStatusEnum.PRESENT_CONFIRM.getValue());
            presentBill.set("configtime", (Object)DateUtils.getCurrentTime());
            DynamicObject receipt = presentBill.getDynamicObject("lettercredit");
            if (!EmptyUtil.isNoEmpty((DynamicObject)receipt)) continue;
            BigDecimal arrAmt = receiptArrMap.getOrDefault(receipt.getLong("id"), BigDecimal.ZERO);
            receiptArrMap.put(receipt.getLong("id"), arrAmt.add(presentBill.getBigDecimal("arrivalamount")));
            if (!receipt.getBoolean("isnegotiating")) continue;
            letterDateArrMap.put(receipt.getLong("id"), presentBill.getDate("endpaydate"));
        }
        SaveServiceHelper.update((DynamicObject[])dataEntities);
        LetterCreditHelper.updateLetterArr((String)"lc_receipt", receiptArrMap, letterDateArrMap);
    }
}

