/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.lc.business.opservice.present;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.enums.ProductTypeEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.lc.common.enums.PresentStatusEnum;
import kd.tmc.lc.common.helper.LcFeeDetailHelper;
import kd.tmc.lc.common.helper.LetterCreditHelper;

public class PresentBillUnConfirmService
extends AbstractTmcBizOppService {
    private static final String[] NO_SAVE_PROPERTYS = new String[]{"feedetail", "entrys", "id", "seq", "billno", "billstatus", "billhead_lk", "creator", "creatortime", "modifier", "modifytime", "auditor", "auditdate", "multilanguagetext"};

    public List<String> getSelector() {
        List sic = super.getSelector();
        sic.add("arrivalamount");
        return sic;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        HashMap<Long, BigDecimal> receiptArrMap = new HashMap<Long, BigDecimal>(dataEntities.length);
        for (DynamicObject presentBill : dataEntities) {
            String billNo = presentBill.getString("billno");
            QFilter filter = new QFilter("billNo", "=", (Object)billNo);
            DynamicObject history = TmcDataServiceHelper.loadSingle((String)"lc_present_h", (String)"id", (QFilter[])filter.toArray());
            DynamicObject present = TmcDataServiceHelper.loadSingle((Object)presentBill.getLong("id"), (String)"lc_present");
            if (EmptyUtil.isNoEmpty((DynamicObject)history)) {
                history = TmcDataServiceHelper.loadSingle((Object)history.getPkValue(), (String)history.getDynamicObjectType().getName());
                LcFeeDetailHelper.updateFeeDetailBill((DynamicObject)history, (DynamicObject)present, (ProductTypeEnum)ProductTypeEnum.LC_PRESENT);
                for (IDataEntityProperty property : present.getDataEntityType().getProperties()) {
                    String prop = property.getName();
                    if (!history.getDataEntityType().getProperties().containsKey((Object)prop) || Arrays.asList(NO_SAVE_PROPERTYS).contains(prop) || prop.endsWith("_id")) continue;
                    if (history.get(prop) instanceof DynamicObjectCollection) {
                        this.setEntryVal(history, present, property);
                        continue;
                    }
                    present.set(prop, history.get(prop));
                }
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{present});
                DeleteServiceHelper.delete((String)"lc_present_h", (QFilter[])filter.toArray());
            } else {
                present.set("arrivalstatus", (Object)PresentStatusEnum.PRESENT_REGISTER.getValue());
                present.set("configtime", null);
                SaveServiceHelper.update((DynamicObject)present);
            }
            DynamicObject receiptBill = present.getDynamicObject("lettercredit");
            if (!EmptyUtil.isNoEmpty((DynamicObject)receiptBill)) continue;
            BigDecimal arrAmt = receiptArrMap.getOrDefault(receiptBill.getLong("id"), BigDecimal.ZERO);
            receiptArrMap.put(receiptBill.getLong("id"), arrAmt.subtract(presentBill.getBigDecimal("arrivalamount")));
        }
        LetterCreditHelper.updateLetterArr((String)"lc_receipt", receiptArrMap);
    }

    private void setEntryVal(DynamicObject history, DynamicObject present, IDataEntityProperty property) {
        DynamicObjectCollection colls = (DynamicObjectCollection)history.get(property);
        DynamicObjectCollection entrys = (DynamicObjectCollection)present.get(property);
        entrys.clear();
        for (DynamicObject info : colls) {
            DynamicObject entry = entrys.addNew();
            DataEntityPropertyCollection props = entry.getDataEntityType().getProperties();
            for (IDataEntityProperty data : props) {
                Object setValue = info.get(data);
                if ("id".equals(data.getName())) {
                    setValue = DBServiceHelper.genGlobalLongId();
                }
                entry.set(data.getName(), setValue);
            }
        }
    }
}

