/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.lc.business.validate.apply;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.property.AmountProp;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.constant.Constants;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.enums.GuaranteeWayEnum;
import kd.tmc.fbp.common.helper.CreditLimitServiceHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.model.CreditLimitF7ResBean;
import kd.tmc.fbp.common.model.CreditLimitUseBean;
import kd.tmc.fbp.common.resource.TmcBizResource;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.lc.common.enums.LetterBizTypeEnum;
import kd.tmc.lc.common.enums.LetterCreditStatusEnum;
import kd.tmc.lc.common.helper.LetterCreditHelper;

public class LetterCreditApplySubmitValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List sic = super.getSelector();
        sic.add("biztype");
        sic.add("applyreason");
        sic.add("lettercredit");
        sic.add("benefiterother");
        sic.add("isforward");
        sic.add("forwarddays");
        sic.add("entry_surety");
        sic.add("creditlimit");
        sic.add("amount");
        sic.add("amountscaleupper");
        sic.add("entry_surety.suretycurrency");
        sic.add("suretycur");
        sic.add("guarantee");
        sic.add("promisrate");
        sic.add("suretymoney");
        return sic;
    }

    public void validate(ExtendedDataEntity[] dataEntities) throws KDBizException {
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObjectCollection suretyEntry;
            DynamicObject applyBill = dataEntity.getDataEntity();
            String bizType = applyBill.getString("biztype");
            if (LetterBizTypeEnum.EDIT_CARD.getValue().equals(bizType)) {
                Object[] bizApplyArr;
                this.checkAmount(dataEntity, applyBill);
                this.checkMustInputInfo(dataEntity, applyBill);
                this.checkCreditLimit(dataEntity, applyBill);
                DynamicObject letterCredit = QueryServiceHelper.queryOne((String)"lc_lettercredit", (String)"guarantee", (QFilter[])new QFilter[]{new QFilter("id", "=", applyBill.getDynamicObject("lettercredit").getPkValue())});
                List oldGuaWayList = Arrays.stream(EmptyUtil.isEmpty((DynamicObject)letterCredit) ? new String[1] : letterCredit.getString("guarantee").split(",")).filter(r -> EmptyUtil.isNoEmpty((String)r)).collect(Collectors.toList());
                List newGuaWayList = Arrays.stream(applyBill.getString("guarantee").split(",")).filter(r -> EmptyUtil.isNoEmpty((String)r)).collect(Collectors.toList());
                if (oldGuaWayList.contains(GuaranteeWayEnum.ENSUAMT.getNumberValue()) && !newGuaWayList.contains(GuaranteeWayEnum.ENSUAMT.getNumberValue()) || !oldGuaWayList.contains(GuaranteeWayEnum.ENSUAMT.getNumberValue()) && newGuaWayList.contains(GuaranteeWayEnum.ENSUAMT.getNumberValue())) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6539\u8bc1\u7533\u8bf7\u524d\u540e\u62c5\u4fdd\u65b9\u5f0f\u5e94\u540c\u65f6\u5305\u542b\uff08\u4e0d\u5305\u542b\uff09\u4fdd\u8bc1\u91d1\u3002", (String)"LetterCreditApplySubmitValidator_14", (String)"tmc-lc-business", (Object[])new Object[0]));
                }
                if (EmptyUtil.isNoEmpty((DynamicObject)applyBill.getDynamicObject("lettercredit")) && EmptyUtil.isNoEmpty((Object[])(bizApplyArr = TmcDataServiceHelper.load((String)"lc_bizapply", (String)"lettercredit", (QFilter[])new QFilter[]{new QFilter("lettercredit", "=", applyBill.getDynamicObject("lettercredit").getPkValue()), new QFilter("id", "!=", applyBill.getPkValue()), new QFilter("biztype", "=", (Object)LetterBizTypeEnum.EDIT_CARD.getValue()), new QFilter("billstatus", "!=", (Object)BillStatusEnum.AUDIT.getValue())}))) && Arrays.stream(bizApplyArr).filter(e -> !LetterCreditStatusEnum.DONE_REGISTER.getValue().equals(e.getDynamicObject("lettercredit").getString("creditstatus"))).count() > 0L) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4fe1\u7528\u8bc1\u72b6\u6001\u4e0d\u4e3a\u5df2\u767b\u8bb0\u3002", (String)"LetterCreditApplySaveValidator_4", (String)"tmc-lc-business", (Object[])new Object[0]));
                }
            } else if (LetterBizTypeEnum.REPEAL_CARD.getValue().equals(bizType) || LetterBizTypeEnum.CLOSE_CARD.getValue().equals(bizType)) {
                this.checkMustInputInfo(dataEntity, applyBill);
                DynamicObject letterCreditF7 = applyBill.getDynamicObject("lettercredit");
                if (EmptyUtil.isNoEmpty((DynamicObject)letterCreditF7)) {
                    letterCreditF7 = QueryServiceHelper.queryOne((String)"lc_lettercredit", (String)"creditstatus", (QFilter[])new QFilter[]{new QFilter("id", "=", letterCreditF7.getPkValue())});
                    Object[] bizApplyArr = TmcDataServiceHelper.load((String)"lc_bizapply", (String)"lettercredit", (QFilter[])new QFilter[]{new QFilter("lettercredit", "=", applyBill.getDynamicObject("lettercredit").getPkValue()), new QFilter("id", "!=", applyBill.getPkValue()), new QFilter("biztype", "!=", (Object)LetterBizTypeEnum.EDIT_CARD.getValue()), new QFilter("billstatus", "!=", (Object)BillStatusEnum.AUDIT.getValue())});
                    if (Arrays.asList(LetterCreditStatusEnum.DONE_CLOSE.getValue(), LetterCreditStatusEnum.DONE_REPEAL.getValue()).contains(letterCreditF7.getString("creditstatus")) || EmptyUtil.isNoEmpty((Object[])bizApplyArr) && Arrays.stream(bizApplyArr).filter(e -> !LetterCreditStatusEnum.DONE_REGISTER.getValue().equals(e.getDynamicObject("lettercredit").getString("creditstatus"))).count() > 0L) {
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4fe1\u7528\u8bc1\u72b6\u6001\u4e0d\u4e3a\u5df2\u767b\u8bb0\u3002", (String)"LetterCreditApplySaveValidator_4", (String)"tmc-lc-business", (Object[])new Object[0]));
                    }
                }
            } else if (LetterBizTypeEnum.OPEN_CARD.getValue().equals(bizType)) {
                this.checkCreditLimit(dataEntity, applyBill);
            }
            if (EmptyUtil.isEmpty((String)applyBill.getString("benefiterother"))) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\"\u53d7\u76ca\u4eba\"\u3002", (String)"LetterCreditApplySubmitValidator_9", (String)"tmc-lc-business", (Object[])new Object[0]));
            }
            if (!LetterBizTypeEnum.OPEN_CARD.getValue().equals(bizType) && LetterCreditHelper.checkIsforward((DynamicObject)applyBill)) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\"\u8fdc\u671f\u5929\u6570\"\u3002", (String)"LetterCreditApplySubmitValidator_10", (String)"tmc-lc-business", (Object[])new Object[0]));
            }
            if (EmptyUtil.isNoEmpty((DynamicObjectCollection)(suretyEntry = applyBill.getDynamicObjectCollection("entry_surety"))) && !LetterBizTypeEnum.OPEN_CARD.getValue().equals(bizType)) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u975e\u5f00\u8bc1\u7533\u8bf7\u4e0d\u80fd\u5173\u8054\u4fdd\u8bc1\u91d1\u3002", (String)"LetterCreditApplySubmitValidator_6", (String)"tmc-lc-business", (Object[])new Object[0]));
                continue;
            }
            String checkMsg = LetterCreditHelper.checkContainsSurety((DynamicObject)applyBill);
            if (EmptyUtil.isNoEmpty((String)checkMsg)) {
                this.addErrorMessage(dataEntity, checkMsg);
            }
            this.validateAmt(applyBill, dataEntity);
            if (LetterCreditHelper.getAmount((DynamicObject)applyBill).compareTo(Constants.MAX_AMOUNT) > 0) {
                this.addErrorMessage(dataEntity, new TmcBizResource().checkAmountMaxValue(ResManager.loadKDString((String)"\u4fe1\u7528\u8bc1\u91d1\u989d*\uff081+\u6ea2\u77ed\u88c5\u4e0a\u9650\uff09", (String)"LetterCreditApplySubmitValidator_11", (String)"tmc-lc-business", (Object[])new Object[0])));
            }
            for (IDataEntityProperty prop : applyBill.getDataEntityType().getProperties()) {
                if (!(prop instanceof AmountProp) || applyBill.getBigDecimal(prop.getName()).compareTo(Constants.MAX_AMOUNT) <= 0) continue;
                this.addErrorMessage(dataEntity, new TmcBizResource().checkAmountMaxValue(prop.getDisplayName().getLocaleValue()));
            }
        }
    }

    private void checkAmount(ExtendedDataEntity dataEntity, DynamicObject applyBill) {
        BigDecimal reduce;
        Object[] arrivalInfo = LetterCreditHelper.queryArrivalInfo((DynamicObject)applyBill.getDynamicObject("lettercredit"));
        if (EmptyUtil.isNoEmpty((Object[])arrivalInfo) && (reduce = Arrays.stream(arrivalInfo).map(s -> s.getBigDecimal("arrivalamount")).reduce(BigDecimal.ZERO, BigDecimal::add)).compareTo(BigDecimal.ZERO) > 0 && reduce.compareTo(LetterCreditHelper.getAmount((DynamicObject)applyBill)) > 0) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u201c\u91d1\u989d*\uff081+\u6ea2\u77ed\u88c5\u4e0a\u9650\uff09\u201d\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e\u5df2\u5230\u5355\u91d1\u989d%s\u3002", (String)"LetterCreditApplySubmitValidator_5", (String)"tmc-lc-business", (Object[])new Object[]{reduce.setScale(4, RoundingMode.HALF_UP)}));
        }
    }

    private void checkMustInputInfo(ExtendedDataEntity dataEntity, DynamicObject applyBill) {
        if (EmptyUtil.isEmpty((String)applyBill.getString("applyreason"))) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u586b\u5199[\u7533\u8bf7\u539f\u56e0]\u3002", (String)"LetterCreditApplySubmitValidator_1", (String)"tmc-lc-business", (Object[])new Object[0]));
        }
        if (EmptyUtil.isEmpty((String)applyBill.getString("lettercredit"))) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u586b\u5199[\u4fe1\u7528\u8bc1\u53f7]\u3002", (String)"LetterCreditApplySubmitValidator_2", (String)"tmc-lc-business", (Object[])new Object[0]));
        }
    }

    private void checkCreditLimit(ExtendedDataEntity dataEntity, DynamicObject applyBill) {
        DynamicObject creditLimit = applyBill.getDynamicObject("creditlimit");
        if (EmptyUtil.isEmpty((DynamicObject)creditLimit) || EmptyUtil.isEmpty((BigDecimal)applyBill.getBigDecimal("creditamount"))) {
            return;
        }
        CreditLimitUseBean bean = new CreditLimitUseBean();
        bean.setSourceType(applyBill.getDynamicObjectType().getName());
        bean.setPkId(Long.valueOf(applyBill.getLong("id")));
        DynamicObject letterCredit = applyBill.getDynamicObject("lettercredit");
        DynamicObject creditType = applyBill.getDynamicObject("credittype");
        DynamicObject applyOrg = applyBill.getDynamicObject("org");
        bean.setSourceBillId(EmptyUtil.isEmpty((DynamicObject)letterCredit) ? null : Long.valueOf(letterCredit.getLong("id")));
        DynamicObject limitType = creditType.getDynamicObject("creditlimittype");
        if (EmptyUtil.isNoEmpty((DynamicObject)limitType)) {
            bean.setCreditTypeId(Long.valueOf(limitType.getLong("id")));
        }
        bean.setOrgId(Long.valueOf(applyOrg.getLong("id")));
        bean.setCurrencyId(Long.valueOf(applyBill.getDynamicObject("currency").getLong("id")));
        bean.setCreditLimitId(Long.valueOf(creditLimit.getLong("id")));
        bean.setBizAmt(applyBill.getBigDecimal("creditamount"));
        CreditLimitF7ResBean result = CreditLimitServiceHelper.validataCreditLimitAmt((CreditLimitUseBean)bean);
        if (!result.getSuccess().booleanValue()) {
            this.addWarningMessage(dataEntity, result.getMsg());
        }
    }

    public void validateAmt(DynamicObject bizBill, ExtendedDataEntity dataEntity) {
        if (EmptyUtil.isNoEmpty((BigDecimal)bizBill.getBigDecimal("amount")) && EmptyUtil.isNoEmpty((DynamicObject)bizBill.getDynamicObject("creditlimit")) && EmptyUtil.isNoEmpty((BigDecimal)bizBill.getBigDecimal("suretymoney"))) {
            DynamicObject creditUseBill = CreditLimitServiceHelper.getCreditUseBill((Long)bizBill.getLong("id"), (String)bizBill.getDataEntityType().getName());
            BigDecimal creditAmount = EmptyUtil.isEmpty((DynamicObject)creditUseBill) ? bizBill.getBigDecimal("creditamount") : creditUseBill.getBigDecimal("bizcreditamount");
            BigDecimal letterAmount = LetterCreditHelper.getAmount((DynamicObject)bizBill);
            if (bizBill.getBigDecimal("suretymoney").add(creditAmount).compareTo(letterAmount) > 0) {
                this.addWarningMessage(dataEntity, ResManager.loadKDString((String)"\u6388\u4fe1\u9884\u5360\u91d1\u989d + \u4fdd\u8bc1\u91d1\u91d1\u989d\u5df2\u8d85\u51fa\u5f00\u8bc1\u7533\u8bf7\u91d1\u989d\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"LetterCreditApplySubmitValidator_7", (String)"tmc-lc-business", (Object[])new Object[0]));
            }
        }
    }
}

