/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.lc.business.validate.apply;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.BillChangeHistoryHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.lc.common.enums.LetterBizTypeEnum;
import kd.tmc.lc.common.enums.LetterCreditStatusEnum;
import kd.tmc.lc.common.helper.LetterCreditHelper;

public class LetterCreditApplyUnAuditValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List sic = super.getSelector();
        sic.add("biztype");
        sic.add("billstatus");
        sic.add("billno");
        return sic;
    }

    public void validate(ExtendedDataEntity[] dataEntities) throws KDBizException {
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject applyBill = dataEntity.getDataEntity();
            String bizType = applyBill.getString("biztype");
            DynamicObject letterCredit = applyBill.getDynamicObject("lettercredit");
            if (EmptyUtil.isNoEmpty((DynamicObject)letterCredit) && !LetterCreditStatusEnum.DONE_REGISTER.getValue().equals(letterCredit.getString("creditstatus")) && !LetterCreditStatusEnum.DONE_REPEAL.getValue().equals(letterCredit.getString("creditstatus"))) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4fe1\u7528\u8bc1\u72b6\u6001\u975e\u5df2\u767b\u8bb0\uff0c\u4e0d\u80fd\u53cd\u5ba1\u6838\u3002", (String)"LetterCreditApplyUnAuditValidator_5", (String)"tmc-lc-business", (Object[])new Object[0]));
            }
            if (LetterBizTypeEnum.EDIT_CARD.getValue().equals(bizType)) {
                boolean haveArrival;
                DynamicObject history = BillChangeHistoryHelper.getLastChangeHistoryByApplyId((Long)((Long)applyBill.getPkValue()), (String)"lc_lettercredit");
                if (EmptyUtil.isEmpty((DynamicObject)history)) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4e0d\u662f\u6700\u540e\u6539\u8bc1\u7533\u8bf7,\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6838\u3002", (String)"LetterCreditApplyUnAuditValidator_1", (String)"tmc-lc-business", (Object[])new Object[0]));
                }
                QFilter qFilter = new QFilter("billstatus", "in", (Object)new String[]{BillStatusEnum.SAVE.getValue(), BillStatusEnum.SUBMIT.getValue()});
                qFilter.and("lettercredit", "=", letterCredit.getPkValue());
                DynamicObjectCollection submitApply = QueryServiceHelper.query((String)"lc_bizapply", (String)"billno", (QFilter[])qFilter.toArray());
                if (EmptyUtil.isNoEmpty((DynamicObjectCollection)submitApply)) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5b58\u5728\u5728\u9014\u7684\u6539\u8bc1\u7533\u8bf7[%s],\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6838\u3002", (String)"LetterCreditApplyUnAuditValidator_4", (String)"tmc-lc-business", (Object[])new Object[]{((DynamicObject)submitApply.get(0)).getString("billno")}));
                }
                if (!(haveArrival = LetterCreditHelper.isHaveArrival((DynamicObject)letterCredit))) continue;
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4fe1\u7528\u8bc1\u5df2\u7ecf\u5b58\u5728\u5230\u5355\u4fe1\u606f\uff0c\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6838\u6539\u8bc1\u7533\u8bf7\u5355\u3002", (String)"LetterCreditApplyUnAuditValidator_3", (String)"tmc-lc-business", (Object[])new Object[0]));
                continue;
            }
            if (LetterBizTypeEnum.REPEAL_CARD.getValue().equals(bizType) && !LetterCreditStatusEnum.DONE_REPEAL.getValue().equals(letterCredit.getString("creditstatus"))) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4fe1\u7528\u8bc1\u72b6\u6001\u4e0d\u4e3a\u5df2\u64a4\u8bc1\u3002", (String)"LetterCreditApplyUnAuditValidator_6", (String)"tmc-lc-business", (Object[])new Object[]{LetterBizTypeEnum.REPEAL_CARD.getName()}));
                continue;
            }
            if (!LetterBizTypeEnum.CLOSE_CARD.getValue().equals(bizType)) continue;
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"%s\u7684\u4e1a\u52a1\u7533\u8bf7\uff0c\u4e0d\u5141\u8bb8\u518d\u505a\u53cd\u5ba1\u6838\u3002", (String)"LetterCreditApplyUnAuditValidator_2", (String)"tmc-lc-business", (Object[])new Object[]{LetterBizTypeEnum.CLOSE_CARD.getName()}));
        }
    }
}

