/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.lc.business.validate.arrival;

import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.BeBillStatusEnum;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.lc.common.enums.ArrivalStatusEnum;
import kd.tmc.lc.common.enums.TradeChannelEnum;

public class ArrivalBuyerIntValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("org");
        selector.add("benefiterother");
        selector.add("arrivalbank");
        selector.add("arrivalcurrency");
        selector.add("billstatus");
        selector.add("arrivalstatus");
        selector.add("buyerint");
        selector.add("tradechannel");
        selector.add("acceptbebankstatus");
        return selector;
    }

    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        this.validateKeyInfo(dataEntity);
        for (ExtendedDataEntity extendedDataEntity : dataEntity) {
            DynamicObject arrival = extendedDataEntity.getDataEntity();
            String billStatus = arrival.getString("billstatus");
            String arrivalStatus = arrival.getString("arrivalstatus");
            if (!StringUtils.equals((CharSequence)billStatus, (CharSequence)BillStatusEnum.AUDIT.getValue()) || !StringUtils.equals((CharSequence)arrivalStatus, (CharSequence)ArrivalStatusEnum.ARRIVAL_CONFIRM.getValue())) {
                this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u5355\u636e\u72b6\u6001\u4e3a\u5df2\u5ba1\u6838\uff0c\u5230\u5355\u72b6\u6001\u4e3a\u5230\u5355\u5df2\u786e\u8ba4\u624d\u5141\u8bb8\u6267\u884c\u4e70\u65b9\u4ed8\u606f\u3002", (String)"ArrivalBuyerIntValidator_1", (String)"tmc-lc-business", (Object[])new Object[0]));
                continue;
            }
            boolean buyerInt = arrival.getBoolean("buyerint");
            if (buyerInt) {
                this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u6ca1\u6709\u64cd\u4f5c\u8fc7\u4e70\u65b9\u4ed8\u606f\u624d\u5141\u8bb8\u6267\u884c\u4e70\u65b9\u4ed8\u606f\u3002", (String)"ArrivalBuyerIntValidator_2", (String)"tmc-lc-business", (Object[])new Object[0]));
            }
            if (!TradeChannelEnum.isOnline((String)arrival.getString("tradechannel")) || BeBillStatusEnum.isTS((String)arrival.getString("acceptbebankstatus"))) continue;
            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u94f6\u4f01\u6e20\u9053\u65f6\uff0c\u53ea\u6709\u5728\u201c\u627f\u5151\u76f4\u8054\u63d0\u4ea4\u72b6\u6001\u201d\u4e3a\u4ea4\u6613\u6210\u529f\u65f6\u624d\u80fd\u64cd\u4f5c\u4e70\u65b9\u4ed8\u606f\u3002", (String)"ArrivalBuyerIntValidator_3", (String)"tmc-lc-business", (Object[])new Object[0]));
        }
    }

    private void validateKeyInfo(ExtendedDataEntity[] dataEntity) {
        if (dataEntity.length == 1) {
            return;
        }
        List<String> checkProps = Arrays.asList("org", "benefiterother", "arrivalbank", "arrivalcurrency");
        for (String checkProp : checkProps) {
            Set propValues = Arrays.stream(dataEntity).map(ExtendedDataEntity::getDataEntity).map(v -> v.get(checkProp)).collect(Collectors.toSet());
            if (propValues.size() <= 1) continue;
            throw new KDBizException(ResManager.loadKDString((String)"\u6240\u6709\u5230\u5355\u7684\u5f00\u8bc1\u4eba\u3001\u53d7\u76ca\u4eba\u3001\u5230\u5355\u884c\u3001\u5230\u5355\u5e01\u79cd\u5747\u4e00\u81f4\u624d\u5141\u8bb8\u6267\u884c\u4e70\u65b9\u4ed8\u606f\u3002", (String)"ArrivalBuyerIntValidator_0", (String)"tmc-lc-business", (Object[])new Object[0]));
        }
    }
}

